/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import java.nio.ByteBuffer;
import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.buffer.VertexData;
import me.jellysquid.mods.sodium.client.gl.util.BufferSlice;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.BakedChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelVertexTransformer;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkModelOffset;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderType;

public class ChunkBuildBuffers {
    private final ChunkModelBuffers[] delegates;
    private final VertexBufferBuilder[][] buffersByLayer;
    private final ChunkVertexType vertexType;
    private final BlockRenderPassManager renderPassManager;
    private final ChunkModelOffset offset;

    public ChunkBuildBuffers(ChunkVertexType vertexType, BlockRenderPassManager renderPassManager) {
        this.vertexType = vertexType;
        this.renderPassManager = renderPassManager;
        this.delegates = new ChunkModelBuffers[BlockRenderPass.COUNT];
        this.buffersByLayer = new VertexBufferBuilder[BlockRenderPass.COUNT][ModelQuadFacing.COUNT];
        this.offset = new ChunkModelOffset();
        for (RenderType layer : RenderType.func_228661_n_()) {
            int passId = this.renderPassManager.getRenderPassId(layer);
            VertexBufferBuilder[] buffers = this.buffersByLayer[passId];
            for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
                buffers[facing.ordinal()] = new VertexBufferBuilder(vertexType.getBufferVertexFormat(), layer.func_228662_o_() / ModelQuadFacing.COUNT);
            }
        }
    }

    public void init(ChunkRenderData.Builder renderData) {
        for (int i = 0; i < this.buffersByLayer.length; ++i) {
            ModelVertexSink[] writers = new ChunkModelVertexTransformer[ModelQuadFacing.COUNT];
            for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
                writers[facing.ordinal()] = new ChunkModelVertexTransformer((ModelVertexSink)this.vertexType.createBufferWriter(this.buffersByLayer[i][facing.ordinal()], SodiumClientMod.isDirectMemoryAccessEnabled()), this.offset);
            }
            this.delegates[i] = new BakedChunkModelBuffers(writers, renderData);
        }
    }

    public ChunkModelBuffers get(RenderType layer) {
        return this.delegates[this.renderPassManager.getRenderPassId(layer)];
    }

    public ChunkMeshData createMesh(BlockRenderPass pass) {
        VertexBufferBuilder[] builders = this.buffersByLayer[pass.ordinal()];
        ChunkMeshData meshData = new ChunkMeshData();
        int bufferLen = 0;
        for (int facingId = 0; facingId < builders.length; ++facingId) {
            VertexBufferBuilder builder = builders[facingId];
            if (builder == null || builder.isEmpty()) continue;
            int n = bufferLen;
            int size = builder.getSize();
            meshData.setModelSlice(ModelQuadFacing.VALUES[facingId], new BufferSlice(n, size));
            bufferLen += size;
        }
        if (bufferLen <= 0) {
            return null;
        }
        ByteBuffer buffer = GLAllocation.func_74524_c((int)bufferLen);
        for (Map.Entry<ModelQuadFacing, BufferSlice> entry : meshData.getSlices()) {
            BufferSlice slice = entry.getValue();
            buffer.position(slice.start);
            VertexBufferBuilder builder = this.buffersByLayer[pass.ordinal()][entry.getKey().ordinal()];
            builder.copyInto(buffer);
        }
        buffer.flip();
        meshData.setVertexData(new VertexData(buffer, this.vertexType.getCustomVertexFormat()));
        return meshData;
    }

    public void setRenderOffset(int x, int y, int z) {
        this.offset.set(x, y, z);
    }
}

