/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.util.Direction;

public class ChunkRenderColumn<T extends ChunkGraphicsState> {
    private final ChunkRenderContainer<T>[] renders = new ChunkRenderContainer[16];
    private final ChunkRenderColumn<T>[] adjacent = new ChunkRenderColumn[6];
    private final int x;
    private final int z;

    public ChunkRenderColumn(int x, int z) {
        this.x = x;
        this.z = z;
        this.setAdjacentColumn(Direction.UP, this);
        this.setAdjacentColumn(Direction.DOWN, this);
    }

    public void setAdjacentColumn(Direction dir, ChunkRenderColumn<T> column) {
        this.adjacent[dir.ordinal()] = column;
    }

    public ChunkRenderColumn<T> getAdjacentColumn(Direction dir) {
        return this.adjacent[dir.ordinal()];
    }

    public void setRender(int y, ChunkRenderContainer<T> render) {
        this.renders[y] = render;
    }

    public ChunkRenderContainer<T> getRender(int y) {
        if (y < 0 || y >= this.renders.length) {
            return null;
        }
        return this.renders[y];
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean areNeighborsPresent() {
        for (Direction dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            Direction corner;
            ChunkRenderColumn<T> adj = this.adjacent[dir.ordinal()];
            if (adj == null) {
                return false;
            }
            if (dir == Direction.NORTH) {
                corner = Direction.EAST;
            } else if (dir == Direction.SOUTH) {
                corner = Direction.WEST;
            } else if (dir == Direction.WEST) {
                corner = Direction.NORTH;
            } else {
                if (dir != Direction.EAST) continue;
                corner = Direction.SOUTH;
            }
            if (adj.getAdjacentColumn(corner) != null) continue;
            return false;
        }
        return true;
    }
}

