/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.SortedSet;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.compat.flywheel.FlywheelCompat;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderManager;
import me.jellysquid.mods.sodium.client.render.chunk.backends.multidraw.MultidrawChunkRenderBackend;
import me.jellysquid.mods.sodium.client.render.chunk.backends.oneshot.ChunkRenderBackendOneshot;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.format.DefaultModelVertexFormats;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheShared;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListenerManager;
import me.jellysquid.mods.sodium.common.util.ListUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;

public class SodiumWorldRenderer
implements ChunkStatusListener {
    private static SodiumWorldRenderer instance;
    private final Minecraft client;
    private ClientWorld world;
    private int renderDistance;
    private double lastCameraX;
    private double lastCameraY;
    private double lastCameraZ;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private boolean useEntityCulling;
    private final LongSet loadedChunkPositions = new LongOpenHashSet();
    private final Set<TileEntity> globalBlockEntities = new ObjectOpenHashSet();
    private ClippingHelper frustum;
    private ChunkRenderManager<?> chunkRenderManager;
    private BlockRenderPassManager renderPassManager;
    private ChunkRenderBackend<?> chunkRenderBackend;
    public static boolean hasChanges;

    public static SodiumWorldRenderer create() {
        if (instance == null) {
            instance = new SodiumWorldRenderer(Minecraft.func_71410_x());
        }
        return instance;
    }

    public static SodiumWorldRenderer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Renderer not initialized");
        }
        return instance;
    }

    private SodiumWorldRenderer(Minecraft client) {
        this.client = client;
    }

    public void setWorld(ClientWorld world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            this.unloadWorld();
        }
        if (world != null) {
            this.loadWorld(world);
        }
    }

    private void loadWorld(ClientWorld world) {
        this.world = world;
        ChunkRenderCacheShared.createRenderContext((IBlockDisplayReader)this.world);
        this.initRenderer();
        ((ChunkStatusListenerManager)world.func_72863_F()).setListener(this);
    }

    private void unloadWorld() {
        ChunkRenderCacheShared.destroyRenderContext((IBlockDisplayReader)this.world);
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        this.loadedChunkPositions.clear();
        this.globalBlockEntities.clear();
        this.world = null;
    }

    public int getVisibleChunkCount() {
        return this.chunkRenderManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.markDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.chunkRenderManager.isBuildComplete();
    }

    public void updateChunks(ActiveRenderInfo camera, ClippingHelper frustum, boolean hasForcedFrustum, int frame, boolean spectator) {
        boolean dirty;
        this.frustum = frustum;
        this.useEntityCulling = SodiumClientMod.options().advanced.useEntityCulling;
        IProfiler profiler = this.client.func_213239_aq();
        profiler.func_76320_a("camera_setup");
        ClientPlayerEntity player = this.client.field_71439_g;
        if (player == null) {
            throw new IllegalStateException("Client instance has no active player entity");
        }
        Vector3d pos = camera.func_216785_c();
        float pitch = camera.func_216777_e();
        float yaw = camera.func_216778_f();
        boolean bl = dirty = pos.field_72450_a != this.lastCameraX || pos.field_72448_b != this.lastCameraY || pos.field_72449_c != this.lastCameraZ || (double)pitch != this.lastCameraPitch || (double)yaw != this.lastCameraYaw;
        if (dirty) {
            this.chunkRenderManager.markDirty();
        }
        this.lastCameraX = pos.field_72450_a;
        this.lastCameraY = pos.field_72448_b;
        this.lastCameraZ = pos.field_72449_c;
        this.lastCameraPitch = pitch;
        this.lastCameraYaw = yaw;
        profiler.func_219895_b("chunk_update");
        this.chunkRenderManager.updateChunks();
        if (!hasForcedFrustum && this.chunkRenderManager.isDirty()) {
            profiler.func_219895_b("chunk_graph_rebuild");
            this.chunkRenderManager.update(camera, (FrustumExtended)frustum, frame, spectator);
        }
        profiler.func_219895_b("visible_chunk_tick");
        this.chunkRenderManager.tickVisibleRenders();
        profiler.func_76319_b();
        Entity.func_184227_b((double)(MathHelper.func_151237_a((double)((double)this.client.field_71474_y.field_151451_c / 8.0), (double)1.0, (double)2.5) * (double)this.client.field_71474_y.field_238329_c_));
    }

    public void drawChunkLayer(RenderType renderLayer, MatrixStack matrixStack, double x, double y, double z) {
        BlockRenderPass pass = this.renderPassManager.getRenderPassForLayer(renderLayer);
        pass.startDrawing();
        this.chunkRenderManager.renderLayer(matrixStack, pass, x, y, z);
        pass.endDrawing();
        RenderSystem.clearCurrentColor();
    }

    public void reload() {
        if (this.world == null) {
            return;
        }
        this.initRenderer();
    }

    private void initRenderer() {
        if (this.chunkRenderManager != null) {
            this.chunkRenderManager.destroy();
            this.chunkRenderManager = null;
        }
        if (this.chunkRenderBackend != null) {
            this.chunkRenderBackend.delete();
            this.chunkRenderBackend = null;
        }
        RenderDevice device = RenderDevice.INSTANCE;
        SodiumGameOptions opts = SodiumClientMod.options();
        this.renderPassManager = BlockRenderPassManager.createDefaultMappings();
        ChunkVertexType vertexFormat = opts.advanced.useCompactVertexFormat ? DefaultModelVertexFormats.MODEL_VERTEX_HFP : DefaultModelVertexFormats.MODEL_VERTEX_SFP;
        this.chunkRenderBackend = SodiumWorldRenderer.createChunkRenderBackend(device, opts, vertexFormat);
        this.chunkRenderBackend.createShaders(device);
        this.chunkRenderManager = new ChunkRenderManager(this, this.chunkRenderBackend, this.renderPassManager, this.world, this.client.field_71474_y.field_151451_c);
        this.chunkRenderManager.restoreChunks((LongCollection)this.loadedChunkPositions);
    }

    private static ChunkRenderBackend<?> createChunkRenderBackend(RenderDevice device, SodiumGameOptions options, ChunkVertexType vertexFormat) {
        boolean disableBlacklist = SodiumClientMod.options().advanced.ignoreDriverBlacklist;
        if (options.advanced.useChunkMultidraw && MultidrawChunkRenderBackend.isSupported(disableBlacklist)) {
            return new MultidrawChunkRenderBackend(device, vertexFormat);
        }
        return new ChunkRenderBackendOneshot(vertexFormat);
    }

    public void renderTileEntities(MatrixStack matrices, RenderTypeBuffers bufferBuilders, Long2ObjectMap<SortedSet<DestroyBlockProgress>> blockBreakingProgressions, ActiveRenderInfo camera, float tickDelta) {
        BlockPos pos;
        IRenderTypeBuffer.Impl immediate = bufferBuilders.func_228487_b_();
        Vector3d cameraPos = camera.func_216785_c();
        double x = cameraPos.func_82615_a();
        double y = cameraPos.func_82617_b();
        double z = cameraPos.func_82616_c();
        for (TileEntity blockEntity : this.chunkRenderManager.getVisibleBlockEntities()) {
            int stage;
            pos = blockEntity.func_174877_v();
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)pos.func_177958_n() - x, (double)pos.func_177956_o() - y, (double)pos.func_177952_p() - z);
            IRenderTypeBuffer.Impl consumer = immediate;
            SortedSet breakingInfos = (SortedSet)blockBreakingProgressions.get(pos.func_218275_a());
            if (breakingInfos != null && !breakingInfos.isEmpty() && (stage = ((DestroyBlockProgress)breakingInfos.last()).func_73106_e()) >= 0) {
                MatrixStack.Entry entry = matrices.func_227866_c_();
                MatrixApplyingVertexBuilder transformer = new MatrixApplyingVertexBuilder(bufferBuilders.func_228489_c_().getBuffer((RenderType)ModelBakery.field_229320_k_.get(stage)), entry.func_227870_a_(), entry.func_227872_b_());
                consumer = arg_0 -> SodiumWorldRenderer.lambda$renderTileEntities$0((IVertexBuilder)transformer, immediate, arg_0);
            }
            TileEntityRendererDispatcher.field_147556_a.func_228850_a_(blockEntity, tickDelta, matrices, (IRenderTypeBuffer)consumer);
            matrices.func_227865_b_();
        }
        for (TileEntity blockEntity : this.globalBlockEntities) {
            pos = blockEntity.func_174877_v();
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)pos.func_177958_n() - x, (double)pos.func_177956_o() - y, (double)pos.func_177952_p() - z);
            TileEntityRendererDispatcher.field_147556_a.func_228850_a_(blockEntity, tickDelta, matrices, (IRenderTypeBuffer)immediate);
            matrices.func_227865_b_();
        }
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.loadedChunkPositions.add(ChunkPos.func_77272_a((int)x, (int)z));
        this.chunkRenderManager.onChunkAdded(x, z);
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.loadedChunkPositions.remove(ChunkPos.func_77272_a((int)x, (int)z));
        this.chunkRenderManager.onChunkRemoved(x, z);
    }

    public void onChunkRenderUpdated(int x, int y, int z, ChunkRenderData meshBefore, ChunkRenderData meshAfter) {
        ListUtil.updateList(this.globalBlockEntities, meshBefore.getGlobalBlockEntities(), meshAfter.getGlobalBlockEntities());
        FlywheelCompat.filterBlockEntityList(this.globalBlockEntities);
        this.chunkRenderManager.onChunkRenderUpdates(x, y, z, meshAfter);
    }

    public boolean isEntityVisible(Entity entity) {
        if (!this.useEntityCulling) {
            return true;
        }
        AxisAlignedBB box = entity.func_184177_bl();
        if (box.field_72337_e < 0.5 || box.field_72338_b > 255.5) {
            return true;
        }
        if (this.client.func_238206_b_(entity) || entity.func_94059_bO()) {
            return true;
        }
        int minX = MathHelper.func_76128_c((double)(box.field_72340_a - 0.5)) >> 4;
        int minY = MathHelper.func_76128_c((double)(box.field_72338_b - 0.5)) >> 4;
        int minZ = MathHelper.func_76128_c((double)(box.field_72339_c - 0.5)) >> 4;
        int maxX = MathHelper.func_76128_c((double)(box.field_72336_d + 0.5)) >> 4;
        int maxY = MathHelper.func_76128_c((double)(box.field_72337_e + 0.5)) >> 4;
        int maxZ = MathHelper.func_76128_c((double)(box.field_72334_f + 0.5)) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.chunkRenderManager.isChunkVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ClippingHelper getFrustum() {
        return this.frustum;
    }

    public String getChunksDebugString() {
        return String.format("C: %s/%s", this.chunkRenderManager.getVisibleChunkCount(), this.chunkRenderManager.getTotalSections());
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        this.scheduleRebuildForChunks(minX >> 4, minY >> 4, minZ >> 4, maxX >> 4, maxY >> 4, maxZ >> 4, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.chunkRenderManager.scheduleRebuild(x, y, z, important);
    }

    public ChunkRenderBackend<?> getChunkRenderer() {
        return this.chunkRenderBackend;
    }

    private static /* synthetic */ IVertexBuilder lambda$renderTileEntities$0(IVertexBuilder transformer, IRenderTypeBuffer.Impl immediate, RenderType layer) {
        return layer.func_228665_s_() ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)transformer, (IVertexBuilder)immediate.getBuffer(layer)) : immediate.getBuffer(layer);
    }

    static {
        hasChanges = false;
    }
}

