/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.BlockColorSettings;
import me.jellysquid.mods.sodium.client.model.quad.blender.FlatBiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.SmoothBiomeColorBlender;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

class ConfigurableColorBlender
implements BiomeColorBlender {
    private final BiomeColorBlender defaultBlender = new FlatBiomeColorBlender();
    private final BiomeColorBlender smoothBlender;

    public ConfigurableColorBlender(Minecraft client) {
        this.smoothBlender = ConfigurableColorBlender.isSmoothBlendingEnabled(client) ? new SmoothBiomeColorBlender() : this.defaultBlender;
    }

    private static boolean isSmoothBlendingEnabled(Minecraft client) {
        return client.field_71474_y.field_205217_U > 0;
    }

    @Override
    public int[] getColors(IBlockColor colorizer, IBlockDisplayReader world, BlockState state, BlockPos origin, ModelQuadView quad) {
        BiomeColorBlender blender = BlockColorSettings.isSmoothBlendingEnabled(world, state, origin) ? this.smoothBlender : this.defaultBlender;
        return blender.getColors(colorizer, world, state, origin, quad);
    }
}

