/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public abstract class AbstractWidget
implements IRenderable,
IGuiEventListener {
    protected final FontRenderer font;

    protected AbstractWidget() {
        this.font = Minecraft.func_71410_x().field_71466_p;
    }

    protected void drawString(MatrixStack matrixStack, String str, int x, int y, int color) {
        this.font.func_238421_b_(matrixStack, str, (float)x, (float)y, color);
    }

    protected void drawText(MatrixStack matrixStack, ITextComponent text, int x, int y, int color) {
        this.font.func_243248_b(matrixStack, text, (float)x, (float)y, color);
    }

    protected void drawRect(double x1, double y1, double x2, double y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> AbstractWidget.addQuad(vertices, x1, y1, x2, y2, a, r, g, b));
    }

    protected void drawQuads(Consumer<IVertexBuilder> consumer) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        consumer.accept((IVertexBuilder)bufferBuilder);
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected static void addQuad(IVertexBuilder consumer, double x1, double y1, double x2, double y2, float a, float r, float g, float b) {
        consumer.func_225582_a_(x2, y1, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        consumer.func_225582_a_(x1, y1, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        consumer.func_225582_a_(x1, y2, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        consumer.func_225582_a_(x2, y2, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
    }

    protected void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected int getStringWidth(String text) {
        return this.font.func_78256_a(text);
    }

    protected int getTextWidth(ITextComponent text) {
        return this.font.func_238414_a_((ITextProperties)text);
    }
}

