/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat.ccl;

import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.registries.IRegistryDelegate;
import org.jetbrains.annotations.NotNull;

public class CCLCompat {
    public static Map<IRegistryDelegate<Block>, ICCBlockRenderer> customBlockRenderers;
    public static Map<IRegistryDelegate<Fluid>, ICCBlockRenderer> customFluidRenderers;
    public static List<ICCBlockRenderer> customGlobalRenderers;

    @NotNull
    public static List<ICCBlockRenderer> getCustomRenderers(@NotNull IBlockDisplayReader world, @NotNull BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        FluidState fluidState = state.func_204520_s();
        Fluid fluid = fluidState.func_206886_c();
        if (customGlobalRenderers == null) {
            return new ArrayList<ICCBlockRenderer>();
        }
        ArrayList<ICCBlockRenderer> renderers = new ArrayList<ICCBlockRenderer>(customGlobalRenderers);
        if (customBlockRenderers != null) {
            for (Map.Entry<IRegistryDelegate<Block>, ICCBlockRenderer> entry : customBlockRenderers.entrySet()) {
                Block entryBlock = (Block)entry.getKey().get();
                if (!entryBlock.func_235332_a_(block)) continue;
                renderers.add(entry.getValue());
            }
        }
        if (customFluidRenderers != null) {
            for (Map.Entry<IRegistryDelegate<Block>, ICCBlockRenderer> entry : customFluidRenderers.entrySet()) {
                Fluid entryFluid = (Fluid)entry.getKey().get();
                if (!entryFluid.func_207187_a(fluid)) continue;
                renderers.add(entry.getValue());
            }
        }
        return renderers;
    }

    public static void init() {
        try {
            SodiumClientMod.logger().info("Retrieving block renderers");
            Field blockRenderersField = BlockRenderingRegistry.class.getDeclaredField("blockRenderers");
            blockRenderersField.setAccessible(true);
            customBlockRenderers = (Map)blockRenderersField.get(null);
            SodiumClientMod.logger().info("Retrieving fluid renderers");
            Field fluidRenderersField = BlockRenderingRegistry.class.getDeclaredField("fluidRenderers");
            fluidRenderersField.setAccessible(true);
            customFluidRenderers = (Map)fluidRenderersField.get(null);
            SodiumClientMod.logger().info("Retrieving global renderers");
            Field globalRenderersField = BlockRenderingRegistry.class.getDeclaredField("globalRenderers");
            globalRenderersField.setAccessible(true);
            customGlobalRenderers = (List)globalRenderersField.get(null);
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Could not retrieve custom renderers");
        }
    }
}

