/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.proxy;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.ClientEvents;
import com.mrcrayfish.vehicle.client.ControllerEvents;
import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.client.HeldVehicleEvents;
import com.mrcrayfish.vehicle.client.ISpecialModel;
import com.mrcrayfish.vehicle.client.RayTraceFunction;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.audio.MovingSoundHorn;
import com.mrcrayfish.vehicle.client.audio.MovingSoundHornRiding;
import com.mrcrayfish.vehicle.client.audio.MovingSoundVehicle;
import com.mrcrayfish.vehicle.client.audio.MovingSoundVehicleRiding;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.client.render.JackRenderer;
import com.mrcrayfish.vehicle.client.render.RenderBoatWrapper;
import com.mrcrayfish.vehicle.client.render.RenderEntityVehicle;
import com.mrcrayfish.vehicle.client.render.RenderHelicopterWrapper;
import com.mrcrayfish.vehicle.client.render.RenderLandVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.RenderMotorcycleWrapper;
import com.mrcrayfish.vehicle.client.render.RenderPlaneWrapper;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.client.render.tileentity.FluidExtractorRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.FuelDrumRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.GasPumpRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.GasPumpTankRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.VehicleCrateRenderer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderATV;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderAluminumBoat;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderBath;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderBumperCar;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderCouch;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderCouchHelicopter;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderDirtBike;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderDuneBuggy;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderFertilizerTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderFluidTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderGoKart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderGolfCart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderJetSki;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderLawnMower;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMiniBike;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMiniBus;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMoped;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderOffRoader;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSeederTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderShoppingCart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSmartCar;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSpeedBoat;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSportsPlane;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderStorageTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderTractor;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderVehicleTrailer;
import com.mrcrayfish.vehicle.client.screen.EditVehicleScreen;
import com.mrcrayfish.vehicle.client.screen.FluidExtractorScreen;
import com.mrcrayfish.vehicle.client.screen.FluidMixerScreen;
import com.mrcrayfish.vehicle.client.screen.StorageScreen;
import com.mrcrayfish.vehicle.client.screen.WorkstationScreen;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.entity.HelicopterEntity;
import com.mrcrayfish.vehicle.entity.PlaneEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModContainers;
import com.mrcrayfish.vehicle.init.ModEntities;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.item.KeyItem;
import com.mrcrayfish.vehicle.item.PartItem;
import com.mrcrayfish.vehicle.item.SprayCanItem;
import com.mrcrayfish.vehicle.proxy.Proxy;
import com.mrcrayfish.vehicle.util.FluidUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientProxy
implements Proxy {
    public static final KeyBinding KEY_HORN = new KeyBinding("key.vehicle.horn", 72, "key.categories.vehicle");
    public static final KeyBinding KEY_CYCLE_SEATS = new KeyBinding("key.vehicle.cycle_seats", 67, "key.categories.vehicle");
    public static boolean controllableLoaded = false;
    private static final WeakHashMap<UUID, Map<SoundType, ITickableSound>> SOUND_TRACKER = new WeakHashMap();

    @Override
    public void setupClient() {
        if (ModList.get().isLoaded("controllable")) {
            controllableLoaded = true;
            MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
        }
        MinecraftForge.EVENT_BUS.register((Object)EntityRayTracer.instance());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)new HeldVehicleEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupRenderLayers();
        this.registerEntityRenders();
        this.bindTileEntityRenders();
        this.registerKeyBindings();
        this.registerScreenFactories();
        this.registerItemColors();
        this.registerRayTraceConstructors();
        IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
        if (rm instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)rm).func_219534_a((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> ((CompletableFuture)CompletableFuture.runAsync(() -> {
                FluidUtils.clearCacheFluidColor();
                EntityRayTracer.instance().clearDataForReregistration();
            }, backgroundExecutor).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).whenComplete((aVoid, throwable) -> SpecialModels.clearModelCache()));
        }
    }

    private void setupRenderLayers() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WORKSTATION.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.FLUID_EXTRACTOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GAS_PUMP.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.FUELIUM.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_FUELIUM.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.ENDER_SAP.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_ENDER_SAP.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.BLAZE_JUICE.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_BLAZE_JUICE.get()), (RenderType)RenderType.func_228645_f_());
    }

    private void registerEntityRenders() {
        this.registerVehicleRender((EntityType)ModEntities.ATV.get(), new RenderLandVehicleWrapper(new RenderATV()));
        this.registerVehicleRender((EntityType)ModEntities.DUNE_BUGGY.get(), new RenderLandVehicleWrapper(new RenderDuneBuggy()));
        this.registerVehicleRender((EntityType)ModEntities.GO_KART.get(), new RenderLandVehicleWrapper(new RenderGoKart()));
        this.registerVehicleRender((EntityType)ModEntities.SHOPPING_CART.get(), new RenderLandVehicleWrapper(new RenderShoppingCart()));
        this.registerVehicleRender((EntityType)ModEntities.MINI_BIKE.get(), new RenderMotorcycleWrapper(new RenderMiniBike()));
        this.registerVehicleRender((EntityType)ModEntities.BUMPER_CAR.get(), new RenderLandVehicleWrapper(new RenderBumperCar()));
        this.registerVehicleRender((EntityType)ModEntities.JET_SKI.get(), new RenderBoatWrapper(new RenderJetSki()));
        this.registerVehicleRender((EntityType)ModEntities.SPEED_BOAT.get(), new RenderBoatWrapper(new RenderSpeedBoat()));
        this.registerVehicleRender((EntityType)ModEntities.ALUMINUM_BOAT.get(), new RenderBoatWrapper(new RenderAluminumBoat()));
        this.registerVehicleRender((EntityType)ModEntities.SMART_CAR.get(), new RenderLandVehicleWrapper(new RenderSmartCar()));
        this.registerVehicleRender((EntityType)ModEntities.LAWN_MOWER.get(), new RenderLandVehicleWrapper(new RenderLawnMower()));
        this.registerVehicleRender((EntityType)ModEntities.MOPED.get(), new RenderMotorcycleWrapper(new RenderMoped()));
        this.registerVehicleRender((EntityType)ModEntities.SPORTS_PLANE.get(), new RenderPlaneWrapper(new RenderSportsPlane()));
        this.registerVehicleRender((EntityType)ModEntities.GOLF_CART.get(), new RenderLandVehicleWrapper(new RenderGolfCart()));
        this.registerVehicleRender((EntityType)ModEntities.OFF_ROADER.get(), new RenderLandVehicleWrapper(new RenderOffRoader()));
        this.registerVehicleRender((EntityType)ModEntities.TRACTOR.get(), new RenderLandVehicleWrapper(new RenderTractor()));
        this.registerVehicleRender((EntityType)ModEntities.MINI_BUS.get(), new RenderLandVehicleWrapper(new RenderMiniBus()));
        this.registerVehicleRender((EntityType)ModEntities.DIRT_BIKE.get(), new RenderMotorcycleWrapper(new RenderDirtBike()));
        this.registerVehicleRender((EntityType)ModEntities.VEHICLE_TRAILER.get(), new RenderVehicleWrapper(new RenderVehicleTrailer()));
        this.registerVehicleRender((EntityType)ModEntities.STORAGE_TRAILER.get(), new RenderVehicleWrapper(new RenderStorageTrailer()));
        this.registerVehicleRender((EntityType)ModEntities.FLUID_TRAILER.get(), new RenderVehicleWrapper(new RenderFluidTrailer()));
        this.registerVehicleRender((EntityType)ModEntities.SEEDER.get(), new RenderVehicleWrapper(new RenderSeederTrailer()));
        this.registerVehicleRender((EntityType)ModEntities.FERTILIZER.get(), new RenderVehicleWrapper(new RenderFertilizerTrailer()));
        if (ModList.get().isLoaded("cfm")) {
            this.registerVehicleRender((EntityType)ModEntities.SOFA.get(), new RenderLandVehicleWrapper(new RenderCouch()));
            this.registerVehicleRender((EntityType)ModEntities.BATH.get(), new RenderPlaneWrapper(new RenderBath()));
            this.registerVehicleRender((EntityType)ModEntities.SOFACOPTER.get(), new RenderHelicopterWrapper(new RenderCouchHelicopter()));
        }
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.JACK.get()), JackRenderer::new);
    }

    private <T extends VehicleEntity, R extends AbstractRenderVehicle<T>> void registerVehicleRender(EntityType<T> type, RenderVehicleWrapper<T, R> wrapper) {
        RenderingRegistry.registerEntityRenderingHandler(type, manager -> new RenderEntityVehicle(manager, wrapper));
        VehicleRenderRegistry.registerRenderWrapper(type, wrapper);
    }

    private void bindTileEntityRenders() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.FLUID_EXTRACTOR.get()), FluidExtractorRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.FUEL_DRUM.get()), FuelDrumRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.INDUSTRIAL_FUEL_DRUM.get()), FuelDrumRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.VEHICLE_CRATE.get()), VehicleCrateRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.JACK.get()), com.mrcrayfish.vehicle.client.render.tileentity.JackRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.GAS_PUMP.get()), GasPumpRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.GAS_PUMP_TANK.get()), GasPumpTankRenderer::new);
    }

    private void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_HORN);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_CYCLE_SEATS);
    }

    private void registerScreenFactories() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.FLUID_EXTRACTOR.get()), FluidExtractorScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.FLUID_MIXER.get()), FluidMixerScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.EDIT_VEHICLE.get()), EditVehicleScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.WORKSTATION.get()), WorkstationScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.STORAGE.get()), StorageScreen::new);
    }

    private void registerItemColors() {
        IItemColor color = (stack, index) -> {
            if (index == 0 && stack.func_77942_o() && stack.func_77978_p().func_150297_b("Color", 3)) {
                return stack.func_77978_p().func_74762_e("Color");
            }
            return 0xFFFFFF;
        };
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof SprayCanItem || item instanceof KeyItem || item instanceof PartItem && ((PartItem)((Object)item)).isColored()) {
                Minecraft.func_71410_x().getItemColors().func_199877_a(color, new IItemProvider[]{item});
            }
        });
    }

    private void registerRayTraceConstructors() {
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.ALUMINUM_BOAT.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.ALUMINUM_BOAT_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ALUMINUM_BOAT.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.ATV.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.ATV_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.ATV_HANDLES, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.3375f, 0.25f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.025f, 0.0f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.TOW_BAR, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, 180.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.5f, 1.05f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ATV.get()), SpecialModels.SMALL_FUEL_DOOR_CLOSED, parts, transforms);
            EntityRayTracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ATV.get()), parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.BUMPER_CAR.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.BUMPER_CAR_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.2f, 0.0f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.02f, 0.0f), EntityRayTracer.MatrixTransformation.createScale(0.9f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.BUMPER_CAR.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.DIRT_BIKE.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.DIRT_BIKE_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.DIRT_BIKE_HANDLES, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.DIRT_BIKE.get()), SpecialModels.SMALL_FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.DUNE_BUGGY.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.DUNE_BUGGY_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.DUNE_BUGGY_HANDLES, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.0f, -0.0046875f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.DUNE_BUGGY.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.GO_KART.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.09f, 0.49f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.02f, 0.0f), EntityRayTracer.MatrixTransformation.createScale(0.9f));
            EntityRayTracer.createPartTransforms((Item)ModItems.WOOD_SMALL_ENGINE.get(), VehicleProperties.getProperties((EntityType)ModEntities.GO_KART.get()).getEnginePosition(), (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, RayTraceFunction.FUNCTION_FUELING);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.JET_SKI.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.JET_SKI_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.ATV_HANDLES, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.375f, 0.25f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.02f, 0.0f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.JET_SKI.get()), SpecialModels.SMALL_FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.LAWN_MOWER.get(), (entityRayTracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.LAWN_MOWER_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.4f, -0.15f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createScale(0.9f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.TOW_BAR, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, 180.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.5f, 0.6f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.LAWN_MOWER.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.MINI_BIKE.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.MINI_BIKE_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.MINI_BIKE_HANDLES, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createPartTransforms((Item)ModItems.WOOD_SMALL_ENGINE.get(), VehicleProperties.getProperties((EntityType)ModEntities.MINI_BIKE.get()).getEnginePosition(), (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, RayTraceFunction.FUNCTION_FUELING);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.MOPED.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.MOPED_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.MOPED_HANDLES, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.0625f, 0.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.835f, 0.525f), EntityRayTracer.MatrixTransformation.createScale(0.8f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.MOPED_MUD_GUARD, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.0625f, 0.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.12f, 0.785f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -22.5f), EntityRayTracer.MatrixTransformation.createScale(0.9f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MOPED.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.SHOPPING_CART.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SHOPPING_CART_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]));
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.SMART_CAR.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SMART_CAR_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.2f, 0.3f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -67.5f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.02f, 0.0f), EntityRayTracer.MatrixTransformation.createScale(0.9f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.TOW_BAR, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, 180.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.5f, 1.35f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SMART_CAR.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.SPEED_BOAT.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPEED_BOAT_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.215f, -0.125f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.02f, 0.0f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPEED_BOAT.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.SPORTS_PLANE.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPORTS_PLANE.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
            EntityRayTracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPORTS_PLANE.get()), parts, transforms);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WING, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.1875f, 0.5f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Z, 180.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.875f, 0.0625f, 0.0f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, 5.0f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WING, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.875f, -0.1875f, 0.5f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -5.0f));
            transforms.add(EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.5f, 0.0f));
            transforms.add(EntityRayTracer.MatrixTransformation.createScale(0.85f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.1875f, 1.5f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_LEG, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.1875f, 1.5f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(-0.46875f, -0.1875f, 0.125f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_LEG, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(-0.46875f, -0.1875f, 0.125f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, -100.0f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.46875f, -0.1875f, 0.125f));
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_LEG, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.46875f, -0.1875f, 0.125f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, 100.0f));
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.GOLF_CART.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GOLF_CART_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(-0.345f, 0.425f, 0.1f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.02f, 0.0f), EntityRayTracer.MatrixTransformation.createScale(0.95f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GOLF_CART.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
            EntityRayTracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GOLF_CART.get()), parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.OFF_ROADER.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.OFF_ROADER_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(-0.3125f, 0.35f, 0.2f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -45.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.02f, 0.0f), EntityRayTracer.MatrixTransformation.createScale(0.75f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.OFF_ROADER.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
            EntityRayTracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.OFF_ROADER.get()), parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.TRACTOR.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.TRACTOR, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.66f, -0.475f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -67.5f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.02f, 0.0f), EntityRayTracer.MatrixTransformation.createScale(0.9f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.TRACTOR.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
            EntityRayTracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.TRACTOR.get()), parts, transforms);
        });
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.MINI_BUS.get(), (tracer, transforms, parts) -> {
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.MINI_BUS_BODY, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]);
            EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(-0.2825f, 0.225f, 1.0625f), EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_X, -67.5f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, -0.02f, 0.0f), EntityRayTracer.MatrixTransformation.createScale(0.75f));
            EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BUS.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
            EntityRayTracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BUS.get()), parts, transforms);
        });
        if (ModList.get().isLoaded("cfm")) {
            EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.BATH.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cfm:bath")), (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, 90.0f)));
            EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.SOFA.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.RAINBOW_SOFA, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, 90.0f), EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.0625f, 0.0f)));
            EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.SOFACOPTER.get(), (tracer, transforms, parts) -> {
                EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.RED_SOFA, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createRotation(Axis.POSITIVE_Y, 90.0f));
                EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SOFA_HELICOPTER_ARM, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, EntityRayTracer.MatrixTransformation.createTranslation(0.0f, 0.5f, 0.0f));
                EntityRayTracer.createFuelPartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFACOPTER.get()), SpecialModels.FUEL_DOOR_CLOSED, parts, transforms);
                EntityRayTracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFACOPTER.get()), parts, transforms);
            });
        }
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.VEHICLE_TRAILER.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.VEHICLE_TRAILER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]));
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.STORAGE_TRAILER.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.STORAGE_TRAILER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]));
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.SEEDER.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.SEEDER_TRAILER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]));
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.FERTILIZER.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.FERTILIZER_TRAILER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]));
        EntityRayTracer.instance().registerTransforms((EntityType)ModEntities.FLUID_TRAILER.get(), (tracer, transforms, parts) -> EntityRayTracer.createTransformListForPart((ISpecialModel)SpecialModels.FLUID_TRAILER, (HashMap<EntityRayTracer.RayTracePart, List<EntityRayTracer.MatrixTransformation>>)parts, (List<EntityRayTracer.MatrixTransformation>)transforms, new EntityRayTracer.MatrixTransformation[0]));
    }

    @Override
    public void playVehicleSound(PlayerEntity player, PoweredVehicleEntity vehicle) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            Object sound;
            Map soundMap = SOUND_TRACKER.computeIfAbsent(vehicle.func_110124_au(), uuid -> new HashMap());
            if (vehicle.getRidingSound() != null && player.equals((Object)Minecraft.func_71410_x().field_71439_g) && ((sound = (ITickableSound)soundMap.get((Object)SoundType.ENGINE_RIDING)) == null || sound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundVehicleRiding(player, vehicle);
                soundMap.put(SoundType.ENGINE_RIDING, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
            if (!(vehicle.getMovingSound() == null || player.equals((Object)Minecraft.func_71410_x().field_71439_g) || (sound = (ITickableSound)soundMap.get((Object)SoundType.ENGINE)) != null && !sound.func_147667_k() && Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundVehicle(vehicle);
                soundMap.put(SoundType.ENGINE, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundVehicle(vehicle));
            }
            if (!(vehicle.getHornSound() == null || player.equals((Object)Minecraft.func_71410_x().field_71439_g) || (sound = (ITickableSound)soundMap.get((Object)SoundType.HORN)) != null && !sound.func_147667_k() && Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundHorn(vehicle);
                soundMap.put(SoundType.HORN, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
            if (vehicle.getHornRidingSound() != null && player.equals((Object)Minecraft.func_71410_x().field_71439_g) && ((sound = (ITickableSound)soundMap.get((Object)SoundType.HORN_RIDING)) == null || sound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundHornRiding(player, vehicle);
                soundMap.put(SoundType.HORN_RIDING, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
        });
    }

    @Override
    public void playSound(SoundEvent soundEvent, BlockPos pos, float volume, float pitch) {
        SimpleSound sound = new SimpleSound(soundEvent, SoundCategory.BLOCKS, volume, pitch, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
        Minecraft.func_71410_x().func_213165_a(() -> ClientProxy.lambda$playSound$34((ISound)sound));
    }

    @Override
    public void playSound(SoundEvent soundEvent, float volume, float pitch) {
        Minecraft.func_71410_x().func_213165_a(() -> Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)soundEvent, (float)volume, (float)pitch)));
    }

    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
    }

    @Override
    public void syncStorageInventory(int entityId, CompoundNBT compound) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof IStorage) {
            IStorage wrapper = (IStorage)entity;
            wrapper.getInventory().func_70486_a(compound.func_150295_c("Inventory", 10));
        }
    }

    @Override
    public PoweredVehicleEntity.AccelerationDirection getAccelerationDirection(LivingEntity entity) {
        boolean reverse;
        boolean forward;
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            if (((Boolean)Config.CLIENT.useTriggers.get()).booleanValue()) {
                if (controller.getRTriggerValue() != 0.0f && controller.getLTriggerValue() == 0.0f) {
                    return PoweredVehicleEntity.AccelerationDirection.FORWARD;
                }
                if (controller.getLTriggerValue() != 0.0f && controller.getRTriggerValue() == 0.0f) {
                    return PoweredVehicleEntity.AccelerationDirection.REVERSE;
                }
            }
            forward = controller.getButtonsStates().getState(0);
            reverse = controller.getButtonsStates().getState(1);
            if (forward && reverse) {
                return PoweredVehicleEntity.AccelerationDirection.CHARGING;
            }
            if (forward) {
                return PoweredVehicleEntity.AccelerationDirection.FORWARD;
            }
            if (reverse) {
                return PoweredVehicleEntity.AccelerationDirection.REVERSE;
            }
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        forward = settings.field_74351_w.func_151470_d();
        reverse = settings.field_74368_y.func_151470_d();
        if (forward && reverse) {
            return PoweredVehicleEntity.AccelerationDirection.CHARGING;
        }
        if (forward) {
            return PoweredVehicleEntity.AccelerationDirection.FORWARD;
        }
        if (reverse) {
            return PoweredVehicleEntity.AccelerationDirection.REVERSE;
        }
        return PoweredVehicleEntity.AccelerationDirection.fromEntity(entity);
    }

    @Override
    public PoweredVehicleEntity.TurnDirection getTurnDirection(LivingEntity entity) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            if (controller.getLThumbStickXValue() > 0.0f) {
                return PoweredVehicleEntity.TurnDirection.RIGHT;
            }
            if (controller.getLThumbStickXValue() < 0.0f) {
                return PoweredVehicleEntity.TurnDirection.LEFT;
            }
            if (controller.getButtonsStates().getState(16)) {
                return PoweredVehicleEntity.TurnDirection.RIGHT;
            }
            if (controller.getButtonsStates().getState(15)) {
                return PoweredVehicleEntity.TurnDirection.LEFT;
            }
        }
        if (entity.field_70702_br < 0.0f) {
            return PoweredVehicleEntity.TurnDirection.RIGHT;
        }
        if (entity.field_70702_br > 0.0f) {
            return PoweredVehicleEntity.TurnDirection.LEFT;
        }
        return PoweredVehicleEntity.TurnDirection.FORWARD;
    }

    @Override
    public float getTargetTurnAngle(PoweredVehicleEntity vehicle, boolean drifting) {
        PoweredVehicleEntity.TurnDirection direction = vehicle.getTurnDirection();
        if (vehicle.func_184179_bs() != null) {
            float turnNormal;
            Controller controller;
            if (controllableLoaded && (controller = Controllable.getController()) != null && (turnNormal = controller.getLThumbStickXValue()) != 0.0f) {
                float newTurnAngle = vehicle.turnAngle + ((float)vehicle.getMaxTurnAngle() * -turnNormal - vehicle.turnAngle) * 0.15f;
                if (Math.abs(newTurnAngle) > (float)vehicle.getMaxTurnAngle()) {
                    return vehicle.getMaxTurnAngle() * direction.getDir();
                }
                return newTurnAngle;
            }
            if (direction != PoweredVehicleEntity.TurnDirection.FORWARD) {
                float newTurnAngle;
                float amount = direction.getDir() * vehicle.getTurnSensitivity();
                if (drifting) {
                    amount *= 0.45f;
                }
                if (Math.abs(newTurnAngle = vehicle.turnAngle + amount) > (float)vehicle.getMaxTurnAngle()) {
                    return vehicle.getMaxTurnAngle() * direction.getDir();
                }
                return newTurnAngle;
            }
        }
        if (drifting) {
            return vehicle.turnAngle * 0.95f;
        }
        return vehicle.turnAngle * 0.75f;
    }

    @Override
    public boolean isDrifting() {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null && controller.getButtonsStates().getState(10)) {
            return true;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    @Override
    public boolean isHonking() {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null && controller.isButtonPressed(8)) {
            return true;
        }
        return KEY_HORN.func_151470_d();
    }

    @Override
    public PlaneEntity.FlapDirection getFlapDirection() {
        Controller controller;
        boolean flapUp = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean flapDown = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            flapUp |= controller.getButtonsStates().getState(10);
            flapDown |= controller.getButtonsStates().getState(9);
        }
        return PlaneEntity.FlapDirection.fromInput(flapUp, flapDown);
    }

    @Override
    public HelicopterEntity.AltitudeChange getAltitudeChange() {
        Controller controller;
        boolean flapUp = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean flapDown = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            flapUp |= controller.getButtonsStates().getState(10);
            flapDown |= controller.getButtonsStates().getState(9);
        }
        return HelicopterEntity.AltitudeChange.fromInput(flapUp, flapDown);
    }

    @Override
    public float getTravelDirection(HelicopterEntity vehicle) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            float xAxis = controller.getLThumbStickXValue();
            float yAxis = controller.getLThumbStickYValue();
            if (xAxis != 0.0f || yAxis != 0.0f) {
                float angle = (float)Math.toDegrees(Math.atan2(-xAxis, yAxis)) + 180.0f;
                return vehicle.field_70177_z + angle;
            }
        }
        PoweredVehicleEntity.AccelerationDirection accelerationDirection = vehicle.getAcceleration();
        PoweredVehicleEntity.TurnDirection turnDirection = vehicle.getTurnDirection();
        if (vehicle.func_184179_bs() != null) {
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.FORWARD) {
                return vehicle.field_70177_z + (float)turnDirection.getDir() * -45.0f;
            }
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.REVERSE) {
                return vehicle.field_70177_z + 180.0f + (float)turnDirection.getDir() * 45.0f;
            }
            return vehicle.field_70177_z + (float)turnDirection.getDir() * -90.0f;
        }
        return vehicle.field_70177_z;
    }

    @Override
    public float getTravelSpeed(HelicopterEntity helicopter) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            float xAxis = controller.getLThumbStickXValue();
            float yAxis = controller.getLThumbStickYValue();
            if (xAxis != 0.0f || yAxis != 0.0f) {
                return (float)Math.min(1.0, Math.sqrt(Math.pow(xAxis, 2.0) + Math.pow(yAxis, 2.0)));
            }
        }
        return helicopter.getAcceleration() != PoweredVehicleEntity.AccelerationDirection.NONE || helicopter.getTurnDirection() != PoweredVehicleEntity.TurnDirection.FORWARD ? 1.0f : 0.0f;
    }

    @Override
    public float getPower(PoweredVehicleEntity vehicle) {
        Controller controller;
        if (controllableLoaded && ((Boolean)Config.CLIENT.useTriggers.get()).booleanValue() && (controller = Controllable.getController()) != null) {
            PoweredVehicleEntity.AccelerationDirection accelerationDirection = vehicle.getAcceleration();
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.FORWARD) {
                return controller.getRTriggerValue();
            }
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.REVERSE) {
                return controller.getLTriggerValue();
            }
        }
        return 1.0f;
    }

    @Override
    public void syncEntityFluid(int entityId, FluidStack stack) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityId);
        if (entity == null) {
            return;
        }
        LazyOptional optional = entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        optional.ifPresent(handler -> {
            if (handler instanceof FluidTank) {
                FluidTank tank = (FluidTank)handler;
                tank.setFluid(stack);
            }
        });
    }

    @Override
    public boolean canApplyVehicleYaw(Entity passenger) {
        if (passenger.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            return (Boolean)Config.CLIENT.rotateCameraWithVehicle.get();
        }
        return false;
    }

    @Override
    public void syncPlayerSeat(int entityId, int seatIndex, UUID uuid) {
        Entity entity;
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer != null && (entity = clientPlayer.field_213837_d.func_73045_a(entityId)) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            vehicle.getSeatTracker().setSeatIndex(seatIndex, uuid);
        }
    }

    @Override
    public void syncHeldVehicle(int entityId, CompoundNBT compound) {
        Entity entity;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_73045_a(entityId)) instanceof PlayerEntity) {
            HeldVehicleDataHandler.setHeldVehicle((PlayerEntity)entity, compound);
        }
    }

    @Override
    public void spawnWheelParticle(BlockPos pos, BlockState state, double x, double y, double z, Vector3d motion) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world != null) {
            DiggingParticle particle = new DiggingParticle(world, x, y, z, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, state);
            particle.func_174846_a(pos);
            particle.func_70543_e((float)motion.func_72433_c());
            mc.field_71452_i.func_78873_a((Particle)particle);
        }
    }

    private static /* synthetic */ void lambda$playSound$34(ISound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    private static enum SoundType {
        ENGINE,
        ENGINE_RIDING,
        HORN,
        HORN_RIDING;

    }
}

