/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.TrailerEntity;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import com.mrcrayfish.vehicle.network.message.MessageOpenStorage;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class StorageTrailerEntity
extends TrailerEntity
implements IStorage {
    private static final EntityRayTracer.RayTracePart CONNECTION_BOX = new EntityRayTracer.RayTracePart(StorageTrailerEntity.createScaledBoundingBox(-0.375, 0.2625, 0.5625, 0.375, 0.51875, 1.0625, 1.1));
    private static final EntityRayTracer.RayTracePart CHEST_BOX = new EntityRayTracer.RayTracePart(new AxisAlignedBB(-0.4375, 0.475, -0.4375, 0.4375, 1.34, 0.4375));
    private static final Map<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList> interactionBoxMapStatic = (Map)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
        HashMap<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList> map = new HashMap<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList>();
        map.put(CONNECTION_BOX, EntityRayTracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        map.put(CHEST_BOX, EntityRayTracer.boxToTriangles(CHEST_BOX.getBox(), null));
        return map;
    });
    private StorageInventory inventory;

    public StorageTrailerEntity(EntityType<? extends StorageTrailerEntity> type, World worldIn) {
        super(type, worldIn);
        this.initInventory();
    }

    @Override
    public double getHitchOffset() {
        return -17.6;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<EntityRayTracer.RayTracePart, EntityRayTracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRayTracer.RayTracePart> getApplicableInteractionBoxes() {
        return ImmutableList.of((Object)CONNECTION_BOX, (Object)CHEST_BOX);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean processHit(EntityRayTracer.RayTraceResultRotated result, boolean rightClick) {
        if (rightClick) {
            if (result.getPartHit() == CONNECTION_BOX) {
                PacketHandler.instance.sendToServer((Object)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
                return true;
            }
            if (result.getPartHit() == CHEST_BOX) {
                PacketHandler.instance.sendToServer((Object)new MessageOpenStorage(this.func_145782_y()));
                Minecraft.func_71410_x().field_71439_g.func_184609_a(Hand.MAIN_HAND);
                return true;
            }
        }
        return super.processHit(result, rightClick);
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Inventory", 9)) {
            this.initInventory();
            InventoryUtil.readInventoryToNBT(compound, "Inventory", this.inventory);
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.inventory != null) {
            InventoryUtil.writeInventoryToNBT(compound, "Inventory", (IInventory)this.inventory);
        }
    }

    private void initInventory() {
        StorageInventory original = this.inventory;
        this.inventory = new StorageInventory(this, 27);
        if (original != null) {
            for (int i = 0; i < original.func_70302_i_(); ++i) {
                ItemStack stack = original.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, stack.func_77946_l());
            }
        }
    }

    @Override
    protected void onVehicleDestroyed(LivingEntity entity) {
        super.onVehicleDestroyed(entity);
        if (this.inventory != null) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
    }

    @Override
    public StorageInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean canTowTrailer() {
        return true;
    }

    @Override
    public void func_174889_b(PlayerEntity player) {
        this.func_184185_a(SoundEvents.field_187657_V, 0.5f, 0.9f);
    }

    @Override
    public ITextComponent getStorageName() {
        return this.func_145748_c_();
    }
}

