/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrcrayfish.vehicle.crafting.FluidEntry;
import com.mrcrayfish.vehicle.crafting.FluidExtractorRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidExtractorRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FluidExtractorRecipe> {
    public FluidExtractorRecipe read(ResourceLocation recipeId, JsonObject json) {
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("Missing ingredient, expected to find a item");
        }
        ItemStack ingredient = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("ingredient"), (boolean)false);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a fluid entry");
        }
        FluidEntry result = FluidEntry.deserialize(json.getAsJsonObject("result"));
        return new FluidExtractorRecipe(recipeId, ingredient, result);
    }

    @Nullable
    public FluidExtractorRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack ingredient = buffer.func_150791_c();
        FluidEntry result = FluidEntry.read(buffer);
        return new FluidExtractorRecipe(recipeId, ingredient, result);
    }

    public void write(PacketBuffer buffer, FluidExtractorRecipe recipe) {
        buffer.func_150788_a(recipe.getIngredient());
        recipe.getResult().write(buffer);
    }
}

