/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.EntityRayTracer;
import com.mrcrayfish.vehicle.client.RayTraceFunction;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderLandVehicleWrapper<T extends LandVehicleEntity, R extends AbstractRenderVehicle<T>>
extends RenderVehicleWrapper<T, R> {
    public RenderLandVehicleWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        if (!entity.func_70089_S()) {
            return;
        }
        matrixStack.func_227860_a_();
        VehicleProperties properties = ((VehicleEntity)entity).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)bodyPosition.getRotX()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)bodyPosition.getRotY()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)bodyPosition.getRotZ()));
        float additionalYaw = ((LandVehicleEntity)entity).prevAdditionalYaw + (((LandVehicleEntity)entity).additionalYaw - ((LandVehicleEntity)entity).prevAdditionalYaw) * partialTicks;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(additionalYaw));
        matrixStack.func_227861_a_(bodyPosition.getX(), bodyPosition.getY(), bodyPosition.getZ());
        if (((VehicleEntity)entity).canTowTrailer()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            Vector3d towBarOffset = properties.getTowBarPosition();
            matrixStack.func_227861_a_(towBarOffset.field_72450_a * 0.0625, towBarOffset.field_72448_b * 0.0625 + 0.5, -towBarOffset.field_72449_c * 0.0625);
            RenderUtil.renderColoredModel(this.renderVehicle.getTowBarModel().getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227862_a_((float)bodyPosition.getScale(), (float)bodyPosition.getScale(), (float)bodyPosition.getScale());
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getAxleOffset() * 0.0625, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getWheelOffset() * 0.0625, 0.0);
        if (((LandVehicleEntity)entity).canWheelie()) {
            if (properties.getRearAxelVec() == null) {
                return;
            }
            matrixStack.func_227861_a_(0.0, -0.5, 0.0);
            matrixStack.func_227861_a_(0.0, (double)(-properties.getAxleOffset()) * 0.0625, 0.0);
            matrixStack.func_227861_a_(0.0, 0.0, properties.getRearAxelVec().field_72449_c * 0.0625);
            float wheelieProgress = MathHelper.func_219799_g((float)partialTicks, (float)((LandVehicleEntity)entity).prevWheelieCount, (float)((LandVehicleEntity)entity).wheelieCount) / 4.0f;
            wheelieProgress = (float)(1.0 - Math.pow(1.0 - (double)wheelieProgress, 2.0));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-30.0f * wheelieProgress));
            matrixStack.func_227861_a_(0.0, 0.0, -properties.getRearAxelVec().field_72449_c * 0.0625);
            matrixStack.func_227861_a_(0.0, (double)properties.getAxleOffset() * 0.0625, 0.0);
            matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        }
        this.renderVehicle.render(entity, matrixStack, renderTypeBuffer, partialTicks, light);
        if (((PoweredVehicleEntity)entity).hasWheels()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, -0.5, 0.0);
            matrixStack.func_227861_a_(0.0, (double)(-properties.getAxleOffset() * 0.0625f), 0.0);
            IBakedModel wheelModel = RenderUtil.getWheelModel(entity);
            properties.getWheels().forEach(wheel -> this.renderWheel((LandVehicleEntity)entity, (Wheel)wheel, wheelModel, partialTicks, matrixStack, renderTypeBuffer, light));
            matrixStack.func_227865_b_();
        }
        if (((PoweredVehicleEntity)entity).shouldRenderEngine() && ((PoweredVehicleEntity)entity).hasEngine()) {
            IBakedModel engineModel = RenderUtil.getEngineModel(entity);
            this.renderEngine((PoweredVehicleEntity)entity, properties.getEnginePosition(), engineModel, matrixStack, renderTypeBuffer, light);
        }
        if (((PoweredVehicleEntity)entity).shouldRenderFuelPort() && ((PoweredVehicleEntity)entity).requiresFuel()) {
            PoweredVehicleEntity.FuelPortType fuelPortType = ((PoweredVehicleEntity)entity).getFuelPortType();
            EntityRayTracer.RayTraceResultRotated result = EntityRayTracer.instance().getContinuousInteraction();
            if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && result.func_216348_a() == entity && result.equalsContinuousInteraction(RayTraceFunction.FUNCTION_FUELING)) {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getOpenModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)entity).getColor(), light, OverlayTexture.field_229196_a_);
                if (this.renderVehicle.shouldRenderFuelLid()) {
                    // empty if block
                }
                ((PoweredVehicleEntity)entity).playFuelPortOpenSound();
            } else {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getClosedModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)entity).getColor(), light, OverlayTexture.field_229196_a_);
                ((PoweredVehicleEntity)entity).playFuelPortCloseSound();
            }
        }
        if (((PoweredVehicleEntity)entity).isKeyNeeded()) {
            this.renderPart(properties.getKeyPortPosition(), this.renderVehicle.getKeyHoleModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)entity).getColor(), light, OverlayTexture.field_229196_a_);
            if (!((PoweredVehicleEntity)entity).getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), ((PoweredVehicleEntity)entity).getKeyStack(), RenderUtil.getModel(((PoweredVehicleEntity)entity).getKeyStack()), matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            }
        }
        this.renderSteeringDebug(matrixStack, properties, entity);
        matrixStack.func_227865_b_();
    }

    protected void renderSteeringDebug(MatrixStack matrixStack, VehicleProperties properties, T entity) {
        if (((Boolean)Config.CLIENT.renderSteeringDebug.get()).booleanValue() && properties.getFrontAxelVec() != null && properties.getRearAxelVec() != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, -0.5, 0.0);
            matrixStack.func_227861_a_(0.0, (double)(-properties.getAxleOffset()) * 0.0625, 0.0);
            matrixStack.func_227861_a_(0.0, (double)(-properties.getWheelOffset()) * 0.0625, 0.0);
            matrixStack.func_227860_a_();
            Vector3d frontAxelVec = properties.getFrontAxelVec();
            frontAxelVec = frontAxelVec.func_186678_a(0.0625);
            matrixStack.func_227861_a_(frontAxelVec.field_72450_a, 0.0, frontAxelVec.field_72449_c);
            this.renderSteeringLine(matrixStack, 0xFFFFFF);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            frontAxelVec = properties.getFrontAxelVec();
            frontAxelVec = frontAxelVec.func_186678_a(0.0625);
            Vector3d nextFrontAxelVec = new Vector3d(0.0, 0.0, (double)(((PoweredVehicleEntity)entity).getSpeed() / 20.0f)).func_178785_b(((LandVehicleEntity)entity).renderWheelAngle * ((float)Math.PI / 180));
            frontAxelVec = frontAxelVec.func_178787_e(nextFrontAxelVec);
            matrixStack.func_227861_a_(frontAxelVec.field_72450_a, 0.0, frontAxelVec.field_72449_c);
            this.renderSteeringLine(matrixStack, 0xFFDD00);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            Vector3d rearAxelVec = properties.getRearAxelVec();
            rearAxelVec = rearAxelVec.func_186678_a(0.0625);
            matrixStack.func_227861_a_(rearAxelVec.field_72450_a, 0.0, rearAxelVec.field_72449_c);
            this.renderSteeringLine(matrixStack, 0xFFFFFF);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            frontAxelVec = properties.getFrontAxelVec();
            frontAxelVec = frontAxelVec.func_186678_a(0.0625);
            nextFrontAxelVec = new Vector3d(0.0, 0.0, (double)(((PoweredVehicleEntity)entity).getSpeed() / 20.0f)).func_178785_b(((LandVehicleEntity)entity).renderWheelAngle * ((float)Math.PI / 180));
            frontAxelVec = frontAxelVec.func_178787_e(nextFrontAxelVec);
            Vector3d rearAxelVec2 = properties.getRearAxelVec();
            rearAxelVec2 = rearAxelVec2.func_186678_a(0.0625);
            double deltaYaw = Math.toDegrees(Math.atan2(rearAxelVec2.field_72449_c - frontAxelVec.field_72449_c, rearAxelVec2.field_72450_a - frontAxelVec.field_72450_a)) + 90.0;
            if (((LandVehicleEntity)entity).isRearWheelSteering()) {
                deltaYaw += 180.0;
            }
            rearAxelVec2 = rearAxelVec2.func_178787_e(Vector3d.func_189986_a((float)0.0f, (float)((float)deltaYaw)).func_186678_a((double)(((PoweredVehicleEntity)entity).getSpeed() / 20.0f)));
            matrixStack.func_227861_a_(rearAxelVec2.field_72450_a, 0.0, rearAxelVec2.field_72449_c);
            this.renderSteeringLine(matrixStack, 0xFFDD00);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            Vector3d nextFrontAxelVec2 = new Vector3d(0.0, 0.0, (double)(((PoweredVehicleEntity)entity).getSpeed() / 20.0f)).func_178785_b(((LandVehicleEntity)entity).wheelAngle * ((float)Math.PI / 180));
            nextFrontAxelVec2 = nextFrontAxelVec2.func_178787_e(properties.getFrontAxelVec().func_186678_a(0.0625));
            Vector3d nextRearAxelVec = new Vector3d(0.0, 0.0, (double)(((PoweredVehicleEntity)entity).getSpeed() / 20.0f));
            nextRearAxelVec = nextRearAxelVec.func_178787_e(properties.getRearAxelVec().func_186678_a(0.0625));
            Vector3d nextVehicleVec = nextFrontAxelVec2.func_178787_e(nextRearAxelVec).func_186678_a(0.5);
            nextVehicleVec = nextVehicleVec.func_178788_d(properties.getFrontAxelVec().func_178787_e(properties.getRearAxelVec()).func_186678_a(0.0625).func_186678_a(0.5));
            matrixStack.func_227860_a_();
            this.renderSteeringLine(matrixStack, 0xFFFFFF);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(nextVehicleVec.field_72450_a, 0.0, nextVehicleVec.field_72449_c);
            this.renderSteeringLine(matrixStack, 0xFFDD00);
            matrixStack.func_227865_b_();
            matrixStack.func_227865_b_();
            matrixStack.func_227865_b_();
        }
    }

    private void renderSteeringLine(MatrixStack stack, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.lineWidth((float)Math.max(2.0f, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / 1920.0f * 2.0f));
        RenderSystem.enableDepthTest();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(stack.func_227866_c_().func_227870_a_(), 0.0f, 0.0f, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        buffer.func_227888_a_(stack.func_227866_c_().func_227870_a_(), 0.0f, 2.0f, 0.0f).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableDepthTest();
        RenderSystem.enableTexture();
    }

    protected void renderWheel(LandVehicleEntity vehicle, Wheel wheel, IBakedModel model, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light) {
        if (!wheel.shouldRender()) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)wheel.getOffsetX() * 0.0625 * (double)wheel.getSide().offset, (double)wheel.getOffsetY() * 0.0625, (double)wheel.getOffsetZ() * 0.0625);
        if (wheel.getPosition() == Wheel.Position.FRONT) {
            float wheelAngle = vehicle.prevRenderWheelAngle + (vehicle.renderWheelAngle - vehicle.prevRenderWheelAngle) * partialTicks;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(wheelAngle));
        }
        if (vehicle.isMoving()) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-wheel.getWheelRotation(vehicle, partialTicks)));
        }
        matrixStack.func_227861_a_((double)(wheel.getWidth() * wheel.getScaleX() / 2.0f) * 0.0625 * (double)wheel.getSide().offset, 0.0, 0.0);
        matrixStack.func_227862_a_(wheel.getScaleX(), wheel.getScaleY(), wheel.getScaleZ());
        if (wheel.getSide() == Wheel.Side.RIGHT) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, vehicle.getWheelColor(), light, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }
}

