/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.blay09.mods.hardcorerevival.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.client.GuiHelper;
import net.blay09.mods.hardcorerevival.network.MessageDie;
import net.blay09.mods.hardcorerevival.network.MessageRevival;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HardcoreRevivalClient {
    private boolean isKnockedOut;
    private boolean acceptedDeath;
    private int deathTime;
    private float enableButtonTimer;
    private Button buttonDie;
    private double prevChatHeight = -1.0;
    private boolean isRescuing;
    private int targetEntity = -1;
    private float targetProgress;

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (event.getGui() instanceof DeathScreen && this.isKnockedOut && !this.acceptedDeath) {
                event.setGui(null);
            } else if (this.isKnockedOut && event.getGui() instanceof InventoryScreen) {
                event.setGui(null);
            }
        }
    }

    @SubscribeEvent
    public void onFov(FOVUpdateEvent event) {
        if (this.isKnockedOut) {
            event.setNewfov(0.5f);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Chat event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && this.isKnockedOut && mc.field_71462_r != null) {
            this.prevChatHeight = mc.field_71474_y.field_96694_H;
            mc.field_71474_y.field_96694_H = 0.1f;
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.PORTAL) {
            Entity entity;
            Minecraft mc = Minecraft.func_71410_x();
            if (this.isKnockedOut) {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-300.0f);
                GuiHelper.drawGradientRectW(event.getMatrixStack(), 0, 0, mc.func_228018_at_().func_198105_m(), mc.func_228018_at_().func_198083_n(), 0x60500000, -1862336512);
                RenderSystem.popMatrix();
                if (mc.field_71462_r == null) {
                    ITextComponent openDeathScreenKey = mc.field_71474_y.field_74310_D.func_238171_j_();
                    TranslationTextComponent openDeathScreenText = new TranslationTextComponent("gui.hardcorerevival.open_death_screen", new Object[]{openDeathScreenKey});
                    mc.field_71466_p.func_238407_a_(event.getMatrixStack(), openDeathScreenText.func_241878_f(), 5.0f, 5.0f, -1);
                    if (!((Boolean)HardcoreRevivalConfig.SERVER.disableDeathTimer.get()).booleanValue()) {
                        int deathSecondsLeft = Math.max(0, ((Integer)HardcoreRevivalConfig.SERVER.maxDeathTicks.get() - this.deathTime) / 20);
                        FontRenderer fontRenderer = mc.field_71466_p;
                        MatrixStack matrixStack = event.getMatrixStack();
                        String string = I18n.func_135052_a((String)"gui.hardcorerevival.rescue_time_left", (Object[])new Object[]{deathSecondsLeft});
                        mc.field_71466_p.getClass();
                        fontRenderer.func_238421_b_(matrixStack, string, 5.0f, (float)(7 + 9), 0xFFFFFF);
                    } else {
                        FontRenderer fontRenderer = mc.field_71466_p;
                        MatrixStack matrixStack = event.getMatrixStack();
                        String string = I18n.func_135052_a((String)"gui.hardcorerevival.wait_for_rescue", (Object[])new Object[0]);
                        mc.field_71466_p.getClass();
                        fontRenderer.func_238421_b_(matrixStack, string, 5.0f, (float)(7 + 9), 0xFFFFFF);
                    }
                    mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                }
            } else if (this.targetEntity != -1 && this.targetProgress > 0.0f && (entity = mc.field_71441_e.func_73045_a(this.targetEntity)) instanceof PlayerEntity) {
                TranslationTextComponent s = new TranslationTextComponent("gui.hardcorerevival.rescuing", new Object[]{entity.func_145748_c_()});
                if (this.targetProgress >= 0.75f) {
                    s.func_240702_b_(" ...");
                } else if (this.targetProgress >= 0.5f) {
                    s.func_240702_b_(" ..");
                } else if (this.targetProgress >= 0.25f) {
                    s.func_240702_b_(" .");
                }
                mc.field_71466_p.func_238422_b_(event.getMatrixStack(), s.func_241878_f(), (float)mc.func_228018_at_().func_198107_o() / 2.0f - (float)mc.field_71466_p.func_238414_a_((ITextProperties)s) / 2.0f, (float)mc.func_228018_at_().func_198087_p() / 2.0f + 30.0f, -1);
                mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT && this.prevChatHeight != -1.0) {
            Minecraft.func_71410_x().field_71474_y.field_96694_H = this.prevChatHeight;
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.func_110143_aJ() <= 0.0f) {
            while (mc.field_71474_y.field_74316_C.func_151468_f()) {
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                if (mc.field_71439_g.func_110143_aJ() <= 0.0f) {
                    if (!this.isKnockedOut && !this.acceptedDeath && mc.field_71439_g.func_228353_F_()) {
                        this.deathTime = 0;
                        this.isKnockedOut = true;
                        mc.func_147108_a((Screen)new ChatScreen(""));
                    }
                    if (mc.field_71439_g.field_70725_aQ == 19) {
                        mc.field_71439_g.field_70725_aQ = 18;
                    }
                    ++this.deathTime;
                } else {
                    this.isKnockedOut = false;
                    this.acceptedDeath = false;
                    this.deathTime = 0;
                    if (mc.field_71417_B.func_198031_d() && !mc.field_71439_g.func_175149_v()) {
                        if (!this.isRescuing) {
                            NetworkHandler.channel.sendToServer((Object)new MessageRevival(true));
                            this.isRescuing = true;
                        }
                    } else if (this.isRescuing) {
                        NetworkHandler.channel.sendToServer((Object)new MessageRevival(false));
                        this.isRescuing = false;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && this.isKnockedOut && event.getGui() instanceof ChatScreen) {
            Screen gui = event.getGui();
            this.enableButtonTimer = 0.0f;
            this.buttonDie = new Button(gui.field_230708_k_ / 2 - 100, gui.field_230709_l_ / 2 - 30, 200, 20, (ITextComponent)new TranslationTextComponent("gui.hardcorerevival.die", new Object[]{""}), it -> {
                this.buttonDie.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                NetworkHandler.channel.sendToServer((Object)new MessageDie());
                this.acceptedDeath = true;
            });
            this.buttonDie.field_230693_o_ = false;
            event.addWidget((Widget)this.buttonDie);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        Screen gui = event.getGui();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && this.isKnockedOut && gui instanceof ChatScreen) {
            this.enableButtonTimer += event.getRenderPartialTicks();
            if (this.buttonDie != null) {
                if (this.enableButtonTimer >= 40.0f) {
                    this.buttonDie.field_230693_o_ = true;
                    this.buttonDie.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.hardcorerevival.die", new Object[]{""}));
                } else if (this.enableButtonTimer >= 30.0f) {
                    this.buttonDie.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.hardcorerevival.die", new Object[]{"..."}));
                } else if (this.enableButtonTimer >= 20.0f) {
                    this.buttonDie.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.hardcorerevival.die", new Object[]{".."}));
                } else if (this.enableButtonTimer >= 10.0f) {
                    this.buttonDie.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.hardcorerevival.die", new Object[]{"."}));
                }
            }
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            AbstractGui.func_238471_a_((MatrixStack)event.getMatrixStack(), (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"gui.hardcorerevival.knocked_out", (Object[])new Object[0]), (int)(gui.field_230708_k_ / 2 / 2), (int)30, (int)0xFFFFFF);
            RenderSystem.popMatrix();
            if (!((Boolean)HardcoreRevivalConfig.SERVER.disableDeathTimer.get()).booleanValue()) {
                int deathSecondsLeft = Math.max(0, ((Integer)HardcoreRevivalConfig.SERVER.maxDeathTicks.get() - this.deathTime) / 20);
                AbstractGui.func_238471_a_((MatrixStack)event.getMatrixStack(), (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"gui.hardcorerevival.rescue_time_left", (Object[])new Object[]{deathSecondsLeft}), (int)(gui.field_230708_k_ / 2), (int)(gui.field_230709_l_ / 2 + 10), (int)0xFFFFFF);
            } else {
                AbstractGui.func_238471_a_((MatrixStack)event.getMatrixStack(), (FontRenderer)mc.field_71466_p, (String)I18n.func_135052_a((String)"gui.hardcorerevival.wait_for_rescue", (Object[])new Object[0]), (int)(gui.field_230708_k_ / 2), (int)(gui.field_230709_l_ / 2 + 10), (int)0xFFFFFF);
            }
        } else if (this.buttonDie != null) {
            this.buttonDie.field_230694_p_ = false;
        }
    }

    public void setDeathTime(int deathTime) {
        this.deathTime = deathTime;
        if (deathTime > 0) {
            this.isKnockedOut = true;
            Minecraft.func_71410_x().func_147108_a((Screen)new ChatScreen(""));
        }
    }

    public void setRevivalProgress(int entityId, float progress) {
        if (progress < 0.0f) {
            this.targetEntity = -1;
            this.targetProgress = 0.0f;
        } else {
            this.targetEntity = entityId;
            this.targetProgress = progress;
        }
    }

    public void onFinalDeath() {
        this.isKnockedOut = true;
        this.acceptedDeath = true;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (((Boolean)HardcoreRevivalConfig.SERVER.glowOnDeath.get()).booleanValue()) {
                mc.field_71439_g.func_184195_f(false);
                mc.field_71439_g.func_70052_a(6, false);
            }
            mc.field_71439_g.remove(true);
        }
        mc.func_147108_a(null);
    }
}

