/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival;

import java.util.Optional;
import net.blay09.mods.hardcorerevival.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.blay09.mods.hardcorerevival.client.HardcoreRevivalClient;
import net.blay09.mods.hardcorerevival.handler.DeathHandler;
import net.blay09.mods.hardcorerevival.handler.PlayerHandler;
import net.blay09.mods.hardcorerevival.handler.RescueHandler;
import net.blay09.mods.hardcorerevival.handler.RestrictionHandler;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.util.DamageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="hardcorerevival")
@Mod.EventBusSubscriber
public class HardcoreRevival {
    public static final String MOD_ID = "hardcorerevival";
    public static final DamageSource notRescuedInTime = new DamageSource("not_rescued_in_time");
    public static Optional<HardcoreRevivalClient> client = Optional.empty();

    public HardcoreRevival() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RestrictionHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DeathHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RescueHandler());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, HardcoreRevivalConfig.serverSpec);
    }

    private void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            NetworkHandler.init();
            CapabilityHardcoreRevival.register();
        });
    }

    private void setupClient(FMLClientSetupEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            client = Optional.of(new HardcoreRevivalClient());
            DeferredWorkQueue.runLater(() -> client.ifPresent(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).register(arg_0)));
        });
    }
}

