/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.icon.XaeroIcon;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.element.RadarElementReader;
import xaero.common.minimap.render.radar.element.RadarRenderContext;
import xaero.common.minimap.render.radar.element.RadarRenderProvider;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public final class RadarRenderer
extends MinimapElementRenderer<Entity, RadarRenderContext> {
    private final IXaeroMinimap modMain;
    private final EntityIconManager entityIconManager;
    private final MinimapInterface minimapInterface;

    private RadarRenderer(IXaeroMinimap modMain, EntityIconManager entityIconManager, MinimapInterface minimapInterface, RadarElementReader elementReader, RadarRenderProvider provider, RadarRenderContext context) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.entityIconManager = entityIconManager;
        this.minimapInterface = minimapInterface;
    }

    @Override
    public void preRender(int location, Entity renderEntity, PlayerEntity player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        ModSettings settings = modMain.getSettings();
        this.entityIconManager.allowPrerender();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (settings.getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        RenderType dotsRenderType = settings.getSmoothDots() ? CustomRenderTypes.GUI_BILINEAR : CustomRenderTypes.GUI_NEAREST;
        ((RadarRenderContext)this.context).setupGlobalContext(settings.getDotNameScale(), settings.getSmoothDots(), settings.debugEntityIcons, settings.debugEntityVariantIds, settings.getDotsStyle(), dotsRenderType, renderTypeBuffers.getBuffer(dotsRenderType), renderTypeBuffers.getBuffer(CustomRenderTypes.RADAR_NAME_BGS), multiTextureRenderTypeRenderers.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR), renderEntity);
    }

    @Override
    public void postRender(int location, Entity renderEntity, PlayerEntity player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        if (((RadarRenderContext)this.context).reversedOrder) {
            renderTypeBuffers.func_228462_a_(((RadarRenderContext)this.context).dotsRenderType);
        }
        multiTextureRenderTypeRenderers.draw(((RadarRenderContext)this.context).iconsRenderer);
        if (!((RadarRenderContext)this.context).reversedOrder) {
            renderTypeBuffers.func_228462_a_(((RadarRenderContext)this.context).dotsRenderType);
        }
        renderTypeBuffers.func_228461_a_();
        ((RadarRenderContext)this.context).renderEntity = null;
        ((RadarRenderContext)this.context).iconsRenderer = null;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GlStateManager.func_227700_d_();
        RenderSystem.defaultAlphaFunc();
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, FontRenderer font, Framebuffer framebuffer, MinimapRendererHelper helper, Entity renderEntity, PlayerEntity player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, Entity e, double partialX, double partialY, boolean cave, float partialTicks) {
        float a;
        float g;
        float b;
        double dotsScale;
        boolean usableIcon;
        XaeroIcon entityHeadTexture;
        if (e instanceof PlayerEntity) {
            if (this.modMain.getTrackedPlayerRenderer().getCollector().playerExists(e.func_110124_au())) {
                this.modMain.getTrackedPlayerRenderer().getCollector().confirmPlayerRadarRender((PlayerEntity)e);
            }
            if (this.modMain.getSupportMods().worldmap() && this.modMain.getSupportMods().worldmapSupport.hasTrackedPlayerSystemSupport()) {
                this.modMain.getSupportMods().worldmapSupport.confirmPlayerRadarRender((PlayerEntity)e);
            }
        }
        float optionScaleAdjust = this.elementReader.getBoxScale(location, e, this.context);
        optionalScale *= optionScaleAdjust;
        RadarRenderContext context = (RadarRenderContext)this.context;
        int nameOffsetX = 0;
        int nameOffsetY = 0;
        matrixStack.func_227860_a_();
        boolean icon = context.icon;
        boolean name = context.name;
        XaeroIcon xaeroIcon = entityHeadTexture = icon ? this.entityIconManager.getEntityIcon(e, framebuffer, helper, (float)context.iconScale, context.debugEntityIcons, context.debugEntityVariantIds) : null;
        if (entityHeadTexture == EntityIconManager.DOT) {
            entityHeadTexture = null;
            icon = false;
        }
        float offh = (float)(renderEntity.func_226278_cu_() - e.func_226278_cu_());
        matrixStack.func_227861_a_(partialX, partialY, 0.0);
        boolean bl = usableIcon = entityHeadTexture != null && entityHeadTexture != EntityIconManager.FAILED;
        if (usableIcon) {
            float r;
            dotsScale = context.iconScale;
            double clampedScale = Math.max(1.0, dotsScale * (double)optionalScale);
            matrixStack.func_227862_a_((float)clampedScale, (float)clampedScale, 1.0f);
            float brightness = context.minimapRadar.getEntityBrightness(offh, context.heightLimit, context.startFadingAt, context.heightBasedFade);
            if (!cave) {
                g = b = brightness;
                r = b;
                a = 1.0f;
            } else {
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
                a = brightness;
            }
            helper.prepareMyTexturedColoredModalRect(matrixStack.func_227866_c_().func_227870_a_(), -31.0f, -31.0f, entityHeadTexture.getOffsetX() + 1, entityHeadTexture.getOffsetY() + 1, 62.0f, 62.0f, 62.0f, entityHeadTexture.getTextureAtlas().getWidth(), entityHeadTexture.getTextureAtlas().getTextureId(), r, g, b, a, context.iconsRenderer);
        } else {
            boolean smooth = context.smoothDots;
            if (!smooth) {
                optionalScale = (float)Math.ceil(optionalScale);
            }
            matrixStack.func_227862_a_(optionalScale, optionalScale, 1.0f);
            int dotSize = context.dotSize;
            if (icon && context.displayNameWhenIconFails && entityHeadTexture == EntityIconManager.FAILED) {
                name = true;
            }
            dotsScale = 1.0 + 0.5 * (double)(dotSize - 1);
            int color = context.minimapRadar.getEntityColour(player, e, offh, cave, context.entityCategory, context.heightLimit, context.startFadingAt, context.heightBasedFade, context.colorIndex);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
            a = (float)(color >> 24 & 0xFF) / 255.0f;
            int dotTextureX = 0;
            int dotTextureY = 0;
            int dotTextureW = 0;
            int dotTextureH = 0;
            float dotOffset = 0.0f;
            double dotActualScale = optionalScale;
            if (context.dotsStyle == 1) {
                if (smooth) {
                    dotTextureX = 1;
                    dotTextureY = 88;
                } else {
                    dotsScale = (int)dotsScale;
                    dotTextureX = 9;
                    dotTextureY = 77;
                }
                dotOffset = -3.5f;
                dotTextureH = 8;
                dotTextureW = 8;
                dotActualScale *= dotsScale;
                matrixStack.func_227862_a_((float)dotsScale, (float)dotsScale, 1.0f);
            } else {
                switch (dotSize) {
                    case 1: {
                        dotOffset = -4.5f;
                        dotTextureY = 108;
                        dotTextureH = 9;
                        dotTextureW = 9;
                        break;
                    }
                    case 3: {
                        dotOffset = -7.5f;
                        dotTextureY = 128;
                        dotTextureH = 15;
                        dotTextureW = 15;
                        break;
                    }
                    case 4: {
                        dotOffset = -10.5f;
                        dotTextureY = 160;
                        dotTextureH = 21;
                        dotTextureW = 21;
                        break;
                    }
                    default: {
                        dotOffset = -5.5f;
                        dotTextureY = 117;
                        dotTextureH = 11;
                        dotTextureW = 11;
                    }
                }
            }
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                nameOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                nameOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            helper.addTexturedColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), context.dotsBufferBuilder, dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, r, g, b, a, 256.0f);
        }
        matrixStack.func_227865_b_();
        int displayY = context.displayY;
        if (name || displayY > 0) {
            matrixStack.func_227860_a_();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227861_a_((double)nameOffsetX, (double)nameOffsetY, optionalDepth + (double)0.1f);
            int offsetY = usableIcon ? 11 : 5;
            matrixStack.func_227861_a_(0.0, (double)Math.round((double)offsetY * dotsScale * (double)optionalScale), 0.0);
            if (optionalScale < 1.0f) {
                optionalScale = 1.0f;
            }
            double dotNameScale = context.nameScale * (double)optionalScale;
            matrixStack.func_227862_a_((float)dotNameScale, (float)dotNameScale, 1.0f);
            String yValueString = null;
            if (displayY > 0) {
                int yInt = (int)Math.floor(e.func_226278_cu_());
                int pYInt = (int)Math.floor(renderEntity.func_226278_cu_());
                yValueString = displayY == 1 ? yInt + "" : (displayY == 2 ? yInt - pYInt + "" : "");
                if ((yValueString = yValueString + (yInt > pYInt ? "\u2191" : (yInt != pYInt ? "\u2193" : ""))).length() == 0) {
                    yValueString = "-";
                }
            }
            if (name) {
                ITextComponent component = Misc.getFixedDisplayName(e);
                if (component != null) {
                    String entityName = component.getString();
                    if (displayY > 0) {
                        entityName = entityName + "(" + yValueString + ")";
                    }
                    int nameW = font.func_78256_a(entityName);
                    helper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), context.nameBgBuilder, -nameW / 2 - 2, -1.0f, nameW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
                    Misc.drawNormalText(matrixStack, entityName, (float)(-nameW / 2), 0.0f, -1, false, renderTypeBuffers);
                }
            } else if (displayY > 0) {
                String yString = yValueString;
                int yStringW = font.func_78256_a(yString);
                helper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), context.nameBgBuilder, -yStringW / 2 - 2, -1.0f, yStringW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
                Misc.drawNormalText(matrixStack, yString, (float)(-yStringW / 2), 0.0f, -1, false, renderTypeBuffers);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            GlStateManager.func_227709_e_();
            GlStateManager.func_227639_a_((int)516, (float)0.0f);
            matrixStack.func_227865_b_();
        }
        return true;
    }

    public void renderEntityDotToFBO(int location, boolean highlit, MatrixStack matrixStack, MinimapProcessor minimap, PlayerEntity p, Entity renderEntity, Entity e, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, int style, boolean smooth, boolean debug, boolean debugEntityVariantIds, boolean cave, double dotNameScale, IRenderTypeBuffer.Impl textRenderTypeBuffer, RenderType dotsRenderType, IVertexBuilder dotsBufferBuilder, MultiTextureRenderTypeRenderer iconsRenderer, IVertexBuilder nameBgBuilder, int dotIndex, boolean displayNameWhenIconFails, int heightLimit, boolean heightBasedFade, int startFadingAt, double iconScale, int dotSize, int colorIndex, int displayY, EntityRadarCategory category, MinimapRendererHelper helper, FontRenderer font, Framebuffer framebuffer, float minimapScale) {
        ((RadarRenderContext)this.context).setupGlobalContext(dotNameScale, smooth, debug, debugEntityVariantIds, style, dotsRenderType, dotsBufferBuilder, nameBgBuilder, iconsRenderer, renderEntity);
        ((RadarRenderContext)this.context).minimapRadar = minimapRadar;
        ((RadarRenderContext)this.context).name = name;
        ((RadarRenderContext)this.context).icon = icon;
        ((RadarRenderContext)this.context).displayNameWhenIconFails = displayNameWhenIconFails;
        ((RadarRenderContext)this.context).heightLimit = heightLimit;
        ((RadarRenderContext)this.context).heightBasedFade = heightBasedFade;
        ((RadarRenderContext)this.context).startFadingAt = startFadingAt;
        ((RadarRenderContext)this.context).iconScale = iconScale;
        ((RadarRenderContext)this.context).dotSize = dotSize;
        ((RadarRenderContext)this.context).colorIndex = colorIndex;
        ((RadarRenderContext)this.context).displayY = displayY;
        ((RadarRenderContext)this.context).entityCategory = category;
        this.renderElement(location, highlit, false, matrixStack, textRenderTypeBuffer, font, framebuffer, helper, renderEntity, p, 0.0, 0.0, 0.0, 0, 0.0, minimapScale, e, 0.0, 0.0, cave, 1.0f);
        ((RadarRenderContext)this.context).renderEntity = null;
        ((RadarRenderContext)this.context).minimapRadar = null;
        ((RadarRenderContext)this.context).iconsRenderer = null;
    }

    @Override
    public boolean shouldRender(int location) {
        return this.minimapInterface.usingFBO() && (location == 3 || location == 4 || this.modMain.getSettings().getEntityRadar());
    }

    public static final class Builder {
        private IXaeroMinimap modMain;
        private EntityIconManager entityIconManager;
        private MinimapInterface minimapInterface;

        private Builder() {
        }

        private Builder setDefault() {
            this.setEntityIconManager(null);
            return this;
        }

        public Builder setModMain(IXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder setEntityIconManager(EntityIconManager entityIconManager) {
            this.entityIconManager = entityIconManager;
            return this;
        }

        public Builder setMinimapInterface(MinimapInterface minimapInterface) {
            this.minimapInterface = minimapInterface;
            return this;
        }

        public RadarRenderer build() {
            if (this.modMain == null || this.entityIconManager == null || this.minimapInterface == null) {
                throw new IllegalStateException();
            }
            RadarElementReader elementReader = new RadarElementReader();
            RadarRenderProvider provider = new RadarRenderProvider();
            RadarRenderContext context = new RadarRenderContext();
            return new RadarRenderer(this.modMain, this.entityIconManager, this.minimapInterface, elementReader, provider, context);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

