/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.SpriteAwareVertexBuilder;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconModelFieldResolver;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.ResolvedFieldModelPartsRenderer;
import xaero.common.minimap.render.radar.ResolvedFieldModelRootPathListener;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.misc.Misc;

public class EntityIconPrerenderer {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private static final Object[] ONE_RENDERER_ARRAY = new Object[1];
    private static final Object[] ONE_OBJECT_ARRAY = new Object[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private final IXaeroMinimap modMain;
    private ImprovedFramebuffer modelRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private MatrixStack matrixStack;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private ResolvedFieldModelPartsRenderer modelPartsFieldResolverListener;
    private ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    private final XaeroIconAtlasManager iconAtlasManager;
    private IRenderTypeBuffer.Impl entityIconRenderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(256));
    public static boolean DETECTING_MODEL_RENDERS;
    private Entity modelRenderDetectionEntity;
    private EntityRenderer modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private IRenderTypeBuffer.Impl modelRenderDetectionRenderTypeBuffer;
    private Field lastRenderTypeField;
    private Class<?> renderTypeTypeClass;
    private Field enderDragonModelField;
    private Field renderStateField;
    private Field renderStateTextureStateField;
    private Field renderStateTextureStateTextureField;
    private Field renderStateDepthTestStateField;
    private Field renderStateWriteMaskStateField;
    private Field renderStateCullStateField;
    private Field renderStateTransparencyStateField;
    private Field vanillaEntityVertexConsumersField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityIconPrerenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.matrixStack = new MatrixStack();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer(modMain);
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
        this.enderDragonModelField = Misc.getFieldReflection(EnderDragonRenderer.class, "field_229058_m_");
        this.lastRenderTypeField = Misc.getFieldReflection(IRenderTypeBuffer.Impl.class, "field_228459_c_");
        try {
            this.renderTypeTypeClass = Misc.getClassForName("net.minecraft.client.renderer.RenderType$Type");
            this.renderStateField = Misc.getFieldReflection(this.renderTypeTypeClass, "field_228668_S_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.renderStateTextureStateField = Misc.getFieldReflection(RenderType.State.class, "field_228677_a_");
        this.renderStateTextureStateTextureField = Misc.getFieldReflection(RenderState.TextureState.class, "field_228602_Q_");
        this.renderStateTransparencyStateField = Misc.getFieldReflection(RenderType.State.class, "field_228678_b_");
        this.renderStateDepthTestStateField = Misc.getFieldReflection(RenderType.State.class, "field_228682_f_");
        this.renderStateWriteMaskStateField = Misc.getFieldReflection(RenderType.State.class, "field_228690_n_");
        this.renderStateCullStateField = Misc.getFieldReflection(RenderType.State.class, "field_228683_g_");
        this.vanillaEntityVertexConsumersField = Misc.getFieldReflection(RenderTypeBuffers.class, "field_228481_c_");
        this.spriteCoordinateExpanderSpriteField = Misc.getFieldReflection(SpriteAwareVertexBuilder.class, "field_228788_b_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = Misc.getMethodReflection(this.irisRenderLayerWrapperClass, "unwrap", new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris!");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.modelPartsFieldResolverListener = new ResolvedFieldModelPartsRenderer();
        this.resolvedFieldModelRootPathListener = new ResolvedFieldModelRootPathListener();
        int maxTextureSize = GlStateManager.func_227612_D_((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager.func_227758_s_((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
    }

    void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    private XaeroIconAtlas getCurrentAtlas() throws Exception {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        MinimapLogs.LOGGER.info("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public XaeroIcon prerender(Object variant, EntityRenderer entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig, ResourceLocation readySprite, boolean outlined, boolean flipped, boolean debug) {
        boolean renderedSomething;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        OpenGLException.checkGLError();
        MatrixStack matrixStack = this.matrixStack;
        modelRenderFramebuffer.func_147610_a(true);
        this.setupMatrices(64, 500);
        OpenGLException.checkGLError();
        if (readySprite == null) {
            LivingEntity livingEntity;
            GlStateManager.func_227771_z_();
            if (Minecraft.func_71410_x().func_175598_ae().field_217783_c != null) {
                DETECTING_MODEL_RENDERS = true;
                this.modelRenderDetectionEntity = entity;
                this.modelRenderDetectionEntityRenderer = entityRenderer;
                this.modelRenderDetectionEntityModelClass = null;
                this.modelRenderDetectionList.clear();
                this.lastModelRenderDetected = null;
                MatrixStack.Entry matrixEntryToRestore = matrixStack.func_227866_c_();
                matrixStack.func_227860_a_();
                try {
                    IRenderTypeBuffer.Impl renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (IRenderTypeBuffer.Impl)Misc.getReflectFieldValue(Minecraft.func_71410_x().func_228019_au_(), this.vanillaEntityVertexConsumersField);
                    entityRenderer.func_225623_a_(entity, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0);
                    renderTypeBuffer.func_228461_a_();
                    OpenGLException.checkGLError();
                }
                catch (Throwable e) {
                    this.modelRenderDetectionList.clear();
                    MinimapLogs.LOGGER.error("Exception when calling the full entity renderer before rendering the icon. " + entity.func_70022_Q(), e);
                }
                modelRenderFramebuffer.func_147610_a(true);
                DETECTING_MODEL_RENDERS = false;
                this.modelRenderDetectionEntity = null;
                this.modelRenderDetectionEntityRenderer = null;
                while (matrixStack.func_227866_c_() != matrixEntryToRestore) {
                    matrixStack.func_227865_b_();
                }
                while (GL11.glGetError() != 0) {
                }
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + entity.func_70022_Q());
            }
            IRenderTypeBuffer.Impl renderTypeBuffer = this.entityIconRenderTypeBuffer;
            EntityModel entityModel = this.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endModelRendering(modelRenderFramebuffer);
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(helper, defaultFramebuffer);
                return EntityIconManager.FAILED;
            }
            GlStateManager.func_227700_d_();
            GlStateManager.func_227737_l_();
            GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_227658_a_((int)16640, (boolean)Minecraft.field_142025_a);
            GlStateManager.func_227740_m_();
            GlStateManager.func_227734_k_();
            GlStateManager.func_227771_z_();
            GlStateManager.func_227674_b_((int)515);
            RenderHelper.func_227783_c_();
            if (debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-65536);
                matrixStack.func_227865_b_();
                GlStateManager.func_227740_m_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            MatrixStack.Entry matrixEntryToRestore = matrixStack.func_227866_c_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(32.0, 32.0, -450.0);
            matrixStack.func_227861_a_((double)modelConfig.offsetX, (double)(-modelConfig.offsetY), 0.0);
            int mainScale = 32;
            matrixStack.func_227862_a_((float)mainScale, (float)(-mainScale), (float)(-mainScale));
            if (scale < 1.0f) {
                matrixStack.func_227862_a_(scale, scale, scale);
            }
            matrixStack.func_227862_a_(modelConfig.baseScale, modelConfig.baseScale, modelConfig.baseScale);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(modelConfig.rotationY));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(modelConfig.rotationX));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(modelConfig.rotationZ));
            EntityIconDefinitions.customTransformation(matrixStack, entityModel, entity, this);
            LivingEntity livingEntity2 = livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity != null) {
                this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
            }
            renderedSomething = this.renderIcon(matrixStack, renderTypeBuffer, entityRenderer, entityModel, this.modelRenderDetectionList, entity, modelConfig, defaultModelConfig);
            if (livingEntity != null) {
                this.livingEntityRotationResetter.restore(livingEntity);
            }
            EntityIconDefinitions.customPostRenderTransformation(matrixStack, entityModel, entity);
            while (matrixStack.func_227866_c_() != matrixEntryToRestore) {
                matrixStack.func_227865_b_();
            }
            if (debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(9.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711936);
                matrixStack.func_227865_b_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
        } else {
            matrixStack.func_227860_a_();
            GlStateManager.func_227700_d_();
            GlStateManager.func_227737_l_();
            GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_227658_a_((int)16640, (boolean)Minecraft.field_142025_a);
            GlStateManager.func_227740_m_();
            GlStateManager.func_227605_A_();
            RenderHelper.func_227783_c_();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(readySprite);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            matrixStack.func_227861_a_(32.0, 32.0, 1.0);
            if (scale < 1.0f) {
                matrixStack.func_227862_a_(scale, scale, 1.0f);
            }
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(matrixStack.func_227866_c_().func_227870_a_(), -32.0f, -32.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
            GlStateManager.func_227771_z_();
            matrixStack.func_227865_b_();
            renderedSomething = true;
        }
        this.endModelRendering(modelRenderFramebuffer);
        XaeroIcon icon = EntityIconManager.FAILED;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
            GlStateManager.func_227737_l_();
            if (debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(18.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16776961);
                matrixStack.func_227865_b_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.func_147612_c();
            GlStateManager.func_227702_d_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_227709_e_();
            GlStateManager.func_227639_a_((int)516, (float)0.05f);
            GlStateManager.func_227740_m_();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
            if (outlined) {
                for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                    for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                        if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                        helper.drawMyTexturedModalRect(shadowOffsetX, 64 + shadowOffsetY, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f);
                    }
                }
            }
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_227737_l_();
            helper.drawMyTexturedModalRect(0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f);
            RenderSystem.defaultAlphaFunc();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            if (debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(27.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711681);
                matrixStack.func_227865_b_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_227740_m_();
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.func_227760_t_((int)0);
            try {
                XaeroIconAtlas atlas = this.getCurrentAtlas();
                icon = atlas.createIcon();
                this.atlasRenderFramebuffer.func_147610_a(false);
                GlStateManager.func_227714_e_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
                this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
                this.atlasRenderFramebuffer.func_147611_b();
                iconRenderFramebuffer.func_147612_c();
                GlStateManager.func_227700_d_();
                GlStateManager.func_227737_l_();
                if (flipped) {
                    helper.drawMyTexturedModalRect(0.0f, 64.0f, 0, 64, 64.0f, -64.0f, -64.0f, 64.0f);
                } else {
                    helper.drawMyTexturedModalRect(0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f);
                }
                if (debug) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(36.0, 10.0, -10.0);
                    matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
                    AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-256);
                    matrixStack.func_227865_b_();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                }
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error(String.format("Exception rendering to a entity icon atlas for %s %s!", EntityType.func_200718_a((EntityType)entity.func_200600_R()), variant), t);
            }
            GlStateManager.func_227709_e_();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227760_t_((int)0);
        }
        this.restoreMatrices(helper, defaultFramebuffer);
        this.atlasRenderFramebuffer.func_147609_e();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private void bindDefaultFramebuffer(Framebuffer defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            defaultFramebuffer.func_147610_a(true);
        } else {
            ImprovedFramebuffer.bindDefaultFramebuffer(this.atlasRenderFramebuffer.getType(), 36160, Minecraft.func_71410_x());
            GlStateManager.func_227714_e_((int)0, (int)0, (int)Minecraft.func_71410_x().func_228018_at_().func_198109_k(), (int)Minecraft.func_71410_x().func_228018_at_().func_198091_l());
        }
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227625_M_();
    }

    private void restoreMatrices(MinimapRendererHelper helper, Framebuffer framebuffer) {
        GlStateManager.func_227627_O_();
        GlStateManager.func_227768_x_((int)5889);
        helper.defaultOrtho(framebuffer, false);
        GlStateManager.func_227768_x_((int)5888);
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.func_147609_e();
        GlStateManager.func_227740_m_();
        RenderHelper.func_227784_d_();
        RenderHelper.func_74518_a();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.0f);
    }

    private ModelRenderer renderModel(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, EntityRenderer entityRenderer, EntityModel entityModel, Entity entity, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig, ModelRenderer mainPart, ArrayList<ModelRenderer> renderedModels, ResourceLocation entityTexture, TextureAtlasSprite entityAtlasSprite, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde, List<String> hardcodedMainPartAliases, List<String> hardcodedModelPartsFields) {
        boolean isChildBU = entityModel.field_217114_e;
        entityModel.field_217114_e = false;
        if (entityTexture != null) {
            Object modelRoot = null;
            if (modelConfig.modelRootPath != null) {
                modelRoot = this.resolveModelRoot(entityModel, modelConfig.modelRootPath, entity);
            }
            if (modelRoot == null) {
                modelRoot = EntityIconDefinitions.getModelRoot(entityRenderer, entityModel);
            }
            IVertexBuilder vertexBuilder = this.setupModelRenderType(renderTypeBuffer, entityTexture, entityAtlasSprite, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(vertexBuilder, modelRoot, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!forceFieldCheck && modelRoot instanceof AgeableModel) {
                if (modelRoot instanceof BipedModel) {
                    ModelRenderer headRenderer = ((BipedModel)modelRoot).field_78116_c;
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    ModelRenderer headWearRenderer = ((BipedModel)modelRoot).field_178720_f;
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelHeadPartsMethod, (EntityModel)((AgeableModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                if (fullModelIcon) {
                    mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelBodyPartsMethod, (EntityModel)((AgeableModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else if (!forceFieldCheck && modelRoot instanceof SegmentedModel && fullModelIcon) {
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.segmentedModelPartsMethod, (EntityModel)((SegmentedModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
            } else {
                if (!forceFieldCheck && modelRoot instanceof IHasHead) {
                    ModelRenderer headPart = ((IHasHead)modelRoot).func_205072_a();
                    if (mainPart == null) {
                        mainPart = headPart;
                    }
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                if (modelConfig.modelPartsFields == null) {
                    mainPart = this.searchSuperclassFields(vertexBuilder, modelRoot, renderedModels, mainPart, hardcodedMainPartAliases, true, modelConfig.modelPartsRotationReset, mrde);
                }
                List<String> headPartsFields = hardcodedModelPartsFields;
                if (fullModelIcon) {
                    headPartsFields = null;
                } else if (modelConfig.modelPartsFields != null) {
                    headPartsFields = modelConfig.modelPartsFields;
                }
                mainPart = this.searchSuperclassFields(vertexBuilder, modelRoot, renderedModels, mainPart, headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
            }
            renderTypeBuffer.func_228461_a_();
        }
        entityModel.field_217114_e = isChildBU;
        return mainPart;
    }

    private IVertexBuilder setupModelRenderType(IRenderTypeBuffer.Impl renderTypeBuffer, ResourceLocation entityTexture, TextureAtlasSprite entityAtlasSprite, ModelRenderDetectionElement mrde) {
        IVertexBuilder regularConsumer = renderTypeBuffer.getBuffer(CustomRenderTypes.entityIconRenderType(entityTexture, mrde.layerPhases));
        if (entityAtlasSprite != null) {
            return entityAtlasSprite.func_229230_a_(regularConsumer);
        }
        return regularConsumer;
    }

    public ModelRenderer searchSuperclassFields(IVertexBuilder vertexBuilder, Object modelRoot, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(this.matrixStack, vertexBuilder, justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.searchSuperclassFields(modelRoot, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public ModelRenderer handleFields(IVertexBuilder vertexBuilder, Object modelRoot, Field[] declaredModelFields, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(this.matrixStack, vertexBuilder, justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.handleFields(modelRoot, declaredModelFields, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    public void onModelRenderDetection(EntityModel<?> model, IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha) {
        RenderType.State renderState;
        if (this.modelRenderDetectionEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (this.modelRenderDetectionEntityModelClass != model.getClass()) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((IRenderTypeBuffer)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.modelRenderDetectionList.isEmpty()) {
            ResourceLocation textureLocation = null;
            try {
                ResourceLocation textureLocationUnchecked;
                textureLocation = textureLocationUnchecked = this.modelRenderDetectionEntityRenderer.func_110775_a(this.modelRenderDetectionEntity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.func_228282_a_(textureLocation);
            }
        }
        if (lastRenderType != null && (renderState = this.getRenderState(lastRenderType)) != null) {
            int blendSrcFactor;
            RenderState.TextureState renderTextureState = (RenderState.TextureState)Misc.getReflectFieldValue(renderState, this.renderStateTextureStateField);
            ResourceLocation texture = this.getRenderStateTextureStateTexture(renderTextureState);
            RenderState.TransparencyState renderTransparencyState = (RenderState.TransparencyState)Misc.getReflectFieldValue(renderState, this.renderStateTransparencyStateField);
            renderTransparencyState.func_228547_a_();
            int blendDestFactor = GL11.glGetInteger((int)32968);
            if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
                renderTransparencyState = CustomRenderTypes.getTransparencyPhase(blendSrcFactor, blendDestFactor, 0, 1);
            }
            renderTransparencyState.func_228549_b_();
            RenderState.DepthTestState renderDepthTestState = (RenderState.DepthTestState)Misc.getReflectFieldValue(renderState, this.renderStateDepthTestStateField);
            RenderState.WriteMaskState renderWriteMaskState = (RenderState.WriteMaskState)Misc.getReflectFieldValue(renderState, this.renderStateWriteMaskStateField);
            RenderState.CullState renderCullState = (RenderState.CullState)Misc.getReflectFieldValue(renderState, this.renderStateCullStateField);
            CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState);
            TextureAtlasSprite renderAtlasSprite = null;
            if (vertexConsumer instanceof SpriteAwareVertexBuilder) {
                renderAtlasSprite = (TextureAtlasSprite)Misc.getReflectFieldValue(vertexConsumer, this.spriteCoordinateExpanderSpriteField);
            }
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, texture, renderAtlasSprite, layerPhases, red, green, blue, alpha);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private RenderType getLastRenderType(IRenderTypeBuffer renderTypeBuffer) {
        if (renderTypeBuffer instanceof IRenderTypeBuffer.Impl) {
            Object lastRenderTypeObject = Misc.getReflectFieldValue(renderTypeBuffer, this.lastRenderTypeField);
            RenderType lastRenderType = null;
            lastRenderType = lastRenderTypeObject instanceof Optional ? (RenderType)((Optional)lastRenderTypeObject).orElse(null) : (RenderType)lastRenderTypeObject;
            return lastRenderType;
        }
        return null;
    }

    private RenderType.State getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)Misc.getReflectMethodValue(renderType, this.irisRenderLayerWrapperUnwrapMethod, new Object[0]);
        }
        if (renderType.getClass() == this.renderTypeTypeClass) {
            RenderType.State renderState = (RenderType.State)Misc.getReflectFieldValue(renderType, this.renderStateField);
            return renderState;
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(RenderState.TextureState textureState) {
        Optional optional;
        Object renderStateTextureObject = Misc.getReflectFieldValue(textureState, this.renderStateTextureStateTextureField);
        Object renderStateTexture = null;
        renderStateTexture = renderStateTextureObject instanceof Optional ? (!(optional = (Optional)renderStateTextureObject).isPresent() ? null : (ResourceLocation)optional.get()) : (ResourceLocation)renderStateTextureObject;
        return renderStateTexture;
    }

    private boolean renderIcon(MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffer, EntityRenderer entityRenderer, EntityModel mainEntityModel, List<ModelRenderDetectionElement> detectedModels, Entity entity, EntityIconModelConfig modelConfig, EntityIconModelConfig defaultModelConfig) {
        EntityIconCustomRenderer extraLayer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = !(modelConfig.renderingFullModel != null && modelConfig.renderingFullModel != false || modelConfig.modelPartsFields == null && !EntityIconDefinitions.forceFieldCheck(mainEntityModel));
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        ModelRenderer mainPart = null;
        boolean renderedSomething = false;
        ArrayList<ModelRenderer> mainRenderedModels = new ArrayList<ModelRenderer>();
        if (detectedModels.isEmpty()) {
            ResourceLocation mainEntityTexture = null;
            try {
                ResourceLocation mainEntityTextureUnchecked;
                mainEntityTexture = mainEntityTextureUnchecked = entityRenderer.func_110775_a(entity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when prerendering an icon with nothing detected!", t);
            }
            if (mainEntityTexture != null) {
                detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainEntityTexture, null, CustomRenderTypes.getBasicEntityIconLayerPhases(mainEntityTexture), 1.0f, 1.0f, 1.0f, 1.0f));
            }
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            if (mrde.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement mrde : detectedModels) {
                mrde.allVisible = true;
            }
        }
        List<String> hardcodedMainPartAliases = EntityIconDefinitions.getMainModelPartFields(entityRenderer, mainEntityModel, entity);
        List<String> hardcodedModelPartsFields = EntityIconDefinitions.getSecondaryModelPartsFields(entityRenderer, mainEntityModel, entity);
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            EntityModel<?> detectedModel = mrde.model;
            ResourceLocation detectedTexture = mrde.renderTexture;
            TextureAtlasSprite detectedAtlasSprite = mrde.renderAtlasSprite;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (detectedTexture == null) continue;
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, defaultModelConfig, mainPart, mainRenderedModels, detectedTexture, detectedAtlasSprite, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<ModelRenderer> renderedModels = new ArrayList<ModelRenderer>();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, defaultModelConfig, mainPart, renderedModels, detectedTexture, detectedAtlasSprite, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            IVertexBuilder vertexBuilder = this.setupModelRenderType(renderTypeBuffer, detectedTexture, detectedAtlasSprite, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, matrixStack, vertexBuilder, new ArrayList<ModelRenderer>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            renderTypeBuffer.func_228461_a_();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (extraLayer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = extraLayer.render(matrixStack, renderTypeBuffer, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(Entity entity, EntityModel model) {
        try {
            model.func_212843_a_(entity, 0.0f, 0.0f, 1.0f);
            model.func_225597_a_(entity, 0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            return false;
        }
    }

    private EntityModel getEntityRendererModel(EntityRenderer entityRenderer) {
        if (entityRenderer instanceof LivingRenderer) {
            return ((LivingRenderer)entityRenderer).func_217764_d();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }

    private Object resolveModelRoot(EntityModel<?> model, ArrayList<ArrayList<String>> rootPath, Entity entity) {
        ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener = this.resolvedFieldModelRootPathListener;
        Object currentChainNode = model;
        for (ArrayList<String> pathStep : rootPath) {
            resolvedFieldModelRootPathListener.prepare();
            EntityIconModelFieldResolver.searchSuperclassFields(currentChainNode, pathStep, resolvedFieldModelRootPathListener, ONE_OBJECT_ARRAY);
            currentChainNode = resolvedFieldModelRootPathListener.getCurrentNode();
            if (currentChainNode != null && !resolvedFieldModelRootPathListener.failed()) continue;
            MinimapLogs.LOGGER.info(String.format("The following entity icon model root path step couldn't be resolved for %s:", EntityType.func_200718_a((EntityType)entity.func_200600_R())));
            pathStep.forEach(arg_0 -> ((Logger)MinimapLogs.LOGGER).info(arg_0));
            return null;
        }
        return currentChainNode;
    }
}

