/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info.widget;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import xaero.common.minimap.info.InfoDisplay;
import xaero.common.settings.ModSettings;

public class InfoDisplayCycleButton
extends Button {
    private int currentIndex;

    private InfoDisplayCycleButton(int currentIndex, int x, int y, int w, int h, ITextComponent component, Button.IPressable onPress) {
        super(x, y, w, h, component, onPress);
        this.currentIndex = currentIndex;
    }

    public static final class Builder<T> {
        private int x;
        private int y;
        private int w;
        private int h;
        private List<T> values;
        private List<ITextComponent> valueNames;
        private InfoDisplay<T> infoDisplay;
        private ModSettings settings;

        private Builder() {
        }

        public Builder<T> setDefault() {
            this.setBounds(0, 0, 0, 0);
            this.setValues(null, null);
            this.setInfoDisplay(null);
            return this;
        }

        public Builder<T> setBounds(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder<T> setValues(List<T> values, List<ITextComponent> valueNames) {
            if (values == null != (valueNames == null)) {
                throw new IllegalArgumentException();
            }
            if (values != null && values.size() != valueNames.size()) {
                throw new IllegalArgumentException();
            }
            this.values = values;
            this.valueNames = valueNames;
            return this;
        }

        public Builder<T> setInfoDisplay(InfoDisplay<T> infoDisplay) {
            this.infoDisplay = infoDisplay;
            return this;
        }

        public Builder<T> setSettings(ModSettings settings) {
            this.settings = settings;
            return this;
        }

        public InfoDisplayCycleButton build() {
            if (this.w == 0 || this.h == 0 || this.values == null || this.infoDisplay == null || this.settings == null) {
                throw new IllegalStateException();
            }
            int currentStateIndex = this.values.indexOf(this.infoDisplay.getState());
            if (currentStateIndex < 0) {
                this.infoDisplay.setState(this.values.get(0));
                currentStateIndex = 0;
            }
            Button.IPressable action = b -> {
                InfoDisplayCycleButton cycleButton = (InfoDisplayCycleButton)b;
                if (Screen.func_231173_s_()) {
                    cycleButton.currentIndex--;
                    if (cycleButton.currentIndex < 0) {
                        cycleButton.currentIndex = this.values.size() - 1;
                    }
                } else {
                    cycleButton.currentIndex = (cycleButton.currentIndex + 1) % this.values.size();
                }
                this.infoDisplay.setState(this.values.get(cycleButton.currentIndex));
                cycleButton.func_238482_a_(this.valueNames.get(cycleButton.currentIndex));
                try {
                    this.settings.saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            return new InfoDisplayCycleButton(currentStateIndex, this.x, this.y, this.w, this.h, this.valueNames.get(currentStateIndex), action);
        }

        public static <T> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

