/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import xaero.common.minimap.info.InfoDisplay;

public class InfoDisplayManager {
    private final Map<String, InfoDisplay<?>> displays = new HashMap();
    private final List<String> defaultOrder = new ArrayList<String>();
    private List<String> order;

    public void add(InfoDisplay<?> infoDisplay) {
        if (this.displays.put(infoDisplay.getId(), infoDisplay) == null) {
            this.defaultOrder.add(infoDisplay.getId());
        }
    }

    public void setOrder(List<String> order) {
        this.order = new ArrayList<String>(order);
        int lastDefaultOrderIdIndex = -1;
        for (int i = 0; i < this.defaultOrder.size(); ++i) {
            String defaultOrderId = this.defaultOrder.get(i);
            int defaultOrderIdIndex = this.order.indexOf(defaultOrderId);
            if (defaultOrderIdIndex == -1) {
                defaultOrderIdIndex = lastDefaultOrderIdIndex != -1 ? lastDefaultOrderIdIndex + 1 : 0;
                this.order.add(defaultOrderIdIndex, defaultOrderId);
            }
            lastDefaultOrderIdIndex = defaultOrderIdIndex;
        }
    }

    public InfoDisplay<?> get(String id) {
        return this.displays.get(id);
    }

    public Stream<InfoDisplay<?>> getStream() {
        Stream<InfoDisplay> unfilteredResult = this.order.stream().map(this.displays::get);
        return unfilteredResult.filter(Objects::nonNull);
    }

    public int getCount() {
        return this.displays.size();
    }

    public void reset() {
        this.setOrder(new ArrayList<String>());
        this.getStream().forEach(InfoDisplay::reset);
    }
}

