/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.sndctrl.library.AudioEffectLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class WorldContext {
    public final Minecraft mc;
    public final PlayerEntity player;
    public final IWorldReader world;
    public final Vector3d playerPosition;
    public final Vector3d playerEyePosition;
    public final BlockPos playerPos;
    public final BlockPos playerEyePos;
    public final boolean isPrecipitating;
    public final float precipitationStrength;
    public final float auralDampening;

    public WorldContext() {
        if (GameUtils.isInGame()) {
            ClientWorld w = GameUtils.getWorld();
            this.world = w;
            assert (this.world != null);
            this.player = GameUtils.getPlayer();
            assert (this.player != null);
            this.isPrecipitating = w.func_72896_J();
            this.playerPosition = this.player.func_213303_ch();
            this.playerEyePosition = this.player.func_174824_e(1.0f);
            this.playerPos = new BlockPos(this.playerPosition);
            this.playerEyePos = new BlockPos(this.playerEyePosition);
            Fluid fs = this.player.field_70170_p.func_204610_c(this.playerEyePos).func_206886_c();
            ResourceLocation name = fs.getRegistryName();
            this.auralDampening = name != null ? AudioEffectLibrary.getFluidCoeffcient(name) : 0.0f;
            this.precipitationStrength = WorldUtils.getRainStrength((World)w, 1.0f);
            this.mc = Minecraft.func_71410_x();
        } else {
            this.mc = null;
            this.player = null;
            this.world = null;
            this.isPrecipitating = false;
            this.playerPosition = Vector3d.field_186680_a;
            this.playerEyePosition = Vector3d.field_186680_a;
            this.playerPos = BlockPos.field_177992_a;
            this.playerEyePos = BlockPos.field_177992_a;
            this.auralDampening = 0.0f;
            this.precipitationStrength = 0.0f;
        }
    }

    public boolean isNotValid() {
        return this.mc == null;
    }
}

