/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.openal.AL10;
import org.orecruncher.lib.Singleton;
import org.orecruncher.lib.Utilities;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.threading.Worker;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.audio.Conversion;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.audio.handlers.Effects;
import org.orecruncher.sndctrl.audio.handlers.SourceContext;
import org.orecruncher.sndctrl.audio.handlers.WorldContext;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.misc.IMixinSoundContext;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SoundFXProcessor {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(SoundFXProcessor.class);
    private static final int SOUND_PROCESS_ITERATION = 50;
    private static final Set<ISoundCategory> IGNORE_CATEGORIES = new ReferenceOpenHashSet(4);
    static boolean isAvailable;
    private static SourceContext[] sources;
    private static Worker soundProcessor;
    private static final Singleton<ExecutorService> threadPool;
    private static WorldContext worldContext;

    private SoundFXProcessor() {
    }

    @Nonnull
    public static WorldContext getWorldContext() {
        return worldContext;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static void initialize() {
        Effects.initialize();
        sources = new SourceContext[SoundUtils.getMaxSounds()];
        if (soundProcessor == null) {
            soundProcessor = new Worker("SoundControl Sound Processor", SoundFXProcessor::processSounds, 50, LOGGER);
            soundProcessor.start();
        }
        IGNORE_CATEGORIES.clear();
        Category.getCategories().forEach(c -> {
            if (!c.doEffects()) {
                IGNORE_CATEGORIES.add((ISoundCategory)c);
            }
        });
        isAvailable = true;
    }

    public static void deinitialize() {
        if (SoundFXProcessor.isAvailable()) {
            isAvailable = false;
            if (soundProcessor != null) {
                soundProcessor.stop();
                soundProcessor = null;
            }
            if (sources != null) {
                Arrays.fill(sources, null);
                sources = null;
            }
            Effects.deinitialize();
        }
    }

    public static void onSoundPlay(@Nonnull ISound sound, @Nonnull ChannelManager.Entry entry) {
        if (!SoundFXProcessor.isAvailable()) {
            return;
        }
        Optional<ISoundCategory> cat = Category.getCategory(sound);
        if (cat.isPresent() && IGNORE_CATEGORIES.contains(cat.get())) {
            return;
        }
        entry.func_217888_a(source -> {
            if (source.field_216441_b > 0) {
                SourceContext ctx = new SourceContext();
                ctx.attachSound(sound);
                ctx.enable();
                ctx.exec();
                ((IMixinSoundContext)source).setData(ctx);
                SoundFXProcessor.sources[source.field_216441_b - 1] = ctx;
            }
        });
    }

    public static void tick(@Nonnull SoundSource source) {
        SourceContext ctx = ((IMixinSoundContext)source).getData();
        if (ctx != null) {
            ctx.tick(source.field_216441_b);
        }
    }

    public static void stopSoundPlay(@Nonnull SoundSource source) {
        SourceContext ctx = ((IMixinSoundContext)source).getData();
        if (ctx != null) {
            SoundFXProcessor.sources[source.field_216441_b - 1] = null;
        }
    }

    @Nonnull
    public static AudioStreamBuffer playBuffer(@Nonnull SoundSource source, @Nonnull AudioStreamBuffer buffer) {
        boolean doConversion;
        if (!((Boolean)Config.CLIENT.sound.enableMonoConversion.get()).booleanValue()) {
            return buffer;
        }
        SourceContext ctx = ((IMixinSoundContext)source).getData();
        boolean bl = doConversion = ctx == null || ctx.getSound() != null && ctx.getSound().func_147656_j() != ISound.AttenuationType.NONE;
        if (doConversion) {
            return Conversion.convert(buffer);
        }
        return buffer;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (SoundFXProcessor.isAvailable() && event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.START) {
            worldContext = new WorldContext();
        }
    }

    private static void processSounds() {
        try {
            ExecutorService pool = threadPool.get();
            assert (pool != null);
            ObjectArray<Future> tasks = new ObjectArray<Future>(256);
            for (int i = 0; i < SoundUtils.getMaxSounds(); ++i) {
                SourceContext ctx = sources[i];
                if (ctx == null || !ctx.shouldExecute()) continue;
                tasks.add(pool.submit(ctx));
            }
            if (tasks.size() > 0) {
                tasks.forEach(t -> {
                    try {
                        t.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Throwable t2) {
            LOGGER.error(t2, "Error in SoundContext ForkJoinPool", new Object[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onGatherText(@Nonnull DiagnosticEvent event) {
        String msg;
        if (SoundFXProcessor.isAvailable() && soundProcessor != null && !StringUtils.isEmpty((CharSequence)(msg = soundProcessor.getDiagnosticString()))) {
            event.getLeft().add(TextFormatting.GREEN + msg);
        }
    }

    public static void validate(@Nonnull String msg) {
        SoundFXProcessor.validate(() -> msg);
    }

    public static void validate(@Nullable Supplier<String> err) {
        int error = AL10.alGetError();
        if (error != 0) {
            String errorName = AL10.alGetString((int)error);
            if (StringUtils.isEmpty((CharSequence)errorName)) {
                errorName = Integer.toString(error);
            }
            String msg = Utilities.firstNonNull(err != null ? err.get() : null, "NONE");
            throw new IllegalStateException(String.format("OpenAL Error: %s [%s]", errorName, msg));
        }
    }

    static {
        threadPool = new Singleton<ExecutorService>(() -> {
            int threads = (Integer)Config.CLIENT.sound.backgroundThreadWorkers.get();
            if (threads == 0) {
                threads = 2;
            }
            LOGGER.info("Threads allocated to SoundControl sound processor: %d", threads);
            return Executors.newFixedThreadPool(threads);
        });
        worldContext = new WorldContext();
        MinecraftForge.EVENT_BUS.register(SoundFXProcessor.class);
    }
}

