/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.api.sound;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.SoundInstance;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public class SoundBuilder {
    private static final Random RANDOM = XorShiftRandom.current();
    private static final float[] volumeDelta = new float[]{-0.2f, 0.0f, 0.0f, 0.2f, 0.2f, 0.2f};
    private static final float[] pitchDelta = new float[]{-0.2f, 0.0f, 0.0f, 0.2f, 0.2f, 0.2f};
    @Nonnull
    private final SoundEvent soundEvent;
    @Nonnull
    private ISoundCategory soundCategory;
    @Nonnull
    private Vector3d position = Vector3d.field_186680_a;
    @Nonnull
    private ISound.AttenuationType attenuation = ISound.AttenuationType.LINEAR;
    private float volumeMin = 1.0f;
    private float volumeMax = 1.0f;
    private float pitchMin = 1.0f;
    private float pitchMax = 1.0f;
    private boolean repeatable;
    private int repeatDelayMin;
    private int repeatDelayMax;
    private boolean global;
    private boolean variableVolume;
    private boolean variablePitch;
    private int playDelay;

    public SoundBuilder(@Nonnull SoundBuilder builder) {
        this.soundEvent = builder.soundEvent;
        this.soundCategory = builder.soundCategory;
        this.position = builder.position;
        this.attenuation = builder.attenuation;
        this.volumeMin = builder.volumeMin;
        this.volumeMax = builder.volumeMax;
        this.pitchMin = builder.pitchMin;
        this.pitchMax = builder.pitchMax;
        this.repeatable = builder.repeatable;
        this.repeatDelayMin = builder.repeatDelayMin;
        this.repeatDelayMax = builder.repeatDelayMax;
        this.global = builder.global;
        this.variableVolume = builder.variableVolume;
        this.variablePitch = builder.variablePitch;
        this.playDelay = builder.playDelay;
    }

    protected SoundBuilder(@Nonnull SoundEvent evt) {
        this(evt, Category.NEUTRAL);
    }

    protected SoundBuilder(@Nonnull SoundEvent evt, @Nonnull ISoundCategory cat) {
        Objects.requireNonNull(evt);
        Objects.requireNonNull(cat);
        this.soundEvent = evt;
        this.soundCategory = cat;
    }

    @Nonnull
    public static SoundBuilder builder(@Nonnull SoundEvent evt) {
        return SoundBuilder.builder(evt, SoundLibrary.getSoundCategory(evt.func_187503_a(), Category.AMBIENT));
    }

    @Nonnull
    public static SoundBuilder builder(@Nonnull SoundEvent evt, @Nonnull ISoundCategory cat) {
        return new SoundBuilder(evt, cat);
    }

    @Nonnull
    public static SoundBuilder builder(@Nonnull SoundInstance proto) {
        Objects.requireNonNull(proto);
        SoundEvent se = SoundLibrary.getSound(proto.func_147650_b()).orElseThrow(NullPointerException::new);
        ISoundCategory sc = Category.getCategory(proto.func_184365_d()).orElseThrow(NullPointerException::new);
        return new SoundBuilder(se, sc).from(proto);
    }

    @Nonnull
    public static SoundInstance create(@Nonnull SoundEvent evt, @Nonnull ISoundCategory cat) {
        return new SoundInstance(evt, cat);
    }

    @Nonnull
    public static ISoundInstance createConfigPlay(@Nonnull String name, float volume) {
        Objects.requireNonNull(name);
        ResourceLocation resource = new ResourceLocation(name);
        SoundEvent se = SoundLibrary.getSound(resource).orElseThrow(NullPointerException::new);
        ISoundCategory cat = SoundLibrary.getSoundCategory(resource, Category.MASTER);
        SoundBuilder builder = new SoundBuilder(se, cat);
        builder.setVolume(volume);
        builder.setAttenuation(ISound.AttenuationType.NONE);
        return builder.build();
    }

    @Nonnull
    public SoundBuilder from(@Nonnull LocatableSound ps) {
        Objects.requireNonNull(ps);
        this.soundCategory = Category.getCategory(ps.func_184365_d()).orElse(Category.MASTER);
        this.position = new Vector3d(ps.func_147649_g(), ps.func_147654_h(), ps.func_147651_i());
        this.attenuation = ps.func_147656_j();
        this.global = ps.func_217861_m();
        this.repeatable = ps.func_147657_c();
        this.repeatDelayMin = this.repeatDelayMax = ps.func_147652_d();
        this.volumeMin = this.volumeMax = ps.field_147662_b;
        this.pitchMin = this.pitchMax = ps.field_147663_c;
        return this;
    }

    @Nonnull
    public ResourceLocation getResourceName() {
        return this.soundEvent.func_187503_a();
    }

    @Nonnull
    public SoundBuilder setCategory(@Nonnull ISoundCategory cat) {
        this.soundCategory = cat;
        return this;
    }

    @Nonnull
    public SoundBuilder setPosition(float x, float y, float z) {
        this.position = new Vector3d((double)x, (double)y, (double)z);
        return this;
    }

    @Nonnull
    public SoundBuilder setPosition(@Nonnull BlockPos pos) {
        Objects.requireNonNull(pos);
        return this.setPosition((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
    }

    @Nonnull
    public SoundBuilder setPosition(@Nonnull Vector3d pos) {
        Objects.requireNonNull(pos);
        this.position = pos;
        return this;
    }

    @Nonnull
    public SoundBuilder setVolumeRange(float min, float max) {
        this.volumeMin = MathStuff.min(min, max);
        this.volumeMax = MathStuff.max(min, max);
        this.variableVolume = false;
        return this;
    }

    @Nonnull
    public SoundBuilder setVariableVolume(boolean f) {
        this.variableVolume = f;
        if (f) {
            this.volumeMax = this.volumeMin;
        }
        return this;
    }

    @Nonnull
    public SoundBuilder setPitchRange(float min, float max) {
        this.pitchMin = MathStuff.min(min, max);
        this.pitchMax = MathStuff.max(min, max);
        this.variablePitch = false;
        return this;
    }

    @Nonnull
    public SoundBuilder setVariablePitch(boolean f) {
        this.variablePitch = f;
        if (f) {
            this.pitchMax = this.pitchMin;
        }
        return this;
    }

    @Nonnull
    public SoundBuilder setRepeateDelayRange(int min, int max) {
        this.repeatable = true;
        this.repeatDelayMin = MathStuff.min(min, max);
        this.repeatDelayMax = MathStuff.max(min, max);
        return this;
    }

    @Nonnull
    public SoundBuilder setGlobal(boolean flag) {
        this.global = flag;
        return this;
    }

    private float getVolume() {
        if (Float.compare(this.volumeMin, this.volumeMax) == 0) {
            float result = this.volumeMin;
            if (this.variableVolume) {
                result *= 1.0f + volumeDelta[RANDOM.nextInt(volumeDelta.length)];
            }
            return result;
        }
        return this.volumeMin + RANDOM.nextFloat() * (this.volumeMax - this.volumeMin);
    }

    @Nonnull
    public SoundBuilder setVolume(float v) {
        this.volumeMin = this.volumeMax = v;
        return this;
    }

    private float getPitch() {
        if (Float.compare(this.pitchMin, this.pitchMax) == 0) {
            float result = this.pitchMin;
            if (this.variablePitch) {
                result *= 1.0f + pitchDelta[RANDOM.nextInt(pitchDelta.length)];
            }
            return result;
        }
        return this.pitchMin + RANDOM.nextFloat() * (this.pitchMax - this.pitchMin);
    }

    @Nonnull
    public SoundBuilder setPitch(float p) {
        this.pitchMin = this.pitchMax = p;
        return this;
    }

    private int getRepeatDelay() {
        if (this.repeatDelayMin == this.repeatDelayMax) {
            return this.repeatDelayMin;
        }
        return this.repeatDelayMin + RANDOM.nextInt(this.repeatDelayMax - this.repeatDelayMin + 1);
    }

    @Nonnull
    public SoundBuilder setRepeatDelay(int delay) {
        this.repeatable = true;
        this.repeatDelayMin = this.repeatDelayMax = delay;
        return this;
    }

    @Nonnull
    public SoundBuilder setAttenuation(ISound.AttenuationType type) {
        Objects.requireNonNull(type);
        this.attenuation = type;
        return this;
    }

    @Nonnull
    public SoundBuilder setPlayDelay(int delay) {
        this.playDelay = delay;
        return this;
    }

    @Nonnull
    protected SoundInstance makeSound() {
        SoundInstance sound = SoundBuilder.create(this.soundEvent, this.soundCategory);
        sound.setVolume(this.getVolume());
        sound.setPitch(this.getPitch());
        sound.setRepeat(this.repeatable);
        sound.setRepeatDelay(this.getRepeatDelay());
        sound.setGlobal(this.global);
        sound.setPlayDelay(this.playDelay);
        if (!this.global) {
            sound.setPosition(this.position);
            sound.setAttenuationType(this.attenuation);
        } else {
            sound.setAttenuationType(ISound.AttenuationType.NONE);
        }
        return sound;
    }

    @Nonnull
    public ISoundInstance build() {
        return this.makeSound();
    }
}

