/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.library;

import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.lib.SoundTypeUtils;
import org.orecruncher.lib.blockstate.BlockStateMatcher;
import org.orecruncher.lib.blockstate.BlockStateMatcherMap;
import org.orecruncher.lib.blockstate.BlockStateParser;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.service.ModuleServiceManager;
import org.orecruncher.lib.tags.TagUtils;
import org.orecruncher.lib.validation.MapValidator;
import org.orecruncher.lib.validation.Validators;
import org.orecruncher.mobeffects.MobEffects;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.footsteps.Generator;
import org.orecruncher.mobeffects.footsteps.GeneratorQP;
import org.orecruncher.mobeffects.footsteps.Substrate;
import org.orecruncher.mobeffects.footsteps.Variator;
import org.orecruncher.mobeffects.library.BlockAcousticMap;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.mobeffects.library.config.FootstepConfig;
import org.orecruncher.mobeffects.library.config.VariatorConfig;
import org.orecruncher.mobeffects.misc.IMixinFootstepData;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.acoustics.Library;
import org.orecruncher.sndctrl.audio.acoustic.NullAcoustic;
import org.orecruncher.sndctrl.events.BlockInspectionEvent;
import org.orecruncher.sndctrl.library.Primitives;

@Mod.EventBusSubscriber(modid="mobeffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class FootstepLibrary {
    private static final String TEXT_FOOTSTEPS = TextFormatting.DARK_PURPLE + "<Footsteps>";
    private static final Map<Substrate, BlockAcousticMap> substrateMap = new EnumMap<Substrate, BlockAcousticMap>(Substrate.class);
    private static final List<SoundType> FOOTPRINT_SOUND_PROFILE = Arrays.asList(SoundType.field_185855_h, SoundType.field_185849_b, SoundType.field_185859_l, SoundType.field_185856_i);
    private static final Set<Material> FOOTPRINT_MATERIAL = new ReferenceOpenHashSet();
    private static final BlockStateMatcherMap<Boolean> FOOTPRINT_STATES = new BlockStateMatcherMap();
    private static final Map<String, List<MacroEntry>> macros = new Object2ObjectOpenHashMap();
    private static final Map<String, Variator> variators = new Object2ObjectOpenHashMap();
    private static final IModLog LOGGER = MobEffects.LOGGER.createChild(FootstepLibrary.class);
    private static Variator defaultVariator;
    private static Variator childVariator;
    private static Variator playerVariator;
    private static Variator playerQuadrupedVariator;
    private static IAcoustic SPLASH;
    private static IAcoustic SWIM;
    private static IAcoustic WATERLOGGED;

    private FootstepLibrary() {
    }

    static void initialize() {
        ModuleServiceManager.instance().add(new FootstepLibraryService());
    }

    static void initFromConfig(@Nonnull FootstepConfig mod) {
        for (Map.Entry<String, String> kvp : mod.primitives.entrySet()) {
            if (SoundTypeUtils.getSoundType(kvp.getKey()) == null) {
                LOGGER.warn("'%s' is not a known SoundType; adding and praying...", kvp.getKey());
            }
            ResourceLocation loc = Primitives.createFootstepResource(kvp.getKey());
            Library.resolve(loc, kvp.getValue(), true);
        }
        for (Map.Entry<String, String> kvp : mod.blockTags.entrySet()) {
            FootstepLibrary.registerTag(kvp.getKey(), kvp.getValue());
        }
        for (Map.Entry<String, String> kvp : mod.footsteps.entrySet()) {
            FootstepLibrary.register(kvp.getKey(), kvp.getValue());
        }
        for (String print : mod.footprints) {
            BlockStateMatcher matcher = BlockStateMatcher.create(print);
            if (matcher == BlockStateMatcher.AIR) continue;
            FOOTPRINT_STATES.put(matcher, (Boolean)true);
        }
    }

    public static Stream<String> dump() {
        return ForgeUtils.getBlockStates().stream().map(state -> {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append(BlockStateMatcher.create(state).toString()).append(" -> [");
                IAcoustic[] cached = FootstepLibrary.getCachedAcoustics(state);
                if (cached != null) {
                    for (Substrate sub : Substrate.values()) {
                        IAcoustic acoustic = cached[sub.ordinal()];
                        builder.append(sub.name()).append("=");
                        if (acoustic != null) {
                            builder.append(acoustic.toString());
                        } else {
                            builder.append("NOT SET");
                        }
                        builder.append(", ");
                    }
                } else {
                    builder.append("No acoustics defined");
                }
                builder.append("]");
                return builder.toString();
            }
            catch (Throwable throwable) {
                return "ERROR";
            }
        }).sorted();
    }

    @SubscribeEvent
    public static void onInspectionEvent(@Nonnull BlockInspectionEvent evt) {
        evt.data.add(TEXT_FOOTSTEPS);
        FootstepLibrary.collectData(evt.state, evt.data);
    }

    @Nonnull
    public static IAcoustic getRainSplashAcoustic() {
        if (SPLASH == null) {
            SPLASH = Library.resolve(new ResourceLocation("mobeffects", "waterfine"));
        }
        return SPLASH;
    }

    @Nonnull
    public static IAcoustic getSwimAcoustic() {
        if (SWIM == null) {
            SWIM = Library.resolve(new ResourceLocation("mobeffects", "_swim"));
        }
        return SWIM;
    }

    public static IAcoustic getWaterLoggedAcoustic() {
        if (WATERLOGGED == null) {
            WATERLOGGED = Library.resolve(new ResourceLocation("mobeffects", "_waterlogged"));
        }
        return WATERLOGGED;
    }

    @Nonnull
    private static Variator getVariator(@Nonnull String varName) {
        return variators.getOrDefault(varName, defaultVariator);
    }

    @Nonnull
    public static IAcoustic getBlockAcoustics(@Nonnull BlockState state) {
        return FootstepLibrary.getBlockAcoustics(state, Substrate.NORMAL);
    }

    @Nonnull
    public static IAcoustic getBlockAcoustics(@Nonnull BlockState state, @Nonnull Substrate substrate) {
        IAcoustic result;
        if (state.func_185904_a() == Material.field_151579_a) {
            return Constants.NOT_EMITTER;
        }
        IAcoustic[] cached = ((IMixinFootstepData)state).getAcoustics();
        if (cached == null) {
            cached = new IAcoustic[Substrate.values().length];
            ((IMixinFootstepData)state).setAcoustics(cached);
        }
        if ((result = cached[substrate.ordinal()]) == null) {
            IAcoustic iAcoustic = substrateMap.get((Object)substrate).getBlockAcoustics(state);
            cached[substrate.ordinal()] = iAcoustic;
            result = iAcoustic;
        }
        return result;
    }

    private static IAcoustic[] getCachedAcoustics(@Nonnull BlockState state) {
        IAcoustic[] cached = ((IMixinFootstepData)state).getAcoustics();
        if (cached == null) {
            cached = new IAcoustic[Substrate.values().length];
            ((IMixinFootstepData)state).setAcoustics(cached);
        }
        for (Substrate sub : Substrate.values()) {
            IAcoustic result = cached[sub.ordinal()];
            if (result != null) continue;
            cached[sub.ordinal()] = substrateMap.get((Object)sub).getBlockAcoustics(state);
        }
        return cached;
    }

    private static void put(@Nonnull BlockStateMatcher info, @Nullable String substrate, @Nonnull String acousticList) {
        IAcoustic acoustics = Library.resolve("mobeffects", acousticList, r -> {
            if (r.func_110623_a().equals("not_emitter")) {
                return Constants.NOT_EMITTER;
            }
            if (r.func_110623_a().equals("messy_ground")) {
                return Constants.MESSY_GROUND;
            }
            return null;
        });
        substrateMap.get((Object)Substrate.get(substrate)).put(info, acoustics);
    }

    private static void register0(@Nonnull String key, @Nonnull String acousticList) {
        Optional<BlockStateParser.ParseResult> parseResult = BlockStateParser.parseBlockState(key);
        if (parseResult.isPresent()) {
            BlockStateParser.ParseResult name = parseResult.get();
            BlockStateMatcher matcher = BlockStateMatcher.create(name);
            if (matcher.isEmpty()) {
                LOGGER.warn("Unable to identify block state '%s'", key);
            } else {
                String substrate = name.getExtras();
                FootstepLibrary.put(matcher, substrate, acousticList);
            }
        } else {
            LOGGER.warn("Malformed key in blockMap '%s'", key);
        }
    }

    private static void registerTag(@Nonnull String tagName, @Nonnull String acousticList) {
        ITag<Block> blockTag;
        String substrate = null;
        int idx = tagName.indexOf(43);
        if (idx >= 0) {
            substrate = tagName.substring(idx + 1);
            tagName = tagName.substring(0, idx);
        }
        if ((blockTag = TagUtils.getBlockTag(tagName)) != null) {
            List elements = blockTag.func_230236_b_();
            if (elements.size() == 0) {
                LOGGER.debug("No blocks associated with tag '%s'", tagName);
            } else {
                for (Block b : blockTag.func_230236_b_()) {
                    String blockName = Objects.requireNonNull(b.getRegistryName()).toString();
                    if (substrate != null) {
                        blockName = blockName + "+" + substrate;
                    }
                    FootstepLibrary.register(blockName, acousticList);
                }
            }
        } else {
            LOGGER.debug("Unable to identify block tag '%s'", tagName);
        }
    }

    private static void register(@Nonnull String key, @Nonnull String acousticList) {
        if (acousticList.startsWith("#")) {
            List<MacroEntry> macro = macros.get(acousticList);
            if (macro != null) {
                macro.stream().map(m -> m.expand(key)).forEach(t -> FootstepLibrary.register0((String)t.getLeft(), (String)t.getRight()));
            } else {
                LOGGER.debug("Unknown macro '%s'", acousticList);
            }
        } else {
            FootstepLibrary.register0(key, acousticList);
        }
    }

    @Nonnull
    public static Generator createGenerator(@Nonnull LivingEntity entity) {
        Variator var = entity.func_70631_g_() ? childVariator : (entity instanceof PlayerEntity ? ((Boolean)Config.CLIENT.footsteps.footstepsAsQuadruped.get() != false ? playerQuadrupedVariator : playerVariator) : FootstepLibrary.getVariator(entity.func_200600_R().getRegistryName().toString()));
        return var.QUADRUPED ? new GeneratorQP(var) : new Generator(var);
    }

    private static void collectData(@Nonnull BlockState state, @Nonnull List<String> data) {
        int s = data.size();
        IAcoustic temp = FootstepLibrary.getBlockAcoustics(state);
        if (temp != Constants.EMPTY) {
            data.add(temp.toString());
        }
        for (Map.Entry<Substrate, BlockAcousticMap> e : substrateMap.entrySet()) {
            IAcoustic acoustics = e.getValue().getBlockAcoustics(state);
            if (acoustics == Constants.EMPTY) continue;
            data.add((Object)((Object)e.getKey()) + ":" + acoustics.toString());
        }
        if (s == data.size()) {
            data.add("** NONE **");
        }
    }

    @Nonnull
    private static IAcoustic primitiveResolver(@Nonnull BlockState state) {
        Material mat = state.func_185904_a();
        if (mat == null || !mat.func_76230_c() || mat.func_76224_d()) {
            return Constants.NOT_EMITTER;
        }
        IAcoustic acoustic = Primitives.getFootstepAcoustic(state);
        return acoustic == NullAcoustic.INSTANCE ? Constants.NOT_EMITTER : acoustic;
    }

    public static boolean hasFootprint(@Nonnull BlockState state) {
        Boolean result = ((IMixinFootstepData)state).hasFootprint();
        if (result != null) {
            return result;
        }
        result = FOOTPRINT_STATES.get(state);
        if (result == null) {
            result = FOOTPRINT_MATERIAL.contains(state.func_185904_a()) || FOOTPRINT_SOUND_PROFILE.contains(state.func_215695_r());
        }
        ((IMixinFootstepData)state).setHasFootprint(result);
        return result;
    }

    static {
        for (Substrate s : Substrate.values()) {
            substrateMap.put(s, new BlockAcousticMap());
        }
        substrateMap.put(Substrate.NORMAL, new BlockAcousticMap(FootstepLibrary::primitiveResolver));
        FOOTPRINT_MATERIAL.add(Material.field_151571_B);
        FOOTPRINT_MATERIAL.add(Material.field_151578_c);
        FOOTPRINT_MATERIAL.add(Material.field_151583_m);
        FOOTPRINT_MATERIAL.add(Material.field_151595_p);
        FOOTPRINT_MATERIAL.add(Material.field_151596_z);
        FOOTPRINT_MATERIAL.add(Material.field_151597_y);
        FOOTPRINT_MATERIAL.add(Material.field_151568_F);
        FOOTPRINT_MATERIAL.add(Material.field_151577_b);
        MacroEntry MESSY = new MacroEntry("messy", "messy_ground");
        MacroEntry NOT_EMITTER = new MacroEntry(null, "not_emitter");
        ArrayList<MacroEntry> entries = new ArrayList<MacroEntry>(3);
        entries.add(NOT_EMITTER);
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put("#sapling", entries);
        macros.put("#reed", entries);
        entries = new ArrayList(3);
        entries.add(new MacroEntry(null, "leaves"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "brush"));
        macros.put("#plant", entries);
        entries = new ArrayList(3);
        entries.add(NOT_EMITTER);
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "brush"));
        macros.put("#tallplant", entries);
        entries = new ArrayList(3);
        entries.add(new MacroEntry(null, "leaves"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "brush_straw_transition"));
        macros.put("#bush", entries);
        entries = new ArrayList(3);
        entries.add(new MacroEntry(null, "not_emitter"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put("#deadbush", entries);
        entries = new ArrayList(2);
        entries.add(NOT_EMITTER);
        entries.add(new MacroEntry("bigger", "bluntwood"));
        macros.put("#woodfence", entries);
        entries = new ArrayList(2);
        entries.add(NOT_EMITTER);
        entries.add(new MacroEntry("bigger", "brickstone"));
        macros.put("#stonewall", entries);
        entries = new ArrayList(2);
        entries.add(NOT_EMITTER);
        entries.add(new MacroEntry("bigger", "sandstone"));
        macros.put("#sandstonewall", entries);
        entries = new ArrayList(2);
        entries.add(NOT_EMITTER);
        entries.add(new MacroEntry("foliage", "rails"));
        macros.put("#rail", entries);
        entries = new ArrayList(3);
        entries.add(new MacroEntry(null, "straw"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put("#vine", entries);
        entries = new ArrayList(3);
        entries.add(new MacroEntry(null, "nether_vines"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "nether_vines"));
        macros.put("#nethervines", entries);
        entries = new ArrayList(2);
        entries.add(NOT_EMITTER);
        entries.add(new MacroEntry("carpet", "rug"));
        macros.put("#moss", entries);
        entries = new ArrayList(10);
        entries.add(NOT_EMITTER);
        entries.add(MESSY);
        entries.add(new MacroEntry("age", "0", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "1", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "2", "foliage", "brush"));
        entries.add(new MacroEntry("age", "3", "foliage", "brush"));
        entries.add(new MacroEntry("age", "4", "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry("age", "5", "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry("age", "6", "foliage", "straw"));
        entries.add(new MacroEntry("age", "7", "foliage", "straw"));
        macros.put("#wheat", entries);
        entries = new ArrayList(10);
        entries.add(NOT_EMITTER);
        entries.add(MESSY);
        entries.add(new MacroEntry("age", "0", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "1", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "2", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "3", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "4", "foliage", "brush"));
        entries.add(new MacroEntry("age", "5", "foliage", "brush"));
        entries.add(new MacroEntry("age", "6", "foliage", "brush"));
        entries.add(new MacroEntry("age", "7", "foliage", "brush"));
        macros.put("#crop", entries);
        entries = new ArrayList(6);
        entries.add(NOT_EMITTER);
        entries.add(MESSY);
        entries.add(new MacroEntry("age", "0", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "1", "foliage", "not_emitter"));
        entries.add(new MacroEntry("age", "2", "foliage", "brush"));
        entries.add(new MacroEntry("age", "3", "foliage", "brush"));
        macros.put("#beets", entries);
    }

    private static class FootstepLibraryService
    implements IModuleService {
        private static final Type variatorType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, VariatorConfig.class}).getType();

        private FootstepLibraryService() {
        }

        @Override
        public String name() {
            return "FootstepLibrary";
        }

        @Override
        public void start() {
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "variators.json");
            IResourceAccessor.process(configs, accessor -> {
                Map cfg = (Map)accessor.as(variatorType);
                for (Map.Entry kvp : cfg.entrySet()) {
                    variators.put(kvp.getKey(), new Variator((VariatorConfig)kvp.getValue()));
                }
            });
            defaultVariator = FootstepLibrary.getVariator("default");
            childVariator = FootstepLibrary.getVariator("child");
            playerVariator = FootstepLibrary.getVariator((Boolean)Config.CLIENT.footsteps.firstPersonFootstepCadence.get() != false ? "player_slow" : "player");
            playerQuadrupedVariator = FootstepLibrary.getVariator((Boolean)Config.CLIENT.footsteps.firstPersonFootstepCadence.get() != false ? "quadruped_slow" : "quadruped");
            configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "footsteps.json");
            IResourceAccessor.process(configs, accessor -> FootstepLibrary.initFromConfig(accessor.as(FootstepConfig.class)));
            substrateMap.forEach((key, value) -> value.trim());
        }

        @Override
        public void log() {
            if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
                LOGGER.info("Registered Variators", new Object[0]);
                LOGGER.info("====================", new Object[0]);
                for (String v : variators.keySet()) {
                    LOGGER.info(v, new Object[0]);
                }
            }
        }

        @Override
        public void stop() {
            variators.clear();
            FOOTPRINT_STATES.clear();
            for (BlockAcousticMap m : substrateMap.values()) {
                m.clear();
            }
            ForgeUtils.getBlockStates().forEach(state -> ((IMixinFootstepData)state).setAcoustics(null));
        }

        static {
            Validators.registerValidator(variatorType, new MapValidator());
        }
    }

    private static class MacroEntry {
        public final String propertyName;
        public final String propertyValue;
        public final String substrate;
        public final String value;

        public MacroEntry(@Nullable String substrate, @Nonnull String value) {
            this(null, null, substrate, value);
        }

        public MacroEntry(@Nullable String propertyName, @Nullable String propertyValue, @Nullable String substrate, @Nonnull String value) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.substrate = substrate;
            this.value = value;
        }

        @Nonnull
        public Pair<String, String> expand(@Nonnull String base) {
            StringBuilder builder = new StringBuilder();
            builder.append(base);
            if (this.propertyName != null) {
                builder.append('[');
                builder.append(this.propertyName).append('=').append(this.propertyValue);
                builder.append(']');
            }
            if (this.substrate != null) {
                builder.append('+').append(this.substrate);
            }
            return Pair.of((Object)builder.toString(), (Object)this.value);
        }
    }
}

