/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.threading;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.StopWatch;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.math.TimerEMA;

public final class Worker {
    @Nonnull
    private final Thread thread = new Thread(this::run);
    @Nonnull
    private final Runnable task;
    @Nonnull
    private final IModLog logger;
    private final int frequency;
    @Nonnull
    private String diagnosticString;
    private boolean stopProcessing;

    public Worker(@Nonnull String threadName, @Nonnull Runnable task, int frequencyMsecs, @Nonnull IModLog logger) {
        this.thread.setName(threadName);
        this.thread.setDaemon(true);
        this.task = task;
        this.frequency = frequencyMsecs;
        this.logger = logger;
        this.diagnosticString = "";
    }

    private void run() {
        TimerEMA timeTrack = new TimerEMA(this.thread.getName());
        StopWatch sw = new StopWatch();
        while (!this.stopProcessing) {
            sw.start();
            try {
                this.task.run();
            }
            catch (Throwable t) {
                this.logger.error(t, "Error processing %s!", this.thread.getName());
            }
            sw.stop();
            timeTrack.update(sw.getNanoTime());
            this.diagnosticString = String.format("%s (deadline %d)", timeTrack.toString(), this.frequency);
            long sleepTime = (long)this.frequency - sw.getTime(TimeUnit.MILLISECONDS);
            sw.reset();
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (Throwable ignore) {
                    this.logger.warn("Terminating %s thread", this.thread.getName());
                    return;
                }
            }
            this.logger.warn("%s is lagging; behind %d msecs", this.thread.getName(), Math.abs(sleepTime));
        }
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        try {
            this.stopProcessing = true;
            this.thread.join();
        }
        catch (Throwable t) {
            this.logger.warn("Error stopping worker thread '%s'", this.thread.getName());
        }
    }

    @Nonnull
    public String getDiagnosticString() {
        return this.diagnosticString;
    }
}

