/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting.sets;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.biomes.BiomeUtilities;
import org.orecruncher.lib.scripting.VariableSet;
import org.orecruncher.lib.scripting.sets.IBiomeVariables;
import org.orecruncher.lib.scripting.sets.LazyVariable;

@OnlyIn(value=Dist.CLIENT)
public class BiomeVariables
extends VariableSet<IBiomeVariables>
implements IBiomeVariables {
    private Biome biome;
    private final LazyVariable<Set<BiomeDictionary.Type>> biomeTraits = new LazyVariable<Set>(() -> BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)this.biome.getRegistryName())));
    private final LazyVariable<Set<String>> biomeTraitNames = new LazyVariable<Set>(() -> this.biomeTraits.get().stream().map(BiomeDictionary.Type::getName).collect(Collectors.toSet()));
    private final LazyVariable<String> traits = new LazyVariable<String>(() -> String.join((CharSequence)" ", (Iterable<? extends CharSequence>)this.biomeTraitNames.get()));
    private final LazyVariable<String> name = new LazyVariable<String>(() -> BiomeUtilities.getBiomeName(this.biome));
    private final LazyVariable<String> modid = new LazyVariable<String>(() -> this.biome.getRegistryName().func_110624_b());
    private final LazyVariable<String> id = new LazyVariable<String>(() -> this.biome.getRegistryName().toString());
    private final LazyVariable<String> category = new LazyVariable<String>(() -> this.biome.func_201856_r().func_222352_a());
    private final LazyVariable<String> rainType = new LazyVariable<String>(() -> this.biome.func_201851_b().func_222361_a());

    public BiomeVariables() {
        super("biome");
        this.setBiome(BiomeRegistry.field_244200_a);
    }

    public void setBiome(@Nonnull Biome biome) {
        if (this.biome != biome) {
            this.update();
            this.biome = biome;
        }
    }

    @Override
    @Nonnull
    public IBiomeVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        Biome newBiome = null;
        newBiome = GameUtils.isInGame() ? BiomeUtilities.getClientBiome(GameUtils.getPlayer().func_233580_cy_()) : BiomeRegistry.field_244200_a;
        if (newBiome != this.biome) {
            this.biome = newBiome;
            this.name.reset();
            this.modid.reset();
            this.id.reset();
            this.category.reset();
            this.rainType.reset();
            this.traits.reset();
            this.biomeTraits.reset();
            this.biomeTraitNames.reset();
        }
    }

    @Override
    public String getModId() {
        return this.modid.get();
    }

    @Override
    public String getId() {
        return this.id.get();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name.get();
    }

    @Override
    public float getRainfall() {
        return this.biome.func_76727_i();
    }

    @Override
    public float getTemperature() {
        return this.biome.func_242445_k();
    }

    @Override
    public String getCategory() {
        return this.category.get();
    }

    @Override
    public String getRainType() {
        return this.rainType.get();
    }

    @Override
    public String getTraits() {
        return this.traits.get();
    }

    @Override
    public boolean is(@Nonnull String traitName) {
        return this.biomeTraitNames.get().contains(traitName.toUpperCase());
    }

    public boolean is(@Nonnull BiomeDictionary.Type type) {
        return this.biomeTraits.get().contains(type);
    }
}

