/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.reflection;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    @Nullable
    public static Field resolveField(@Nonnull String className, String ... fieldName) {
        Preconditions.checkNotNull((Object)className);
        Preconditions.checkArgument((fieldName.length > 0 ? 1 : 0) != 0, (Object)"Field name cannot be empty");
        try {
            return ReflectionHelper.resolveField(Class.forName(className), fieldName);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static Field resolveField(@Nonnull Class<?> clazz, String ... fieldName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((fieldName.length > 0 ? 1 : 0) != 0, (Object)"Field name cannot be empty");
        for (String name : fieldName) {
            try {
                Field f = clazz.getDeclaredField(name);
                f.setAccessible(true);
                return f;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    @Nullable
    public static Method resolveMethod(@Nonnull String className, @Nonnull String[] names, Class<?> ... parameters) {
        try {
            return ReflectionHelper.resolveMethod(Class.forName(className), names, parameters);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static Method resolveMethod(@Nonnull Class<?> clazz, @Nonnull String[] names, Class<?> ... parameters) {
        for (String name : names) {
            try {
                Method f = clazz.getDeclaredMethod(name, parameters);
                f.setAccessible(true);
                return f;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    @Nullable
    public static Class<?> resolveClass(@Nonnull String className) {
        Preconditions.checkNotNull((Object)className);
        try {
            return Class.forName(className);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nonnull
    public static Collection<Field> getStaticFields(@Nonnull Class<?> clazz) {
        Field[] declaredFields;
        ArrayList<Field> staticFields = new ArrayList<Field>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            staticFields.add(field);
        }
        return staticFields;
    }
}

