/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.reflection;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.reflection.ReflectionHelper;

public class ReflectedMethod<R> {
    protected final String className;
    protected final String methodName;
    protected final Method method;

    public ReflectedMethod(@Nonnull String className, @Nonnull String methodName, @Nullable String obfMethodName, Class<?> ... parameters) {
        this.className = className;
        this.methodName = methodName;
        this.method = ReflectionHelper.resolveMethod(className, new String[]{methodName, obfMethodName}, parameters);
        if (this.isNotAvailable()) {
            String msg = String.format("Unable to locate method [%s::%s]", this.className, methodName);
            Lib.LOGGER.warn(msg, new Object[0]);
        }
    }

    public ReflectedMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, @Nullable String obfMethodName, Class<?> ... parameters) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)methodName), (Object)"Field name cannot be empty");
        this.className = clazz.getName();
        this.methodName = methodName;
        this.method = ReflectionHelper.resolveMethod(clazz, new String[]{methodName, obfMethodName}, parameters);
        if (this.isNotAvailable()) {
            String msg = String.format("Unable to locate method [%s::%s]", this.className, methodName);
            Lib.LOGGER.warn(msg, new Object[0]);
        }
    }

    public boolean isNotAvailable() {
        return this.method == null;
    }

    public R invoke(Object ref, Object ... parms) {
        this.check();
        try {
            return (R)this.method.invoke(ref, parms);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void check() {
        if (this.isNotAvailable()) {
            String msg = String.format("Uninitialized method [%s::%s]", this.className, this.methodName);
            throw new IllegalStateException(msg);
        }
    }
}

