/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.config;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.lib.gui.GuiHelpers;
import org.orecruncher.lib.reflection.ObjectField;

@OnlyIn(value=Dist.CLIENT)
public final class ConfigProperty {
    public static final int TOOLTIP_WIDTH = 300;
    private static final ObjectField<ForgeConfigSpec.ConfigValue, ForgeConfigSpec> specAccessor = new ObjectField<ForgeConfigSpec.ConfigValue, ForgeConfigSpec>(ForgeConfigSpec.ConfigValue.class, () -> null, "spec");
    private static final ObjectField<Object, Object> minAccessor = new ObjectField("net.minecraftforge.common.ForgeConfigSpec$Range", () -> null, "min");
    private static final ObjectField<Object, Object> maxAccessor = new ObjectField("net.minecraftforge.common.ForgeConfigSpec$Range", () -> null, "max");
    private final ForgeConfigSpec.ValueSpec valueSpec;
    private final String name;
    private ITextComponent[] toolTip;

    private ConfigProperty(@Nonnull ForgeConfigSpec.ConfigValue<?> configEntry) {
        this(specAccessor.get(configEntry), configEntry);
    }

    private ConfigProperty(@Nonnull ForgeConfigSpec spec, @Nonnull ForgeConfigSpec.ConfigValue<?> configEntry) {
        List path = configEntry.getPath();
        this.valueSpec = (ForgeConfigSpec.ValueSpec)spec.get(path);
        this.name = (String)path.get(path.size() - 1);
    }

    public String getTranslationKey() {
        return this.valueSpec.getTranslationKey();
    }

    @Nonnull
    public IFormattableTextComponent getConfigName() {
        String key = this.getTranslationKey();
        if (StringUtils.func_151246_b((String)key)) {
            return new StringTextComponent(this.name);
        }
        return new TranslationTextComponent(key);
    }

    @Nullable
    public String getComment() {
        return this.valueSpec.getComment();
    }

    @Nullable
    public ITextComponent[] getTooltip() {
        if (this.toolTip == null) {
            ForgeConfigSpec.Range range;
            ArrayList<Object> result = new ArrayList<Object>();
            String key = this.getTranslationKey();
            if (StringUtils.func_151246_b((String)key)) {
                key = this.getComment();
                if (StringUtils.func_151246_b((String)key)) {
                    return null;
                }
                result.add(new StringTextComponent(key));
            } else {
                StringTextComponent title = new StringTextComponent(TextFormatting.GOLD + new TranslationTextComponent(key).getString());
                result.add(title);
                result.addAll(GuiHelpers.getTrimmedTextCollection(key + ".tooltip", 300, new TextFormatting[0]));
            }
            Object theDefault = this.getDefault();
            if (theDefault != null) {
                String text = theDefault.toString();
                text = text.compareToIgnoreCase("true") == 0 ? DialogTexts.field_240630_a_.getString() : (text.compareToIgnoreCase("false") == 0 ? DialogTexts.field_240631_b_.getString() : GuiHelpers.getTrimmedText(text, 300, new TextFormatting[0]).getString());
                text = new TranslationTextComponent("dsurround.text.format.default", new Object[]{text}).getString();
                result.add(new StringTextComponent(text));
            }
            if ((range = this.valueSpec.getRange()) != null) {
                result.add(new StringTextComponent(TextFormatting.GREEN + "[ " + range.toString() + " ]"));
            }
            if (this.getNeedsWorldRestart()) {
                result.add(new TranslationTextComponent("dsurround.text.tooltip.restartRequired"));
            }
            this.toolTip = result.toArray(new ITextComponent[0]);
        }
        return this.toolTip;
    }

    public boolean getNeedsWorldRestart() {
        return this.valueSpec.needsWorldRestart();
    }

    public <T> T getDefault() {
        return (T)this.valueSpec.getDefault();
    }

    public <T> T getMinValue() {
        return (T)minAccessor.get(this.valueSpec.getRange());
    }

    public <T> T getMaxValue() {
        return (T)maxAccessor.get(this.valueSpec.getRange());
    }

    @Nonnull
    public static ConfigProperty getPropertyInfo(@Nonnull ForgeConfigSpec.ConfigValue<?> configEntry) {
        return new ConfigProperty(configEntry);
    }
}

