/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.random.XorShiftRandom;

public class WeightTable<T> {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected final ObjectArray<IItem<T>> entries = new ObjectArray();
    protected int totalWeight = 0;

    public WeightTable() {
    }

    public WeightTable(@Nonnull IItem<T>[] items) {
        for (IItem<T> i : items) {
            this.add(i);
        }
    }

    public WeightTable(@Nonnull Collection<? extends IItem<T>> input) {
        for (IItem<T> i : input) {
            this.add(i);
        }
    }

    public void add(final @Nonnull T e, final int weight) {
        this.add(new IItem<T>(){

            @Override
            public int getWeight() {
                return weight;
            }

            @Override
            public T getItem() {
                return e;
            }
        });
    }

    public void add(@Nonnull IItem<T> entry) {
        this.entries.add(entry);
        this.totalWeight += entry.getWeight();
    }

    public int size() {
        return this.entries.size();
    }

    @Nullable
    public T next() {
        IItem<T> selected;
        if (this.totalWeight <= 0) {
            return null;
        }
        if (this.entries.size() == 1) {
            return this.entries.get(0).getItem();
        }
        int targetWeight = RANDOM.nextInt(this.totalWeight);
        int i = -1;
        while ((targetWeight -= (selected = this.entries.get(++i)).getWeight()) >= 0) {
        }
        return selected.getItem();
    }

    public void trim() {
        this.entries.trim();
    }

    public static interface IItem<T> {
        public int getWeight();

        public T getItem();
    }
}

