/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.environs.Environs;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.library.BiomeAdapter;
import org.orecruncher.environs.library.BiomeEvaluator;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeUtil;
import org.orecruncher.environs.library.DimensionInfo;
import org.orecruncher.environs.library.DimensionLibrary;
import org.orecruncher.environs.library.FakeBiomeAdapter;
import org.orecruncher.environs.library.WTFFakeBiomeAdapter;
import org.orecruncher.environs.library.config.BiomeConfig;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.service.ModuleServiceManager;
import org.orecruncher.lib.validation.ListValidator;
import org.orecruncher.lib.validation.Validators;

@OnlyIn(value=Dist.CLIENT)
public final class BiomeLibrary {
    private static final IModLog LOGGER = Environs.LOGGER.createChild(BiomeLibrary.class);
    private static final int INSIDE_Y_ADJUST = 3;
    public static final FakeBiomeAdapter UNDERGROUND = new FakeBiomeAdapter("Underground");
    public static final FakeBiomeAdapter PLAYER = new FakeBiomeAdapter("Player");
    public static final FakeBiomeAdapter UNDERWATER = new FakeBiomeAdapter("Underwater");
    public static final FakeBiomeAdapter UNDEROCEAN = new FakeBiomeAdapter("UnderOCN");
    public static final FakeBiomeAdapter UNDERDEEPOCEAN = new FakeBiomeAdapter("UnderDOCN");
    public static final FakeBiomeAdapter UNDERRIVER = new FakeBiomeAdapter("UnderRVR");
    public static final FakeBiomeAdapter OUTERSPACE = new FakeBiomeAdapter("OuterSpace");
    public static final FakeBiomeAdapter CLOUDS = new FakeBiomeAdapter("Clouds");
    public static final FakeBiomeAdapter VILLAGE = new FakeBiomeAdapter("Village");
    private static final FakeBiomeAdapter WTF = new WTFFakeBiomeAdapter();
    public static final BiomeInfo UNDERGROUND_INFO = UNDERGROUND.getBiomeData();
    public static final BiomeInfo PLAYER_INFO = PLAYER.getBiomeData();
    public static final BiomeInfo UNDERRIVER_INFO = UNDERRIVER.getBiomeData();
    public static final BiomeInfo UNDEROCEAN_INFO = UNDEROCEAN.getBiomeData();
    public static final BiomeInfo UNDERDEEPOCEAN_INFO = UNDERDEEPOCEAN.getBiomeData();
    public static final BiomeInfo UNDERWATER_INFO = UNDERWATER.getBiomeData();
    public static final BiomeInfo OUTERSPACE_INFO = OUTERSPACE.getBiomeData();
    public static final BiomeInfo CLOUDS_INFO = CLOUDS.getBiomeData();
    public static final BiomeInfo VILLAGE_INFO = VILLAGE.getBiomeData();
    public static final BiomeInfo WTF_INFO = WTF.getBiomeData();
    private static final ObjectOpenHashSet<FakeBiomeAdapter> theFakes = new ObjectOpenHashSet();

    private BiomeLibrary() {
    }

    static void initialize() {
        ModuleServiceManager.instance().add(new BiomeLibraryService());
    }

    static void initFromConfig(@Nonnull List<BiomeConfig> cfg) {
        if (cfg.size() > 0) {
            BiomeEvaluator evaluator = new BiomeEvaluator();
            for (BiomeInfo bi : BiomeLibrary.getCombinedStream()) {
                evaluator.update(bi);
                for (BiomeConfig c : cfg) {
                    if (!evaluator.matches(c.conditions)) continue;
                    try {
                        bi.update(c);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Unable to process biome sound configuration [%s]", c.toString());
                    }
                }
            }
        }
    }

    @Nonnull
    public static BiomeInfo getPlayerBiome(@Nonnull PlayerEntity player, boolean getTrue) {
        Biome biome = player.func_130014_f_().func_226691_t_(new BlockPos(player.func_226277_ct_(), 0.0, player.func_226281_cx_()));
        BiomeInfo info = BiomeUtil.getBiomeData(biome);
        if (!getTrue) {
            if (player.func_208600_a((ITag)FluidTags.field_206959_a)) {
                info = info.isRiver() ? UNDERRIVER_INFO : (info.isDeepOcean() ? UNDERDEEPOCEAN_INFO : (info.isOcean() ? UNDEROCEAN_INFO : UNDERWATER_INFO));
            } else {
                DimensionInfo dimInfo = DimensionLibrary.getData(player.func_130014_f_());
                int theY = MathStuff.floor(player.func_226278_cu_());
                if (theY + 3 <= dimInfo.getSeaLevel()) {
                    info = UNDERGROUND_INFO;
                } else if (theY >= dimInfo.getSpaceHeight()) {
                    info = OUTERSPACE_INFO;
                } else if (theY >= dimInfo.getCloudHeight()) {
                    info = CLOUDS_INFO;
                }
            }
        }
        return info;
    }

    private static Collection<BiomeInfo> getCombinedStream() {
        return Stream.concat(ForgeUtils.getBiomes().stream().map(BiomeUtil::getBiomeData), theFakes.stream().map(FakeBiomeAdapter::getBiomeData)).collect(Collectors.toCollection(ArrayList::new));
    }

    static {
        theFakes.add((Object)UNDERGROUND);
        theFakes.add((Object)PLAYER);
        theFakes.add((Object)UNDERWATER);
        theFakes.add((Object)UNDEROCEAN);
        theFakes.add((Object)UNDERDEEPOCEAN);
        theFakes.add((Object)UNDERRIVER);
        theFakes.add((Object)OUTERSPACE);
        theFakes.add((Object)CLOUDS);
        theFakes.add((Object)VILLAGE);
        theFakes.add((Object)WTF);
    }

    static class BiomeLibraryService
    implements IModuleService {
        private static final Type biomeType = TypeToken.getParameterized(List.class, (Type[])new Type[]{BiomeConfig.class}).getType();

        BiomeLibraryService() {
        }

        @Override
        public String name() {
            return "BiomeLibrary";
        }

        @Override
        public void start() {
            ForgeUtils.getBiomes().forEach(b -> {
                BiomeAdapter handler = new BiomeAdapter((Biome)b);
                BiomeUtil.setBiomeData(b, new BiomeInfo(handler));
            });
            BiomeUtil.getBiomeData(BiomeRegistry.field_244200_a);
            BiomeUtil.getBiomeData(BiomeRegistry.field_244201_b);
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "biomes.json");
            IResourceAccessor.process(configs, accessor -> BiomeLibrary.initFromConfig((List)accessor.as(biomeType)));
        }

        @Override
        public void log() {
            if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
                LOGGER.info("*** BIOME REGISTRY ***", new Object[0]);
                BiomeLibrary.getCombinedStream().stream().sorted().map(Object::toString).forEach(arg_0 -> BiomeLibraryService.lambda$log$2(LOGGER, arg_0));
            }
            BiomeLibrary.getCombinedStream().forEach(BiomeInfo::trim);
        }

        @Override
        public void stop() {
            ForgeUtils.getBiomes().forEach(b -> BiomeUtil.setBiomeData(b, null));
            BiomeUtil.setBiomeData(BiomeRegistry.field_244200_a, null);
            BiomeUtil.setBiomeData(BiomeRegistry.field_244201_b, null);
        }

        private static /* synthetic */ void lambda$log$2(IModLog rec$, String x$0) {
            rec$.info(x$0, new Object[0]);
        }

        static {
            Validators.registerValidator(biomeType, new ListValidator());
        }
    }
}

