/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.particles.ParticleHooks;
import org.orecruncher.lib.biomes.BiomeUtilities;
import org.orecruncher.lib.gui.Color;
import org.orecruncher.lib.particles.MotionMote;
import org.orecruncher.lib.particles.ParticleCollisionResult;
import org.orecruncher.lib.random.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public class MoteWaterSpray
extends MotionMote {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected float scale;
    protected final float texU1;
    protected final float texU2;
    protected final float texV1;
    protected final float texV2;

    public MoteWaterSpray(IBlockReader world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z, dX, dY, dZ);
        this.maxAge = (int)(8.0f / (RANDOM.nextFloat() * 0.8f + 0.2f));
        this.scale = (RANDOM.nextFloat() * 0.5f + 0.5f) * 2.0f * 0.07f;
        int textureIdx = RANDOM.nextInt(4);
        int texX = textureIdx % 2;
        int texY = textureIdx / 2;
        this.texU1 = (float)texX * 0.5f;
        this.texU2 = this.texU1 + 0.5f;
        this.texV1 = (float)texY * 0.5f;
        this.texV2 = this.texV1 + 0.5f;
    }

    @Override
    public void configureColor() {
        Color waterColor = BiomeUtilities.getColorForLiquid(this.world, (BlockPos)this.position);
        this.red = waterColor.red();
        this.green = waterColor.green();
        this.blue = waterColor.blue();
        this.alpha = 0.99f;
    }

    @Override
    public void handleCollision(@Nonnull ParticleCollisionResult collision) {
        ParticleHooks.splashHandler((Fluid)Fluids.field_204546_a, collision, false);
        super.handleCollision(collision);
    }

    @Override
    public void renderParticle(@Nonnull IVertexBuilder buffer, @Nonnull ActiveRenderInfo info, float partialTicks) {
        float x = this.renderX(info, partialTicks);
        float y = this.renderY(info, partialTicks);
        float z = this.renderZ(info, partialTicks);
        Quaternion quaternion = info.func_227995_f_();
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(this.scale);
            vector3f.func_195904_b(x, y, z);
        }
        this.drawVertex(buffer, avector3f[0].func_195899_a(), avector3f[0].func_195900_b(), avector3f[0].func_195902_c(), this.texU2, this.texV2);
        this.drawVertex(buffer, avector3f[1].func_195899_a(), avector3f[1].func_195900_b(), avector3f[1].func_195902_c(), this.texU2, this.texV1);
        this.drawVertex(buffer, avector3f[2].func_195899_a(), avector3f[2].func_195900_b(), avector3f[2].func_195902_c(), this.texU1, this.texV1);
        this.drawVertex(buffer, avector3f[3].func_195899_a(), avector3f[3].func_195900_b(), avector3f[3].func_195902_c(), this.texU1, this.texV2);
    }
}

