/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.emitters;

import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.emitters.Jet;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.api.acoustics.Library;

@OnlyIn(value=Dist.CLIENT)
public class FireJet
extends Jet {
    private static final ResourceLocation FIRE_ACOUSTIC = new ResourceLocation("block.fire.ambient");
    protected final boolean isLava;
    protected final IParticleData particleType;
    protected final boolean isSolid;
    protected boolean soundFired;

    public FireJet(int strength, IBlockReader world, double x, double y, double z, boolean isSolid) {
        super(strength, world, x, y, z);
        this.isLava = !isSolid && RANDOM.nextInt(3) == 0;
        this.particleType = this.isLava ? ParticleTypes.field_197595_F : ParticleTypes.field_197631_x;
        this.isSolid = isSolid;
    }

    @Override
    protected void soundUpdate() {
        if (!this.soundFired) {
            this.soundFired = true;
            if (this.jetStrength > 1) {
                Library.resolve(FIRE_ACOUSTIC).playAt(this.getPos());
            }
        }
    }

    @Override
    protected void spawnJetParticle() {
        Particle particle;
        double speedY = this.isLava ? 0.0 : (double)this.jetStrength / 10.0;
        float scale = this.jetStrength;
        double x = this.posX;
        double z = this.posZ;
        if (this.isSolid) {
            x += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            z += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            if (this.jetStrength == 1) {
                speedY *= 0.5;
                scale *= 0.5f;
            }
        }
        if ((particle = GameUtils.getMC().field_71452_i.func_199280_a(this.particleType, x, this.posY, z, 0.0, speedY, 0.0)) instanceof FlameParticle) {
            particle.func_70541_f(scale);
        }
    }
}

