/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.impl.creation;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BufferStructure {
    private final Map<AccessorModel, String> accessorIds = new LinkedHashMap<AccessorModel, String>();
    private final List<BufferViewModel> bufferViewModels = new ArrayList<BufferViewModel>();
    private final Map<BufferViewModel, String> bufferViewIds = new LinkedHashMap<BufferViewModel, String>();
    private final Map<BufferViewModel, List<AccessorModel>> bufferViewAccessorModels = new LinkedHashMap<BufferViewModel, List<AccessorModel>>();
    private final List<BufferModel> bufferModels = new ArrayList<BufferModel>();
    private final Map<BufferModel, String> bufferIds = new LinkedHashMap<BufferModel, String>();
    private final Map<BufferModel, List<BufferViewModel>> bufferBufferViewModels = new LinkedHashMap<BufferModel, List<BufferViewModel>>();
    private final Map<BufferModel, Set<Integer>> paddingByteIndices = new LinkedHashMap<BufferModel, Set<Integer>>();

    BufferStructure() {
    }

    void addAccessorModel(AccessorModel accessorModel, String accessorId) {
        this.accessorIds.put(accessorModel, accessorId);
    }

    void addBufferViewModel(BufferViewModel bufferViewModel, String bufferViewId, Collection<? extends AccessorModel> accessorModels) {
        this.bufferViewModels.add(bufferViewModel);
        this.bufferViewIds.put(bufferViewModel, bufferViewId);
        this.bufferViewAccessorModels.put(bufferViewModel, new ArrayList<AccessorModel>(accessorModels));
    }

    void addBufferModel(BufferModel bufferModel, String bufferId, Collection<? extends BufferViewModel> bufferViewModels) {
        this.bufferModels.add(bufferModel);
        this.bufferIds.put(bufferModel, bufferId);
        this.bufferBufferViewModels.put(bufferModel, new ArrayList<BufferViewModel>(bufferViewModels));
    }

    private void addPaddingByteIndex(BufferModel bufferModel, int index) {
        this.paddingByteIndices.computeIfAbsent(bufferModel, bm -> new LinkedHashSet()).add(index);
    }

    void addPaddingByteIndices(BufferModel bufferModel, int startIndex, int count) {
        for (int index = startIndex; index < startIndex + count; ++index) {
            this.addPaddingByteIndex(bufferModel, index);
        }
    }

    public List<BufferModel> getBufferModels() {
        return Collections.unmodifiableList(this.bufferModels);
    }

    public String getBufferId(BufferModel bufferModel) {
        return this.bufferIds.get(bufferModel);
    }

    public List<BufferViewModel> getBufferViewModels(BufferModel bufferModel) {
        List<BufferViewModel> bufferViewModels = this.bufferBufferViewModels.get(bufferModel);
        if (bufferViewModels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(bufferViewModels);
    }

    public List<BufferViewModel> getBufferViewModels() {
        return Collections.unmodifiableList(this.bufferViewModels);
    }

    public String getBufferViewId(BufferViewModel bufferViewModel) {
        return this.bufferViewIds.get(bufferViewModel);
    }

    public List<AccessorModel> getAccessorModels(BufferViewModel bufferViewModel) {
        List<AccessorModel> accessorModels = this.bufferViewAccessorModels.get(bufferViewModel);
        if (accessorModels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(accessorModels);
    }

    public List<AccessorModel> getAccessorModels() {
        ArrayList<AccessorModel> allAccessorModels = new ArrayList<AccessorModel>(this.accessorIds.keySet());
        return Collections.unmodifiableList(allAccessorModels);
    }

    public String getAccessorId(AccessorModel accessorModel) {
        return this.accessorIds.get(accessorModel);
    }

    public boolean isPaddingByteIndex(BufferModel bufferModel, int index) {
        Set<Integer> indices = this.paddingByteIndices.get(bufferModel);
        if (indices == null) {
            return false;
        }
        return indices.contains(index);
    }
}

