/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.world;

import com.google.common.collect.Sets;
import com.tac.guns.Config;
import com.tac.guns.init.ModTags;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ProjectileExplosion
extends Explosion {
    private static final ExplosionContext DEFAULT_CONTEXT = new ExplosionContext();
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final float radius;
    private final Entity exploder;
    private final ExplosionContext context;

    public ProjectileExplosion(World world, Entity exploder, @Nullable DamageSource source, @Nullable ExplosionContext context, double x, double y, double z, float power, float radius, Explosion.Mode mode) {
        super(world, exploder, source, context, x, y, z, radius, ((Boolean)Config.SERVER.gameplay.explosionCauseFire.get()).booleanValue(), mode);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.power = power;
        this.radius = radius;
        this.exploder = exploder;
        this.context = context == null ? DEFAULT_CONTEXT : context;
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double d0 = (float)x / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)y / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)z / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.x;
                    double blockY = this.y;
                    double blockZ = this.z;
                    for (float f = this.radius * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.225f) {
                        FluidState fluidState;
                        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
                        BlockState blockState = this.world.func_180495_p(pos);
                        Optional optional = this.context.func_230312_a_((Explosion)this, (IBlockReader)this.world, pos, blockState, fluidState = this.world.func_204610_c(pos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.context.func_230311_a_((Explosion)this, (IBlockReader)this.world, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)0.3f;
                        blockY += d1 * (double)0.3f;
                        blockZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        float radius = this.radius;
        int minX = MathHelper.func_76128_c((double)(this.x - (double)radius - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.x + (double)radius + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.y - (double)radius - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.y + (double)radius + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.z - (double)radius - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.z + (double)radius + 1.0));
        List entities = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)entities, (double)(radius *= 2.0f));
        Vector3d explosionPos = new Vector3d(this.x, this.y, this.z);
        for (Entity entity : entities) {
            PlayerEntity player;
            double deltaZ;
            double deltaY;
            double deltaX;
            double strength;
            if (entity.func_180427_aV()) continue;
            AxisAlignedBB boundingBox = entity.func_174813_aQ();
            double minDistance = radius;
            Vector3d[] d = new Vector3d[15];
            if (!(entity instanceof LivingEntity)) {
                strength = MathHelper.func_76133_a((double)entity.func_195048_a(explosionPos)) * 2.0f / radius;
                deltaX = entity.func_226277_ct_() - this.x;
                deltaY = (entity instanceof TNTEntity ? entity.func_226278_cu_() : entity.func_226280_cw_()) - this.y;
                deltaZ = entity.func_226281_cx_() - this.z;
            } else {
                deltaX = (boundingBox.field_72336_d + boundingBox.field_72340_a) / 2.0;
                deltaY = (boundingBox.field_72337_e + boundingBox.field_72338_b) / 2.0;
                deltaZ = (boundingBox.field_72334_f + boundingBox.field_72339_c) / 2.0;
                d[0] = new Vector3d(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c);
                d[1] = new Vector3d(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
                d[2] = new Vector3d(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
                d[3] = new Vector3d(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
                d[4] = new Vector3d(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
                d[5] = new Vector3d(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
                d[6] = new Vector3d(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
                d[7] = new Vector3d(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
                d[8] = new Vector3d(boundingBox.field_72340_a, deltaY, deltaZ);
                d[9] = new Vector3d(boundingBox.field_72336_d, deltaY, deltaZ);
                d[10] = new Vector3d(deltaX, boundingBox.field_72338_b, deltaZ);
                d[11] = new Vector3d(deltaX, boundingBox.field_72337_e, deltaZ);
                d[12] = new Vector3d(deltaX, deltaY, boundingBox.field_72339_c);
                d[13] = new Vector3d(deltaX, deltaY, boundingBox.field_72334_f);
                d[14] = new Vector3d(deltaX, deltaY, deltaZ);
                for (int i = 0; i < 15; ++i) {
                    BlockRayTraceResult result = ProjectileExplosion.rayTraceBlocks(this.world, new RayTraceContext(explosionPos, d[i], RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
                    minDistance = result.func_216346_c() != RayTraceResult.Type.BLOCK ? Math.min(minDistance, explosionPos.func_72438_d(d[i])) : minDistance;
                }
                strength = minDistance * 2.0 / (double)radius;
                deltaX -= this.x;
                deltaY -= this.y;
                deltaZ -= this.z;
            }
            if (strength > 1.0) continue;
            double distanceToExplosion = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            } else {
                deltaX = 0.0;
                deltaY = 1.0;
                deltaZ = 0.0;
            }
            double damage = 1.0 - strength;
            entity.func_70097_a(this.func_199591_b(), (float)damage * this.power);
            if (entity instanceof LivingEntity) {
                damage = (float)ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)damage);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(deltaX * damage * (double)radius / 5.0, deltaY * damage * (double)radius / 5.0, deltaZ * damage * (double)radius / 5.0));
            if (!(entity instanceof PlayerEntity) || (player = (PlayerEntity)entity).func_175149_v() || player.func_184812_l_() && player.field_71075_bZ.field_75100_b) continue;
            this.func_77277_b().put(player, new Vector3d(deltaX * damage * (double)radius / 5.0, deltaY * damage * (double)radius / 5.0, deltaZ * damage * (double)radius / 5.0));
        }
    }

    private static BlockRayTraceResult rayTraceBlocks(World world, RayTraceContext context) {
        return ProjectileExplosion.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            boolean pass = block.func_203417_a(ModTags.bullet_ignore);
            if (pass) {
                return null;
            }
            return ProjectileExplosion.getBlockRayTraceResult(world, rayTraceContext, blockPos, blockState);
        }, rayTraceContext -> {
            Vector3d Vector3d2 = rayTraceContext.func_222253_b().func_178788_d(rayTraceContext.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vector3d)rayTraceContext.func_222250_a(), (Direction)Direction.func_210769_a((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72448_b, (double)Vector3d2.field_72449_c), (BlockPos)new BlockPos(rayTraceContext.func_222250_a()));
        });
    }

    @Nullable
    private static BlockRayTraceResult getBlockRayTraceResult(World world, RayTraceContext rayTraceContext, BlockPos blockPos, BlockState blockState) {
        FluidState fluidState = world.func_204610_c(blockPos);
        Vector3d startVec = rayTraceContext.func_222253_b();
        Vector3d endVec = rayTraceContext.func_222250_a();
        VoxelShape blockShape = rayTraceContext.func_222251_a(blockState, (IBlockReader)world, blockPos);
        BlockRayTraceResult blockResult = world.func_217296_a(startVec, endVec, blockPos, blockShape, blockState);
        VoxelShape fluidShape = rayTraceContext.func_222252_a(fluidState, (IBlockReader)world, blockPos);
        BlockRayTraceResult fluidResult = fluidShape.func_212433_a(startVec, endVec, blockPos);
        double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(blockResult.func_216347_e());
        double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(fluidResult.func_216347_e());
        return blockDistance <= fluidDistance ? blockResult : fluidResult;
    }

    private static <T> T performRayTrace(RayTraceContext context, BiFunction<RayTraceContext, BlockPos, T> hitFunction, Function<RayTraceContext, T> missFactory) {
        int blockZ;
        int blockY;
        Vector3d endVec;
        Vector3d startVec = context.func_222253_b();
        if (startVec.equals((Object)(endVec = context.func_222250_a()))) {
            return missFactory.apply(context);
        }
        double startX = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72450_a, (double)startVec.field_72450_a);
        double startY = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72448_b, (double)startVec.field_72448_b);
        double startZ = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72449_c, (double)startVec.field_72449_c);
        double endX = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72450_a, (double)endVec.field_72450_a);
        double endY = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72448_b, (double)endVec.field_72448_b);
        double endZ = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72449_c, (double)endVec.field_72449_c);
        int blockX = MathHelper.func_76128_c((double)endX);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(blockX, blockY = MathHelper.func_76128_c((double)endY), blockZ = MathHelper.func_76128_c((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = MathHelper.func_219802_k((double)deltaX);
        int signY = MathHelper.func_219802_k((double)deltaY);
        int signZ = MathHelper.func_219802_k((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - MathHelper.func_181162_h((double)endX) : MathHelper.func_181162_h((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - MathHelper.func_181162_h((double)endY) : MathHelper.func_181162_h((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - MathHelper.func_181162_h((double)endZ) : MathHelper.func_181162_h((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.func_181079_c(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return missFactory.apply(context);
    }
}

