/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class IDLNBTUtil {
    public static final String MOD_SECTION_NAME = "tac_nbt";

    public static CompoundNBT getNBT(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static CompoundNBT getNBTReadOnly(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        return nbt;
    }

    public static CompoundNBT getNBT(Entity entity) {
        CompoundNBT nbt = entity.getPersistentData();
        return nbt;
    }

    public static CompoundNBT getNBT(CompoundNBT tag) {
        if (tag == null) {
            return new CompoundNBT();
        }
        return tag;
    }

    @Nullable
    public static boolean stackHasKey(ItemStack stack, String key) {
        return !stack.func_190926_b() && IDLNBTUtil.getNBTReadOnly(stack).func_74764_b(key);
    }

    public static boolean setBoolean(ItemStack stack, String key, boolean value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74757_a(key, value);
        return true;
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74767_n(key);
        }
        return defaultVal;
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74767_n(key);
        }
        return false;
    }

    public static boolean getBooleanDF(ItemStack stack, String key, boolean defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74767_n(key);
        }
        return defaultVal;
    }

    public static boolean setDouble(ItemStack stack, String key, double value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74780_a(key, value);
        return true;
    }

    public static double getDouble(ItemStack stack, String key, double defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74769_h(key);
        }
        return defaultVal;
    }

    public static boolean setLong(ItemStack stack, String key, long value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74772_a(key, value);
        return true;
    }

    public static boolean setInt(ItemStack stack, String key, int value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74768_a(key, value);
        return true;
    }

    public static boolean setIntOptimized(ItemStack stack, String key, int value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        if (nbt.func_74762_e(key) != value) {
            nbt.func_74768_a(key, value);
        }
        return true;
    }

    public static boolean setInt(Entity entity, String key, int value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(entity);
        nbt.func_74768_a(key, value);
        return true;
    }

    public static boolean setIntAuto(Entity entity, String key, int value) {
        if (entity instanceof PlayerEntity) {
            IDLNBTUtil.setPlayerIdeallandTagSafe((PlayerEntity)entity, key, value);
            return true;
        }
        CompoundNBT nbt = IDLNBTUtil.getNBT(entity);
        nbt.func_74768_a(key, value);
        return true;
    }

    public static boolean addIntAuto(Entity entity, String key, int value) {
        int oldVal = IDLNBTUtil.getIntAuto(entity, key, 0);
        IDLNBTUtil.setIntAuto(entity, key, value + oldVal);
        return true;
    }

    public static int getInt(Entity entity, String key, int defaultVal) {
        if (IDLNBTUtil.entityHasKey(entity, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBT(entity);
            return nbt.func_74762_e(key);
        }
        return defaultVal;
    }

    public static int getIntAuto(Entity entity, String key, int defaultVal) {
        if (entity instanceof PlayerEntity) {
            return IDLNBTUtil.getPlayerIdeallandIntSafe((PlayerEntity)entity, key);
        }
        if (IDLNBTUtil.entityHasKey(entity, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBT(entity);
            return nbt.func_74762_e(key);
        }
        return defaultVal;
    }

    public static int getInt(ItemStack stack, String key, int defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74762_e(key);
        }
        return defaultVal;
    }

    public static long getLong(ItemStack stack, String key, int defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74763_f(key);
        }
        return defaultVal;
    }

    public static int getInt(ItemStack stack, String key) {
        return IDLNBTUtil.getInt(stack, key, 0);
    }

    public static String getString(ItemStack stack, String key, String defaultVal) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74779_i(key);
        }
        return defaultVal;
    }

    public static boolean setString(ItemStack stack, String key, String value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74778_a(key, value);
        return true;
    }

    @Nullable
    public static boolean entityHasKey(Entity entity, String key) {
        return IDLNBTUtil.getNBT(entity).func_74764_b(key);
    }

    public static boolean getBoolean(Entity entity, String key, boolean defaultVal) {
        if (IDLNBTUtil.entityHasKey(entity, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBT(entity);
            return nbt.func_74767_n(key);
        }
        return defaultVal;
    }

    public static boolean setBoolean(Entity stack, String key, boolean value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74757_a(key, value);
        return true;
    }

    public static boolean setString(Entity stack, String key, String value) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74778_a(key, value);
        return true;
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        if (IDLNBTUtil.stackHasKey(stack, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBTReadOnly(stack);
            return nbt.func_74759_k(key);
        }
        return new int[0];
    }

    public static int[] getIntArray(LivingEntity entity, String key) {
        if (IDLNBTUtil.entityHasKey((Entity)entity, key)) {
            CompoundNBT nbt = IDLNBTUtil.getNBT((Entity)entity);
            return nbt.func_74759_k(key);
        }
        return new int[0];
    }

    public static void setIntArray(ItemStack stack, String key, int[] array) {
        CompoundNBT nbt = IDLNBTUtil.getNBT(stack);
        nbt.func_74783_a(key, array);
    }

    public static CompoundNBT getTagSafe(CompoundNBT tag, String key) {
        if (tag == null) {
            return new CompoundNBT();
        }
        return tag.func_74775_l(key);
    }

    public static CompoundNBT getPlyrIdlTagSafe(PlayerEntity player) {
        if (player == null) {
            return new CompoundNBT();
        }
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        return IDLNBTUtil.getTagSafe(data, MOD_SECTION_NAME);
    }

    public static CompoundNBT getPlayerIdeallandTagGroupSafe(PlayerEntity player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).func_74775_l(key);
    }

    public static int[] getPlayerIdeallandIntArraySafe(PlayerEntity player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).func_74759_k(key);
    }

    public static int getPlayerIdeallandIntSafe(PlayerEntity player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).func_74762_e(key);
    }

    public static float getPlayerIdeallandFloatSafe(PlayerEntity player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).func_74760_g(key);
    }

    public static double getPlayerIdeallandDoubleSafe(PlayerEntity player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).func_74769_h(key);
    }

    public static boolean getPlayerIdeallandBoolSafe(PlayerEntity player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).func_74767_n(key);
    }

    public static String getPlayerIdeallandStrSafe(PlayerEntity player, String key) {
        return IDLNBTUtil.getPlyrIdlTagSafe(player).func_74779_i(key);
    }

    public static BlockPos getPlayerIdeallandBlockPosSafe(PlayerEntity player, String key) {
        if (player == null) {
            return BlockPos.field_177992_a;
        }
        INBT inbt = IDLNBTUtil.getPlyrIdlTagSafe(player).func_74781_a(key);
        if (inbt instanceof CompoundNBT) {
            return NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)inbt));
        }
        return BlockPos.field_177992_a;
    }

    public static void setPlayerIdeallandTagSafe(PlayerEntity player, String key, int value) {
        if (player == null) {
            return;
        }
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundNBT idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.func_74768_a(key, value);
        data.func_218657_a(MOD_SECTION_NAME, (INBT)idl_data);
        playerData.func_218657_a("PlayerPersisted", (INBT)data);
    }

    public static void setPlayerIdeallandTagSafe(PlayerEntity player, String key, int[] value) {
        if (player == null) {
            return;
        }
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundNBT idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.func_74783_a(key, value);
        data.func_218657_a(MOD_SECTION_NAME, (INBT)idl_data);
        playerData.func_218657_a("PlayerPersisted", (INBT)data);
    }

    public static void setPlayerIdeallandTagSafe(PlayerEntity player, String key, double value) {
        if (player == null) {
            return;
        }
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundNBT idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.func_74780_a(key, value);
        data.func_218657_a(MOD_SECTION_NAME, (INBT)idl_data);
        playerData.func_218657_a("PlayerPersisted", (INBT)data);
    }

    public static void setPlayerIdeallandTagSafe(PlayerEntity player, String key, boolean value) {
        if (player == null) {
            return;
        }
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundNBT idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.func_74757_a(key, value);
        data.func_218657_a(MOD_SECTION_NAME, (INBT)idl_data);
        playerData.func_218657_a("PlayerPersisted", (INBT)data);
    }

    public static void setPlayerIdeallandTagSafe(PlayerEntity player, String key, String value) {
        if (player == null) {
            return;
        }
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundNBT idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.func_74778_a(key, value);
        data.func_218657_a(MOD_SECTION_NAME, (INBT)idl_data);
        playerData.func_218657_a("PlayerPersisted", (INBT)data);
    }

    public static void setPlayerIdeallandTagSafe(PlayerEntity player, String key, BlockPos value) {
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = IDLNBTUtil.getTagSafe(playerData, "PlayerPersisted");
        CompoundNBT idl_data = IDLNBTUtil.getPlyrIdlTagSafe(player);
        idl_data.func_218657_a(key, (INBT)NBTUtil.func_186859_a((BlockPos)value));
        data.func_218657_a(MOD_SECTION_NAME, (INBT)idl_data);
        playerData.func_218657_a("PlayerPersisted", (INBT)data);
    }
}

