/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.util;

import com.tac.guns.common.Gun;
import com.tac.guns.common.attachments.CustomModifierData;
import com.tac.guns.common.attachments.Perks;
import com.tac.guns.common.attachments.perk.DoublePerk;
import com.tac.guns.common.attachments.perk.FloatPerk;
import com.tac.guns.common.attachments.perk.IntPerk;
import com.tac.guns.common.container.slot.SlotType;
import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.GunSkinItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.attachment.impl.Attachment;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.util.GunEnchantmentHelper;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GunModifierHelper {
    private static final IGunModifier[] EMPTY = new IGunModifier[0];

    public static double applyMultiplier(ItemStack weapon, double input, DoublePerk p) {
        double output = input;
        for (int i = 0; i < SlotType.values().length; ++i) {
            CustomModifierData modifier = GunModifierHelper.getCustomModifier(weapon, SlotType.values()[i]);
            double perk = 0.0;
            if (modifier != null) {
                perk = (Double)p.getValue(modifier);
            }
            if (!(perk > 0.0)) continue;
            output *= perk;
        }
        return output;
    }

    public static float applyMultiplier(ItemStack weapon, float input, FloatPerk p) {
        float output = input;
        for (int i = 0; i < SlotType.values().length; ++i) {
            CustomModifierData modifier = GunModifierHelper.getCustomModifier(weapon, SlotType.values()[i]);
            float perk = 0.0f;
            if (modifier != null) {
                perk = ((Float)p.getValue(modifier)).floatValue();
            }
            if (!(perk > 0.0f)) continue;
            output *= perk;
        }
        return output;
    }

    public static float applyAdditional(ItemStack weapon, float input, FloatPerk p) {
        float output = input;
        for (int i = 0; i < SlotType.values().length; ++i) {
            CustomModifierData modifier = GunModifierHelper.getCustomModifier(weapon, SlotType.values()[i]);
            if (modifier == null) continue;
            output += ((Float)p.getValue(modifier)).floatValue();
        }
        return output;
    }

    public static int applyAdditional(ItemStack weapon, int input, IntPerk p) {
        int output = input;
        for (int i = 0; i < SlotType.values().length; ++i) {
            CustomModifierData modifier = GunModifierHelper.getCustomModifier(weapon, SlotType.values()[i]);
            if (modifier == null) continue;
            output += ((Integer)p.getValue(modifier)).intValue();
        }
        return output;
    }

    public static int applyAmmoAdditional(ItemStack weapon, int input, IntPerk p) {
        int output = input;
        for (int i = 0; i < SlotType.values().length; ++i) {
            CustomModifierData modifier = GunModifierHelper.getCustomModifier(weapon, SlotType.values()[i]);
            if (modifier == null) continue;
            output = Math.max(output, (Integer)p.getValue(modifier));
        }
        return output;
    }

    @Nullable
    public static CustomModifierData getCustomModifier(ItemStack weapon, SlotType type) {
        ItemStack stack;
        if (weapon.func_77973_b() instanceof TimelessGunItem && (stack = Gun.getAttachment(type, weapon)) != null) {
            return Attachment.getCustomModifier(stack);
        }
        return null;
    }

    private static IGunModifier[] getModifiers(ItemStack weapon) {
        if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof TimelessGunItem) {
            TimelessGunItem gunItem = (TimelessGunItem)weapon.func_77973_b();
            return gunItem.getModifiers();
        }
        return EMPTY;
    }

    public static int getModifiedProjectileLife(ItemStack weapon, int life) {
        IGunModifier[] modifiers;
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            life = modifier.modifyProjectileLife(life);
        }
        return life;
    }

    public static double getModifiedProjectileGravity(ItemStack weapon, double gravity) {
        IGunModifier[] modifierD;
        IGunModifier[] modifiersD;
        for (IGunModifier modifier : modifiersD = GunModifierHelper.getModifiers(weapon)) {
            gravity = modifier.modifyProjectileGravity(gravity);
        }
        for (IGunModifier modifier : modifierD = GunModifierHelper.getModifiers(weapon)) {
            gravity += modifier.additionalProjectileGravity();
        }
        return gravity;
    }

    public static float getModifiedSpread(ItemStack weapon, float spread) {
        IGunModifier[] modifiers;
        spread = GunModifierHelper.applyMultiplier(weapon, spread, Perks.modifyProjectileSpread);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            spread = modifier.modifyProjectileSpread(spread);
        }
        return spread;
    }

    public static float getModifiedFirstShotSpread(ItemStack weapon, float spread) {
        IGunModifier[] modifiers;
        spread = GunModifierHelper.applyMultiplier(weapon, spread, Perks.modifyFirstShotSpread);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            spread = modifier.modifyFirstShotSpread(spread);
        }
        return spread;
    }

    public static float getModifiedHipFireSpread(ItemStack weapon, float spread) {
        IGunModifier[] modifiers;
        spread = GunModifierHelper.applyMultiplier(weapon, spread, Perks.modifyHipFireSpread);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            spread = modifier.modifyHipFireSpread(spread);
        }
        return spread;
    }

    public static double getModifiedProjectileSpeed(ItemStack weapon, double speed) {
        IGunModifier[] modifiers;
        speed = GunModifierHelper.applyMultiplier(weapon, speed, Perks.modifyProjectileSpeed);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            speed = modifier.modifyProjectileSpeed(speed);
        }
        return speed;
    }

    public static float getFireSoundVolume(ItemStack weapon) {
        IGunModifier[] modifiers;
        float volume = 1.0f;
        volume = GunModifierHelper.applyMultiplier(weapon, volume, Perks.modifyFireSoundVolume);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            volume = modifier.modifyFireSoundVolume(volume);
        }
        return MathHelper.func_76131_a((float)volume, (float)0.0f, (float)16.0f);
    }

    public static double getMuzzleFlashSize(ItemStack weapon, double size) {
        IGunModifier[] modifiers;
        size = GunModifierHelper.applyMultiplier(weapon, size, Perks.modifyMuzzleFlashSize);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            size = modifier.modifyMuzzleFlashSize(size);
        }
        return size;
    }

    public static float getKickReduction(ItemStack weapon) {
        IGunModifier[] modifiers;
        float kickReduction = 1.0f;
        kickReduction = GunModifierHelper.applyMultiplier(weapon, kickReduction, Perks.kickModifier);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            kickReduction *= MathHelper.func_76131_a((float)modifier.kickModifier(), (float)0.0f, (float)1.0f);
        }
        return 1.0f - kickReduction;
    }

    public static float getRecoilSmootheningTime(ItemStack weapon) {
        IGunModifier[] modifiers;
        float recoilTime = 1.0f;
        recoilTime = GunModifierHelper.applyMultiplier(weapon, recoilTime, Perks.modifyRecoilSmoothening);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            recoilTime *= MathHelper.func_76131_a((float)modifier.modifyRecoilSmoothening(), (float)1.0f, (float)2.0f);
        }
        return recoilTime;
    }

    public static float getRecoilModifier(ItemStack weapon) {
        IGunModifier[] modifiers;
        float recoilReduction = 1.0f;
        recoilReduction = GunModifierHelper.applyMultiplier(weapon, recoilReduction, Perks.recoilModifier);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            recoilReduction *= MathHelper.func_76131_a((float)modifier.recoilModifier(), (float)0.0f, (float)1.0f);
        }
        return 1.0f - recoilReduction;
    }

    public static float getHorizontalRecoilModifier(ItemStack weapon) {
        IGunModifier[] modifiers;
        float reduction = 1.0f;
        reduction = GunModifierHelper.applyMultiplier(weapon, reduction, Perks.horizontalRecoilModifier);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            reduction *= MathHelper.func_76131_a((float)modifier.horizontalRecoilModifier(), (float)0.0f, (float)1.0f);
        }
        return 1.0f - reduction;
    }

    public static boolean isSilencedFire(ItemStack weapon) {
        IGunModifier[] modifiers;
        for (int i = 0; i < SlotType.values().length; ++i) {
            CustomModifierData modifier = GunModifierHelper.getCustomModifier(weapon, SlotType.values()[i]);
            if (modifier == null || !modifier.getGeneral().isSilencedFire()) continue;
            return true;
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            if (!modifier.silencedFire()) continue;
            return true;
        }
        return false;
    }

    public static float getModifiedProjectileBlastDamage(ItemStack weapon, float damage) {
        IGunModifier[] modifiers;
        float finalDamage = damage;
        finalDamage = GunModifierHelper.applyMultiplier(weapon, finalDamage, Perks.modifyProjectileBlastDamage);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            finalDamage = modifier.modifyProjectileBlastDamage(finalDamage);
        }
        return finalDamage;
    }

    public static float getModifiedProjectileArmorIgnore(ItemStack weapon, float ignore) {
        IGunModifier[] modifiers;
        float finalIgnore = ignore;
        finalIgnore = GunModifierHelper.applyMultiplier(weapon, finalIgnore, Perks.modifyProjectileArmorIgnore);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            finalIgnore = modifier.modifyProjectileArmorIgnore(finalIgnore);
        }
        return finalIgnore;
    }

    public static float getModifiedProjectileHeadDamage(ItemStack weapon, float damage) {
        IGunModifier[] modifiers;
        float finalDamage = damage;
        finalDamage = GunModifierHelper.applyMultiplier(weapon, finalDamage, Perks.modifyProjectileHeadDamage);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            finalDamage = modifier.modifyProjectileHeadDamage(finalDamage);
        }
        return finalDamage;
    }

    public static double getModifiedFireSoundRadius(ItemStack weapon, double radius) {
        IGunModifier[] modifiers;
        double minRadius = radius;
        minRadius = GunModifierHelper.applyMultiplier(weapon, minRadius, Perks.modifyFireSoundRadius);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            double newRadius = modifier.modifyFireSoundRadius(radius);
            if (!(newRadius < minRadius)) continue;
            minRadius = newRadius;
        }
        return MathHelper.func_151237_a((double)minRadius, (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getAdditionalDamage(ItemStack weapon) {
        IGunModifier[] modifiers;
        float additionalDamage = 0.0f;
        additionalDamage = GunModifierHelper.applyAdditional(weapon, additionalDamage, Perks.additionalDamage);
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            ItemStack attachment = Gun.getAttachment(IAttachment.Type.values()[i], weapon);
            if (!attachment.func_77942_o()) continue;
            additionalDamage += Gun.getAdditionalDamage(attachment);
        }
        additionalDamage += Gun.getAdditionalDamage(weapon);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            additionalDamage += modifier.additionalDamage();
        }
        return additionalDamage;
    }

    public static float getAdditionalHeadshotDamage(ItemStack weapon) {
        IGunModifier[] modifiers;
        float additionalDamage = 0.0f;
        additionalDamage = GunModifierHelper.applyAdditional(weapon, additionalDamage, Perks.additionalHeadshotDamage);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            additionalDamage += modifier.additionalHeadshotDamage();
        }
        return additionalDamage;
    }

    public static int getAdditionalPierce(ItemStack weapon) {
        IGunModifier[] modifiers;
        int additionalPierce = 0;
        additionalPierce = GunModifierHelper.applyAdditional(weapon, additionalPierce, Perks.additionalPierce);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            additionalPierce += modifier.additionalPierce();
        }
        return additionalPierce;
    }

    public static float getModifiedProjectileDamage(ItemStack weapon, float damage) {
        IGunModifier[] modifiers;
        float finalDamage = damage;
        finalDamage = GunModifierHelper.applyMultiplier(weapon, finalDamage, Perks.modifyProjectileDamage);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            finalDamage = modifier.modifyProjectileDamage(finalDamage);
        }
        return finalDamage;
    }

    public static float getModifiedDamage(ItemStack weapon, Gun modifiedGun, float damage) {
        IGunModifier[] modifiersD1;
        float finalDamage = GunModifierHelper.applyMultiplier(weapon, damage, Perks.modifyProjectileDamage);
        for (IGunModifier modifier : modifiersD1 = GunModifierHelper.getModifiers(weapon)) {
            finalDamage = modifier.modifyProjectileDamage(finalDamage);
        }
        return finalDamage;
    }

    public static double getModifiedAimDownSightSpeed(ItemStack weapon, double speed) {
        IGunModifier[] modifiers;
        speed = GunModifierHelper.applyMultiplier(weapon, speed, Perks.modifyAimDownSightSpeed);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            speed = modifier.modifyAimDownSightSpeed(speed);
        }
        return MathHelper.func_151237_a((double)speed, (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getModifiedRate(ItemStack weapon, int rate) {
        IGunModifier[] modifiers;
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            rate = modifier.modifyFireRate(rate);
        }
        return MathHelper.func_76125_a((int)rate, (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(ItemStack weapon) {
        IGunModifier[] modifiers;
        float chance = 0.0f;
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            chance += modifier.criticalChance();
        }
        return MathHelper.func_76131_a((float)(chance += GunEnchantmentHelper.getPuncturingChance(weapon)), (float)0.0f, (float)1.0f);
    }

    public static float getAdditionalWeaponWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        float additionalWeight = GunModifierHelper.applyAdditional(weapon, 0.0f, Perks.additionalWeaponWeight);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            additionalWeight += modifier.additionalWeaponWeight();
        }
        return additionalWeight;
    }

    public static float getModifierOfWeaponWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        float modifierWeight = 0.0f;
        modifierWeight = GunModifierHelper.applyAdditional(weapon, modifierWeight, Perks.modifyWeaponWeight);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight += modifier.modifyWeaponWeight();
        }
        return modifierWeight;
    }

    public static int getAmmoCapacity(ItemStack weapon, Gun modifiedGun) {
        int capacity = modifiedGun.getReloads().isOpenBolt() ? modifiedGun.getReloads().getMaxAmmo() : modifiedGun.getReloads().getMaxAmmo() + 1;
        int level = GunModifierHelper.getAmmoCapacityWeight(weapon);
        if (level > -1 && level < modifiedGun.getReloads().getMaxAdditionalAmmoPerOC().length) {
            capacity += modifiedGun.getReloads().getMaxAdditionalAmmoPerOC()[level];
        } else if (level > -1) {
            capacity += capacity / 2 * level - 3;
        }
        return capacity;
    }

    public static int getAmmoCapacityWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        int modifierWeight = -1;
        modifierWeight = GunModifierHelper.applyAmmoAdditional(weapon, modifierWeight, Perks.additionalAmmunition);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight = Math.max(modifier.additionalAmmunition(), modifierWeight);
        }
        modifierWeight = Math.min(modifierWeight, 2);
        return modifierWeight;
    }

    public static float getAmmoModifyArmorIgnore(ItemStack weapon, Gun modifiedGun, float ignore) {
        float modifyIgnore = ignore;
        if (GunModifierHelper.getFmjWeight(weapon) > -1) {
            modifyIgnore *= (float)modifiedGun.getAmmoPlugEffect().getFmjModifyArmorIgnore()[GunModifierHelper.getFmjWeight(weapon)] / 100.0f;
        } else if (GunModifierHelper.getHeWeight(weapon) > -1) {
            modifyIgnore *= (float)modifiedGun.getAmmoPlugEffect().getHeModifyArmorIgnore()[GunModifierHelper.getHeWeight(weapon)] / 100.0f;
        } else if (GunModifierHelper.getHpWeight(weapon) > -1) {
            modifyIgnore *= (float)modifiedGun.getAmmoPlugEffect().getHpModifyArmorIgnore()[GunModifierHelper.getHpWeight(weapon)] / 100.0f;
        } else if (GunModifierHelper.getIWeight(weapon) > -1) {
            modifyIgnore *= (float)modifiedGun.getAmmoPlugEffect().getIModifyArmorIgnore()[GunModifierHelper.getIWeight(weapon)] / 100.0f;
        }
        return modifyIgnore;
    }

    public static float getAmmoModifyDamage(ItemStack weapon, Gun modifiedGun, float damage) {
        float modifyDamage = damage;
        if (GunModifierHelper.getFmjWeight(weapon) > -1) {
            modifyDamage *= (float)modifiedGun.getAmmoPlugEffect().getFmjModifyDamage()[GunModifierHelper.getFmjWeight(weapon)] / 100.0f;
        } else if (GunModifierHelper.getHeWeight(weapon) > -1) {
            modifyDamage *= (float)modifiedGun.getAmmoPlugEffect().getHeModifyDamage()[GunModifierHelper.getHeWeight(weapon)] / 100.0f;
        } else if (GunModifierHelper.getHpWeight(weapon) > -1) {
            modifyDamage *= (float)modifiedGun.getAmmoPlugEffect().getHpModifyDamage()[GunModifierHelper.getHpWeight(weapon)] / 100.0f;
        } else if (GunModifierHelper.getIWeight(weapon) > -1) {
            modifyDamage *= (float)modifiedGun.getAmmoPlugEffect().getIModifyDamage()[GunModifierHelper.getIWeight(weapon)] / 100.0f;
        }
        return modifyDamage;
    }

    public static double getAmmoModifySpeed(ItemStack weapon, Gun modifiedGun, double speed) {
        double modifySpeed = speed;
        if (GunModifierHelper.getFmjWeight(weapon) > -1) {
            modifySpeed *= (double)((float)modifiedGun.getAmmoPlugEffect().getFmjModifySpeed()[GunModifierHelper.getFmjWeight(weapon)] / 100.0f);
        } else if (GunModifierHelper.getHeWeight(weapon) > -1) {
            modifySpeed *= (double)((float)modifiedGun.getAmmoPlugEffect().getHeModifySpeed()[GunModifierHelper.getHeWeight(weapon)] / 100.0f);
        } else if (GunModifierHelper.getHpWeight(weapon) > -1) {
            modifySpeed *= (double)((float)modifiedGun.getAmmoPlugEffect().getHpModifySpeed()[GunModifierHelper.getHpWeight(weapon)] / 100.0f);
        } else if (GunModifierHelper.getIWeight(weapon) > -1) {
            modifySpeed *= (double)((float)modifiedGun.getAmmoPlugEffect().getIModifySpeed()[GunModifierHelper.getIWeight(weapon)] / 100.0f);
        }
        return modifySpeed;
    }

    public static int getFmjWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        int modifierWeight = -1;
        modifierWeight = GunModifierHelper.applyAmmoAdditional(weapon, modifierWeight, Perks.fmjAmmo);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight = Math.max(modifier.fmjAmmo(), modifierWeight);
        }
        modifierWeight = Math.min(modifierWeight, 2);
        return modifierWeight;
    }

    public static int getHeWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        int modifierWeight = -1;
        modifierWeight = GunModifierHelper.applyAmmoAdditional(weapon, modifierWeight, Perks.heAmmo);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight = Math.max(modifier.heAmmo(), modifierWeight);
        }
        modifierWeight = Math.min(modifierWeight, 2);
        return modifierWeight;
    }

    public static int getHpWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        int modifierWeight = -1;
        modifierWeight = GunModifierHelper.applyAmmoAdditional(weapon, modifierWeight, Perks.hpAmmo);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight = Math.max(modifier.hpAmmo(), modifierWeight);
        }
        modifierWeight = Math.min(modifierWeight, 2);
        return modifierWeight;
    }

    public static int getIWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        int modifierWeight = -1;
        modifierWeight = GunModifierHelper.applyAmmoAdditional(weapon, modifierWeight, Perks.iAmmo);
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight = Math.max(modifier.iAmmo(), modifierWeight);
        }
        modifierWeight = Math.min(modifierWeight, 2);
        return modifierWeight;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getAdditionalSkin(ItemStack weapon) {
        if (weapon.func_77973_b() instanceof TimelessGunItem) {
            CustomModifierData modifier;
            ItemStack stack = Gun.getAttachment(SlotType.GUN_SKIN, weapon);
            if (stack != null && (modifier = Attachment.getCustomModifier(stack)) != null) {
                return modifier.getSkin();
            }
            if (stack != null && stack.func_77973_b() instanceof GunSkinItem) {
                return ((GunSkinItem)stack.func_77973_b()).getProperties().getSkin();
            }
        }
        return null;
    }
}

