/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network;

import com.tac.guns.network.HandshakeHandler;
import com.tac.guns.network.HandshakeMessages;
import com.tac.guns.network.message.IMessage;
import com.tac.guns.network.message.MessageAim;
import com.tac.guns.network.message.MessageAnimationRun;
import com.tac.guns.network.message.MessageAnimationSound;
import com.tac.guns.network.message.MessageAttachments;
import com.tac.guns.network.message.MessageBlood;
import com.tac.guns.network.message.MessageBulletTrail;
import com.tac.guns.network.message.MessageColorBench;
import com.tac.guns.network.message.MessageCraft;
import com.tac.guns.network.message.MessageEmptyMag;
import com.tac.guns.network.message.MessageFireMode;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.network.message.MessageInspection;
import com.tac.guns.network.message.MessageLightChange;
import com.tac.guns.network.message.MessagePlayerShake;
import com.tac.guns.network.message.MessageProjectileHitBlock;
import com.tac.guns.network.message.MessageProjectileHitEntity;
import com.tac.guns.network.message.MessageReload;
import com.tac.guns.network.message.MessageRemoveProjectile;
import com.tac.guns.network.message.MessageSaveItemUpgradeBench;
import com.tac.guns.network.message.MessageShoot;
import com.tac.guns.network.message.MessageShooting;
import com.tac.guns.network.message.MessageStunGrenade;
import com.tac.guns.network.message.MessageUnload;
import com.tac.guns.network.message.MessageUpdateGunID;
import com.tac.guns.network.message.MessageUpdateGuns;
import com.tac.guns.network.message.MessageUpdateMoveInacc;
import com.tac.guns.network.message.MessageUpdatePlayerMovement;
import com.tac.guns.network.message.MessageUpgradeBenchApply;
import com.tac.guns.network.message.SGunLevelUp;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    public static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel handshakeChannel;
    private static SimpleChannel playChannel;
    private static int nextMessageId;

    public static void init() {
        handshakeChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("tac", "handshake")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        handshakeChannel.messageBuilder(HandshakeMessages.C2SAcknowledge.class, 99).loginIndex(HandshakeMessages.LoginIndexedMessage::getLoginIndex, HandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(HandshakeMessages.C2SAcknowledge::decode).encoder(HandshakeMessages.C2SAcknowledge::encode).consumer(FMLHandshakeHandler.indexFirst((handler, msg, s) -> HandshakeHandler.handleAcknowledge(msg, s))).add();
        handshakeChannel.messageBuilder(HandshakeMessages.S2CUpdateGuns.class, 1).loginIndex(HandshakeMessages.LoginIndexedMessage::getLoginIndex, HandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(HandshakeMessages.S2CUpdateGuns::decode).encoder(HandshakeMessages.S2CUpdateGuns::encode).consumer(FMLHandshakeHandler.biConsumerFor((handler, msg, supplier) -> HandshakeHandler.handleUpdateGuns(msg, supplier))).markAsLoginPacket().add();
        playChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("tac", "play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        PacketHandler.registerPlayMessage(MessageAim.class, MessageAim::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageReload.class, MessageReload::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageShoot.class, MessageShoot::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageSaveItemUpgradeBench.class, MessageSaveItemUpgradeBench::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageLightChange.class, MessageLightChange::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageUnload.class, MessageUnload::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageStunGrenade.class, MessageStunGrenade::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageCraft.class, MessageCraft::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageBulletTrail.class, MessageBulletTrail::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageAttachments.class, MessageAttachments::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageInspection.class, MessageInspection::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageColorBench.class, MessageColorBench::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageUpdateGuns.class, MessageUpdateGuns::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageBlood.class, MessageBlood::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageShooting.class, MessageShooting::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageGunSound.class, MessageGunSound::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageProjectileHitBlock.class, MessageProjectileHitBlock::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageProjectileHitEntity.class, MessageProjectileHitEntity::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageRemoveProjectile.class, MessageRemoveProjectile::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageFireMode.class, MessageFireMode::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageUpdateGunID.class, MessageUpdateGunID::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageUpgradeBenchApply.class, MessageUpgradeBenchApply::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageUpdateMoveInacc.class, MessageUpdateMoveInacc::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageEmptyMag.class, MessageEmptyMag::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessagePlayerShake.class, MessagePlayerShake::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageUpdatePlayerMovement.class, MessageUpdatePlayerMovement::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(MessageAnimationSound.class, MessageAnimationSound::new, LogicalSide.CLIENT);
        PacketHandler.registerPlayMessage(MessageAnimationRun.class, MessageAnimationRun::new, LogicalSide.SERVER);
        PacketHandler.registerPlayMessage(SGunLevelUp.class, SGunLevelUp::new, LogicalSide.CLIENT);
    }

    private static <T extends IMessage> void registerPlayMessage(Class<T> clazz, Supplier<T> messageSupplier, LogicalSide side) {
        playChannel.registerMessage(nextMessageId++, clazz, IMessage::encode, buffer -> {
            IMessage t = (IMessage)messageSupplier.get();
            t.decode((PacketBuffer)buffer);
            return t;
        }, (t, supplier) -> {
            if (((NetworkEvent.Context)supplier.get()).getDirection().getReceptionSide() != side) {
                throw new RuntimeException("Attempted to handle message " + clazz.getSimpleName() + " on the wrong logical side!");
            }
            t.handle((Supplier<NetworkEvent.Context>)supplier);
        });
    }

    public static SimpleChannel getHandshakeChannel() {
        return handshakeChannel;
    }

    public static SimpleChannel getPlayChannel() {
        return playChannel;
    }

    static {
        nextMessageId = 0;
    }
}

