/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item;

import com.tac.guns.entity.ThrowableGrenadeEntity;
import com.tac.guns.init.ModSounds;
import com.tac.guns.item.AmmoItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class GrenadeItem
extends AmmoItem {
    protected int maxCookTime;
    private float power;
    private float radius;
    private float speed;

    public GrenadeItem(Item.Properties properties, int maxCookTime, float power, float radius, float speed) {
        super(properties);
        this.maxCookTime = maxCookTime;
        this.power = power;
        this.radius = radius;
        this.speed = speed;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return this.maxCookTime;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!this.canCook()) {
            return;
        }
        int duration = this.func_77626_a(stack) - count;
        if (duration == 5) {
            player.field_70170_p.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)ModSounds.ITEM_GRENADE_PIN.get(), SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (this.canCook() && !worldIn.func_201670_d()) {
            if (!(entityLiving instanceof PlayerEntity) || !((PlayerEntity)entityLiving).func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ThrowableGrenadeEntity grenade = this.create(worldIn, entityLiving, 0);
            grenade.onDeath();
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int duration;
        if (!worldIn.func_201670_d() && (duration = this.func_77626_a(stack) - timeLeft) >= 5) {
            if (!(entityLiving instanceof PlayerEntity) || !((PlayerEntity)entityLiving).func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ThrowableGrenadeEntity grenade = this.create(worldIn, entityLiving, this.maxCookTime - duration);
            grenade.func_234612_a_((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, Math.min(1.0f, (float)duration / 20.0f) * this.speed, 1.5f);
            worldIn.func_217376_c((Entity)grenade);
            this.onThrown(worldIn, grenade);
        }
    }

    public ThrowableGrenadeEntity create(World world, LivingEntity entity, int timeLeft) {
        return null;
    }

    public boolean canCook() {
        return true;
    }

    protected void onThrown(World world, ThrowableGrenadeEntity entity) {
    }
}

