/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.extra_events;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.common.Gun;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.event.LevelUpEvent;
import com.tac.guns.init.ModSounds;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.M1GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.SGunLevelUp;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="tac", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TacEventListeners {
    private static boolean checked = true;
    private static boolean confirmed = false;
    private static VersionChecker.CheckResult status;

    @SubscribeEvent
    public static void InformPlayerOfUpdate(EntityJoinWorldEvent e) {
        try {
            if (!(e.getEntity() instanceof PlayerEntity)) {
                return;
            }
            if (checked && GunMod.modInfo != null) {
                status = VersionChecker.getResult((IModInfo)GunMod.modInfo);
                checked = false;
            }
            if (!(confirmed || TacEventListeners.status.status != VersionChecker.Status.OUTDATED && TacEventListeners.status.status != VersionChecker.Status.BETA_OUTDATED)) {
                ((PlayerEntity)e.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("updateCheck.tac", new Object[]{TacEventListeners.status.target, TacEventListeners.status.url}), false);
                confirmed = true;
            }
        }
        catch (Exception ev) {
            GunMod.LOGGER.log(Level.ERROR, ev.getMessage());
            return;
        }
        GunMod.LOGGER.log(Level.INFO, (Object)TacEventListeners.status.status);
    }

    @SubscribeEvent
    public static void onPartialLevel(LevelUpEvent.Post event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof TimelessGunItem) {
            int level = stack.func_77978_p().func_74762_e("level");
            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.75f, 1.0f);
            PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SGunLevelUp(stack, level));
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof M1GunItem)) {
            return;
        }
        CompoundNBT tag = heldItem.func_77978_p();
        if (tag != null && tag.func_74762_e("AmmoCount") == 1) {
            event.getPlayer().func_130014_f_().func_184133_a(player, player.func_233580_cy_(), (SoundEvent)ModSounds.M1_PING.get(), SoundCategory.MASTER, 3.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PlayerEntity entity = event.player;
            boolean shooting = (Boolean)SyncedPlayerData.instance().get(entity, ModSyncedDataKeys.SHOOTING);
            ItemStack heldItem = entity.func_184614_ca();
            if (!(heldItem.func_77973_b() instanceof GunItem)) {
                return;
            }
            if (entity.func_175149_v()) {
                return;
            }
            Gun gun = ((GunItem)heldItem.func_77973_b()).getGun();
            if (gun.getReloads().isHeat()) {
                if (!Gun.hasAmmo(entity, heldItem) && (!entity.func_184812_l_() && !((Boolean)Config.SERVER.gameplay.commonUnlimitedCurrentAmmo.get()).booleanValue() || entity.func_184812_l_() && !((Boolean)Config.SERVER.gameplay.creativeUnlimitedCurrentAmmo.get()).booleanValue())) {
                    shooting = false;
                }
                if (shooting) {
                    if (heldItem.func_77978_p() != null) {
                        if (gun.getReloads().isHeat() && heldItem.func_77978_p().func_74781_a("heatValue") != null) {
                            heldItem.func_77978_p().func_74768_a("heatValue", heldItem.func_77978_p().func_74762_e("heatValue") + 1);
                        }
                        if (heldItem.func_77978_p().func_74762_e("heatValue") >= gun.getReloads().getTickToHeat() && heldItem.func_77978_p().func_74781_a("overHeatLock") != null && !heldItem.func_77978_p().func_74767_n("overHeatLock")) {
                            heldItem.func_77978_p().func_74768_a("heatValue", heldItem.func_77978_p().func_74762_e("heatValue") + gun.getReloads().getTickOverHeat());
                            heldItem.func_77978_p().func_74757_a("overHeatLock", true);
                            entity.func_130014_f_().func_184133_a(entity, entity.func_233580_cy_(), (SoundEvent)ModSounds.OVERHEAT.get(), SoundCategory.PLAYERS, (float)((Double)Config.CLIENT.sounds.barrelVolume.get() * 1.0), 1.0f);
                        }
                    }
                } else if (heldItem.func_77973_b() instanceof TimelessGunItem && heldItem.func_77978_p() != null) {
                    if (gun.getReloads().isHeat() && heldItem.func_77978_p().func_74781_a("heatValue") != null) {
                        heldItem.func_77978_p().func_74768_a("heatValue", Math.max(heldItem.func_77978_p().func_74762_e("heatValue") - Math.max(1, gun.getReloads().getHeatRecover()), 0));
                    }
                    if (heldItem.func_77978_p().func_74781_a("overHeatLock") != null && heldItem.func_77978_p().func_74762_e("heatValue") <= 0 && heldItem.func_77978_p().func_74767_n("overHeatLock")) {
                        heldItem.func_77978_p().func_74757_a("overHeatLock", false);
                    }
                }
            }
        }
    }
}

