/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.network;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.handler.MovementAdaptationsHandler;
import com.tac.guns.client.screen.UpgradeBenchScreen;
import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.common.ProjectileManager;
import com.tac.guns.common.ReloadTracker;
import com.tac.guns.common.SpreadTracker;
import com.tac.guns.common.WeaponType;
import com.tac.guns.common.container.AttachmentContainer;
import com.tac.guns.common.container.ColorBenchContainer;
import com.tac.guns.common.container.DyeContainer;
import com.tac.guns.common.container.InspectionContainer;
import com.tac.guns.common.container.UpgradeBenchContainer;
import com.tac.guns.common.container.WorkbenchContainer;
import com.tac.guns.crafting.WorkbenchRecipe;
import com.tac.guns.crafting.WorkbenchRecipes;
import com.tac.guns.entity.ProjectileEntity;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.init.ModBlocks;
import com.tac.guns.init.ModEnchantments;
import com.tac.guns.interfaces.IProjectileFactory;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.IColored;
import com.tac.guns.item.IrDeviceItem;
import com.tac.guns.item.ScopeItem;
import com.tac.guns.item.SideRailItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageBulletTrail;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.network.message.MessageSaveItemUpgradeBench;
import com.tac.guns.network.message.MessageShoot;
import com.tac.guns.network.message.MessageUpgradeBenchApply;
import com.tac.guns.tileentity.FlashLightSource;
import com.tac.guns.tileentity.UpgradeBenchTileEntity;
import com.tac.guns.tileentity.WorkbenchTileEntity;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.InventoryUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlayHandler {
    public static final Logger LOGGER = LogManager.getLogger((String)"tac");
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> entity.func_184176_by() == SoundCategory.HOSTILE && !((List)Config.SERVER.aggroMobs.exemptEntities.get()).contains(entity.func_200600_R().getRegistryName().toString());
    private static final UUID speedUptId = UUID.fromString("923e4567-e89b-42d3-a456-556642440000");

    public static void handleShoot(MessageShoot message, ServerPlayerEntity player, float randP, float randY) {
        if (!player.func_175149_v()) {
            World world = player.field_70170_p;
            ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
            if (heldItem.func_77973_b() instanceof GunItem && (Gun.hasAmmo((PlayerEntity)player, heldItem) || player.func_184812_l_() && ((Boolean)Config.SERVER.gameplay.creativeUnlimitedCurrentAmmo.get()).booleanValue() || !player.func_184812_l_() && ((Boolean)Config.SERVER.gameplay.commonUnlimitedCurrentAmmo.get()).booleanValue())) {
                GunItem item = (GunItem)heldItem.func_77973_b();
                Gun modifiedGun = item.getModifiedGun(heldItem);
                if (modifiedGun != null) {
                    int level;
                    CompoundNBT tag;
                    boolean silenced;
                    ResourceLocation fireSound;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((PlayerEntity)player, heldItem))) {
                        return;
                    }
                    player.field_70177_z = message.getRotationYaw();
                    player.field_70125_A = message.getRotationPitch();
                    if (!modifiedGun.getGeneral().isAlwaysSpread() && modifiedGun.getGeneral().getSpread() > 0.0f) {
                        SpreadTracker.get((PlayerEntity)player).update((PlayerEntity)player, item);
                    }
                    int count = modifiedGun.getDisplay().getWeaponType() == WeaponType.SG && (modifiedGun.getProjectile().isHasBlastDamage() || GunModifierHelper.getHeWeight(heldItem) > -1) ? 1 : modifiedGun.getGeneral().getProjectileAmount();
                    Gun.Projectile projectileProps = modifiedGun.getProjectile();
                    ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                    for (int i = 0; i < count; ++i) {
                        IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
                        ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item, modifiedGun, randP, randY);
                        projectileEntity.setWeapon(heldItem);
                        projectileEntity.setAdditionalDamage(GunModifierHelper.getAdditionalDamage(heldItem));
                        world.func_217376_c((Entity)projectileEntity);
                        spawnedProjectiles[i] = projectileEntity;
                        projectileEntity.func_70071_h_();
                    }
                    if (!projectileProps.isVisible()) {
                        MessageBulletTrail messageBulletTrail = new MessageBulletTrail(spawnedProjectiles, projectileProps, player.func_145782_y(), projectileProps.getSize());
                        PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ((Double)Config.COMMON.network.projectileTrackingRange.get()).doubleValue(), player.field_70170_p.func_234923_W_())), (Object)messageBulletTrail);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((PlayerEntity)player, heldItem));
                    if (((Boolean)Config.SERVER.aggroMobs.enabled.get()).booleanValue()) {
                        double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.aggroMobs.range.get());
                        double x = player.func_226277_ct_();
                        double y = player.func_226278_cu_() + 0.5;
                        double z = player.func_226281_cx_();
                        AxisAlignedBB box = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
                        radius *= radius;
                        for (LivingEntity entity : world.func_175647_a(LivingEntity.class, box, HOSTILE_ENTITIES)) {
                            double dz;
                            double dy;
                            double dx = x - entity.func_226277_ct_();
                            if (!(dx * dx + (dy = y - entity.func_226278_cu_()) * dy + (dz = z - entity.func_226281_cx_()) * dz <= radius)) continue;
                            entity.func_70604_c((LivingEntity)((Boolean)Config.SERVER.aggroMobs.angerHostileMobs.get() != false ? player : entity));
                        }
                    }
                    ResourceLocation resourceLocation = fireSound = (silenced = GunModifierHelper.isSilencedFire(heldItem)) ? modifiedGun.getSounds().getSilencedFire() : modifiedGun.getSounds().getFire();
                    if (fireSound != null) {
                        double posX = player.func_226277_ct_();
                        double posY = player.func_226278_cu_() + (double)player.func_70047_e();
                        double posZ = player.func_226281_cx_();
                        float volume = GunModifierHelper.getFireSoundVolume(heldItem);
                        float pitch = 0.9f + world.field_73012_v.nextFloat() * 0.125f;
                        double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                        boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
                        MessageGunSound messageSound = new MessageGunSound(fireSound, SoundCategory.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.func_145782_y(), muzzle, false);
                        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(posX, posY, posZ, radius, player.field_70170_p.func_234923_W_());
                        PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)messageSound);
                    }
                    if (!((player.func_184812_l_() || ((Boolean)Config.SERVER.gameplay.commonUnlimitedCurrentAmmo.get()).booleanValue()) && (!player.func_184812_l_() || ((Boolean)Config.SERVER.gameplay.creativeUnlimitedCurrentAmmo.get()).booleanValue()) || (tag = heldItem.func_196082_o()).func_74767_n("IgnoreAmmo") || (level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.field_70170_p.field_73012_v.nextInt(9 - MathHelper.func_76125_a((int)(level * 3), (int)3, (int)6)) == 0)) {
                        if (modifiedGun.getReloads().isNoMag()) {
                            ReloadTracker.decreaseReserveAmmo(Gun.findAmmo((PlayerEntity)player, modifiedGun.getProjectile().getItem()), (PlayerEntity)player, 1);
                        } else {
                            tag.func_74768_a("AmmoCount", Math.max(0, tag.func_74762_e("AmmoCount") - 1));
                        }
                    }
                }
            } else {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.8f);
            }
        }
    }

    public static void handleCraft(ServerPlayerEntity player, ResourceLocation id, BlockPos pos) {
        WorkbenchContainer workbench;
        World world = player.field_70170_p;
        if (player.field_71070_bA instanceof WorkbenchContainer && (workbench = (WorkbenchContainer)player.field_71070_bA).getPos().equals((Object)pos)) {
            WorkbenchRecipe recipe = WorkbenchRecipes.getRecipeById(world, id);
            if (recipe == null) {
                return;
            }
            ImmutableList<Pair<Ingredient, Integer>> materials = recipe.getMaterials();
            if (materials != null) {
                Pair stack2;
                for (Pair stack2 : materials) {
                    if (InventoryUtil.hasIngredient((PlayerEntity)player, (Pair<Ingredient, Integer>)stack2)) continue;
                    return;
                }
                for (Pair stack2 : materials) {
                    if (InventoryUtil.removeItemStackFromIngredient((PlayerEntity)player, (Pair<Ingredient, Integer>)stack2)) continue;
                    return;
                }
                WorkbenchTileEntity workbenchTileEntity = workbench.getWorkbench();
                stack2 = recipe.getItem();
                ItemStack dyeStack = (ItemStack)workbenchTileEntity.getInventory().get(0);
                if (dyeStack.func_77973_b() instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)dyeStack.func_77973_b();
                    int color = dyeItem.func_195962_g().getColorValue();
                    if (stack2.func_77973_b() instanceof IColored && ((IColored)stack2.func_77973_b()).canColor((ItemStack)stack2)) {
                        IColored colored = (IColored)stack2.func_77973_b();
                        colored.setColor((ItemStack)stack2, color);
                        workbenchTileEntity.getInventory().set(0, (Object)ItemStack.field_190927_a);
                    }
                }
                if (stack2.func_77973_b() instanceof TimelessGunItem) {
                    if (stack2.func_77978_p() == null) {
                        stack2.func_196082_o();
                    }
                    GunItem gunItem = (GunItem)stack2.func_77973_b();
                    Gun gun = gunItem.getModifiedGun((ItemStack)stack2);
                    int[] gunItemFireModes = stack2.func_77978_p().func_74759_k("supportedFireModes");
                    if (ArrayUtils.isEmpty((int[])gunItemFireModes)) {
                        gunItemFireModes = gun.getGeneral().getRateSelector();
                        stack2.func_77978_p().func_74783_a("supportedFireModes", gunItemFireModes);
                    } else if (!Arrays.equals(gunItemFireModes, gun.getGeneral().getRateSelector())) {
                        stack2.func_77978_p().func_74783_a("supportedFireModes", gun.getGeneral().getRateSelector());
                    }
                }
                InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 1.125), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)stack2);
            }
        }
    }

    public static void handleUnload(ServerPlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof GunItem) {
            if (((GunItem)stack.func_77973_b()).getModifiedGun(stack).getReloads().isNoMag()) {
                return;
            }
            CompoundNBT tag = stack.func_77978_p();
            GunItem gunItem = (GunItem)stack.func_77973_b();
            Gun gun = gunItem.getModifiedGun(stack);
            if (tag != null && tag.func_150297_b("AmmoCount", 3)) {
                int count = tag.func_74762_e("AmmoCount");
                tag.func_74768_a("AmmoCount", 0);
                ResourceLocation id = gun.getProjectile().getItem();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null) {
                    return;
                }
                int maxStackSize = item.func_77639_j();
                int stacks = count / maxStackSize;
                for (int i = 0; i < stacks; ++i) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((IItemProvider)item, maxStackSize));
                }
                int remaining = count % maxStackSize;
                if (remaining > 0) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((IItemProvider)item, remaining));
                }
            }
            ResourceLocation reloadSound = gun.getSounds().getCock();
            ReloadTracker.playReloadSound((PlayerEntity)player, reloadSound);
        }
    }

    private static void spawnAmmo(ServerPlayerEntity player, ItemStack stack) {
        player.field_71071_by.func_70441_a(stack);
        if (stack.func_190916_E() > 0) {
            player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack.func_77946_l()));
        }
    }

    public static void handleAttachments(ServerPlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (ITextComponent)new TranslationTextComponent("container.tac.attachments")));
        } else if (heldItem.func_77973_b() instanceof ScopeItem || heldItem.func_77973_b() instanceof SideRailItem || heldItem.func_77973_b() instanceof IrDeviceItem) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player1) -> new DyeContainer(windowId, playerInventory, heldItem), (ITextComponent)new TranslationTextComponent("container.tac.attachments")));
        }
    }

    public static void handleColorbenchGui(ServerPlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem || heldItem.func_77973_b() instanceof ScopeItem) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player1) -> new ColorBenchContainer(windowId, playerInventory), (ITextComponent)new TranslationTextComponent("container.tac.color_bench")));
        }
    }

    public static void handleInspection(ServerPlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player1) -> new InspectionContainer(windowId, playerInventory, heldItem), (ITextComponent)new TranslationTextComponent("container.tac.inspection")));
        }
    }

    public static void handleFireMode(ServerPlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        try {
            if (heldItem.func_77973_b() instanceof GunItem) {
                if (heldItem.func_77978_p() == null) {
                    heldItem.func_196082_o();
                }
                GunItem gunItem = (GunItem)heldItem.func_77973_b();
                Gun gun = gunItem.getModifiedGun(heldItem.getStack());
                int[] gunItemFireModes = heldItem.func_77978_p().func_74759_k("supportedFireModes");
                if (ArrayUtils.isEmpty((int[])gunItemFireModes)) {
                    gunItemFireModes = gun.getGeneral().getRateSelector();
                    heldItem.func_77978_p().func_74783_a("supportedFireModes", gunItemFireModes);
                    heldItem.func_77978_p().func_74768_a("CurrentFireMode", gunItemFireModes[0]);
                } else if (!Arrays.equals(gunItemFireModes, gun.getGeneral().getRateSelector())) {
                    heldItem.func_77978_p().func_74783_a("supportedFireModes", gun.getGeneral().getRateSelector());
                    if (!heldItem.func_77978_p().func_74764_b("CurrentFireMode")) {
                        heldItem.func_77978_p().func_74768_a("CurrentFireMode", gunItemFireModes[0]);
                    }
                }
                int toCheck = ArrayUtils.indexOf((int[])gunItemFireModes, (int)heldItem.func_77978_p().func_74762_e("CurrentFireMode")) + 1;
                ServerPlayHandler.CurrentFireMode(heldItem, gunItemFireModes, toCheck);
                if (!((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue() && heldItem.func_77978_p().func_74762_e("CurrentFireMode") == 0 && gunItemFireModes.length > 1) {
                    toCheck = ArrayUtils.indexOf((int[])gunItemFireModes, (int)heldItem.func_77978_p().func_74762_e("CurrentFireMode")) + 1;
                    ServerPlayHandler.CurrentFireMode(heldItem, gunItemFireModes, toCheck);
                } else if (!((Boolean)Config.COMMON.gameplay.safetyExistence.get()).booleanValue() && heldItem.func_77978_p().func_74762_e("CurrentFireMode") == 0) {
                    heldItem.func_77978_p().func_82580_o("CurrentFireMode");
                    heldItem.func_77978_p().func_74768_a("CurrentFireMode", gunItemFireModes[0]);
                }
                ResourceLocation fireModeSound = gun.getSounds().getCock();
                if (fireModeSound != null && player.func_70089_S()) {
                    MessageGunSound messageSound = new MessageGunSound(fireModeSound, SoundCategory.PLAYERS, (float)player.func_226277_ct_(), (float)(player.func_226278_cu_() + 1.0), (float)player.func_226281_cx_(), 1.0f, 1.0f, player.func_145782_y(), false, false);
                    PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)messageSound);
                }
            }
        }
        catch (Exception e) {
            GunMod.LOGGER.log(Level.ERROR, "Fire Mode check did not function properly");
        }
    }

    private static void CurrentFireMode(ItemStack heldItem, int[] gunItemFireModes, int toCheck) {
        if (toCheck > heldItem.func_77978_p().func_74759_k("supportedFireModes").length - 1) {
            heldItem.func_77978_p().func_82580_o("CurrentFireMode");
            heldItem.func_77978_p().func_74768_a("CurrentFireMode", gunItemFireModes[0]);
        } else {
            heldItem.func_77978_p().func_82580_o("CurrentFireMode");
            heldItem.func_77978_p().func_74768_a("CurrentFireMode", gunItemFireModes[toCheck]);
        }
    }

    public static void EmptyMag(ServerPlayerEntity player) {
        GunItem gunItem;
        Gun gun;
        ResourceLocation fireModeSound;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem && (fireModeSound = (gun = (gunItem = (GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem.getStack())).getSounds().getCock()) != null && player.func_70089_S()) {
            MessageGunSound messageSound = new MessageGunSound(fireModeSound, SoundCategory.PLAYERS, (float)player.func_226277_ct_(), (float)(player.func_226278_cu_() + 1.0), (float)player.func_226281_cx_(), 1.2f, 0.75f, player.func_145782_y(), false, false);
            PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)messageSound);
        }
    }

    public static void handleFlashLight(ServerPlayerEntity player, int[] lookingRange) {
        if (player.func_184614_ca().func_77973_b() instanceof GunItem && Gun.getAttachment(IAttachment.Type.SIDE_RAIL, player.func_184614_ca()) != null) {
            World world = player.field_70170_p;
            TileEntity tile = null;
            for (int itor : lookingRange) {
                int x = ServerPlayHandler.lookingAt((PlayerEntity)player, itor).func_177958_n();
                int y = ServerPlayHandler.lookingAt((PlayerEntity)player, itor).func_177956_o();
                int z = ServerPlayHandler.lookingAt((PlayerEntity)player, itor).func_177952_p();
                boolean createLight = false;
                for (int i = 0; i < 5; ++i) {
                    tile = world.func_175625_s(new BlockPos(x, y, z));
                    if (tile instanceof FlashLightSource) {
                        createLight = true;
                        break;
                    }
                    if (!world.func_175623_d(new BlockPos(x, y, z))) {
                        int pX = (int)player.func_213303_ch().func_82615_a();
                        int pY = (int)player.func_213303_ch().func_82617_b();
                        int pZ = (int)player.func_213303_ch().func_82616_c();
                        if (pX > x) {
                            ++x;
                        } else if (pX < x) {
                            --x;
                        }
                        if (pY > y) {
                            ++y;
                        } else if (pY < y) {
                            --y;
                        }
                        if (pZ > z) {
                            ++z;
                            continue;
                        }
                        if (pZ >= z) continue;
                        --z;
                        continue;
                    }
                    if (!world.func_175623_d(new BlockPos(x, y, z))) continue;
                    createLight = true;
                    break;
                }
                if (!createLight) continue;
                tile = world.func_175625_s(new BlockPos(x, y, z));
                if (tile instanceof FlashLightSource) {
                    FlashLightSource.ticks = 0;
                } else if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.FLASHLIGHT_BLOCK.get()) {
                    world.func_180501_a(new BlockPos(x, y, z), ((Block)ModBlocks.FLASHLIGHT_BLOCK.get()).func_176223_P(), 3);
                }
                world.func_180501_a(new BlockPos(x, y, z), ((Block)ModBlocks.FLASHLIGHT_BLOCK.get()).func_176223_P(), 3);
            }
        }
    }

    protected static BlockPos lookingAt(PlayerEntity player, int rangeL) {
        return ((BlockRayTraceResult)player.func_213324_a((double)rangeL, 0.0f, false)).func_216350_a();
    }

    protected static RayTraceResult lookingAtEntity(PlayerEntity player, int rangeL) {
        return player.func_213324_a((double)rangeL, 0.0f, false);
    }

    private static void changeGunSpeedMod(ServerPlayerEntity entity, double modifier) {
        AttributeModifier speedModifier = new AttributeModifier(speedUptId, "GunSpeedMod", modifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ModifiableAttributeInstance attributeInstance = entity.func_110148_a(Attributes.field_233821_d_);
        if (attributeInstance.func_111127_a(speedUptId) != null) {
            attributeInstance.func_111124_b(speedModifier);
        }
        attributeInstance.func_233769_c_(speedModifier);
    }

    private static void removeGunSpeedMod(ServerPlayerEntity entity) {
        AttributeModifier speedModifier = new AttributeModifier(speedUptId, "GunSpeedMod", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ModifiableAttributeInstance attributeInstance = entity.func_110148_a(Attributes.field_233821_d_);
        if (attributeInstance.func_111127_a(speedUptId) != null) {
            attributeInstance.func_111124_b(speedModifier);
        }
    }

    public static void handleMovementUpdate(ServerPlayerEntity player, boolean handle) {
        if (player == null) {
            return;
        }
        if (player.func_175149_v()) {
            return;
        }
        if (!player.func_70089_S()) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (player.func_110148_a(Attributes.field_233821_d_) != null && MovementAdaptationsHandler.get().isReadyToReset()) {
            ServerPlayHandler.removeGunSpeedMod(player);
            MovementAdaptationsHandler.get().setReadyToReset(false);
            MovementAdaptationsHandler.get().setReadyToUpdate(true);
        }
        player.func_71016_p();
        if (!(heldItem.func_77973_b() instanceof TimelessGunItem)) {
            return;
        }
        Gun gun = ((TimelessGunItem)heldItem.func_77973_b()).getGun();
        if (MovementAdaptationsHandler.get().isReadyToUpdate() || MovementAdaptationsHandler.get().getPreviousWeight() != gun.getGeneral().getWeightKilo()) {
            float speed = ServerPlayHandler.calceldGunWeightSpeed(gun, heldItem);
            speed = player.func_70051_ag() && speed > 0.094f ? Math.max(Math.min(speed, 0.12f), 0.075f) : (player.func_70051_ag() ? Math.max(Math.min(speed, 0.12f), 0.075f) * 0.955f : Math.max(Math.min(speed, 0.1f), 0.075f));
            ServerPlayHandler.changeGunSpeedMod(player, -((0.1 - (double)speed) * 10.0));
            MovementAdaptationsHandler.get().setReadyToReset(true);
            MovementAdaptationsHandler.get().setReadyToUpdate(false);
            MovementAdaptationsHandler.get().setSpeed(speed);
        } else {
            MovementAdaptationsHandler.get().setSpeed((float)Objects.requireNonNull(player.func_110148_a(Attributes.field_233821_d_)).func_111126_e());
        }
        player.func_71016_p();
        MovementAdaptationsHandler.get().setPreviousWeight(gun.getGeneral().getWeightKilo());
    }

    public static float calceldGunWeightSpeed(Gun gun, ItemStack gunStack) {
        return 0.1f / (1.0f + (gun.getGeneral().getWeightKilo() * (1.0f + GunModifierHelper.getModifierOfWeaponWeight(gunStack)) + GunModifierHelper.getAdditionalWeaponWeight(gunStack) - GunEnchantmentHelper.getWeightModifier(gunStack)) / 2.0f * 0.0275f);
    }

    public static void handleGunID(ServerPlayerEntity player, boolean regenerate) {
        if (!player.func_70089_S()) {
            return;
        }
        if (NetworkGunManager.get() != null && NetworkGunManager.get().StackIds != null && player.func_184614_ca().func_77973_b() instanceof TimelessGunItem && player.func_184614_ca().func_77978_p() != null) {
            if (regenerate || !player.func_184614_ca().func_77978_p().func_74764_b("ID")) {
                UUID id;
                do {
                    LOGGER.log(Level.INFO, "NEW UUID GEN FOR TAC GUN");
                } while (!NetworkGunManager.get().Ids.add(id = UUID.randomUUID()));
                player.func_184614_ca().func_77978_p().func_186854_a("ID", id);
                NetworkGunManager.get().StackIds.put(id, player.func_184614_ca());
            }
            ServerPlayHandler.initLevelTracking(player.func_184614_ca(), player);
            if (((TimelessGunItem)player.func_184614_ca().func_77973_b()).getGun().getReloads().isHeat()) {
                ServerPlayHandler.initHeatTracking(player.func_184614_ca(), player);
            }
        }
    }

    private static void initLevelTracking(ItemStack gunStack, ServerPlayerEntity player) {
        if (gunStack.func_77978_p().func_74781_a("level") == null) {
            if (((Boolean)Config.SERVER.gameplay.lockGunLevel.get()).booleanValue()) {
                gunStack.func_77978_p().func_74768_a("level", ((Integer)Config.SERVER.gameplay.lockLevelOfGun.get()).intValue());
            } else {
                gunStack.func_77978_p().func_74768_a("level", 1);
            }
        }
        if (gunStack.func_77978_p().func_74781_a("levelDmg") == null) {
            gunStack.func_77978_p().func_74776_a("levelDmg", 0.0f);
        }
        if (gunStack.func_77978_p().func_74781_a("levelPlayer") == null) {
            gunStack.func_77978_p().func_186854_a("levelPlayer", player.func_110124_au());
        }
        if (gunStack.func_77978_p().func_74781_a("levelLock") == null) {
            gunStack.func_77978_p().func_74757_a("levelLock", false);
        }
        if (gunStack.func_77978_p().func_74781_a("levelPlayerID") == null) {
            gunStack.func_77978_p().func_74778_a("levelPlayerID", player.func_145748_c_().getString());
        }
    }

    private static void initHeatTracking(ItemStack gunStack, ServerPlayerEntity player) {
        if (gunStack.func_77978_p().func_74781_a("heatValue") == null) {
            gunStack.func_77978_p().func_74768_a("heatValue", 0);
        }
        if (gunStack.func_77978_p().func_74781_a("overHeatLock") == null) {
            gunStack.func_77978_p().func_74757_a("overHeatLock", false);
        }
    }

    public static void handleUpgradeBenchItem(MessageSaveItemUpgradeBench message, ServerPlayerEntity player) {
        if (!player.func_175149_v()) {
            World world = player.field_70170_p;
            ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
            TileEntity tileEntity = world.func_175625_s(message.getPos());
            if (player.func_213453_ef()) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
                return;
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.8f);
            if (tileEntity != null) {
                if (!(((UpgradeBenchTileEntity)tileEntity).func_70301_a(0).func_77973_b() instanceof GunItem) && heldItem.func_77973_b() instanceof GunItem) {
                    ((UpgradeBenchTileEntity)tileEntity).func_70299_a(0, heldItem);
                    player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_190931_a));
                    NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
                    player.func_71053_j();
                } else {
                    player.field_71071_by.func_70441_a(((UpgradeBenchTileEntity)tileEntity).func_70301_a(0));
                    ((UpgradeBenchTileEntity)tileEntity).func_70299_a(0, ItemStack.field_190927_a);
                    NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
                    player.func_71053_j();
                }
            }
        }
    }

    public static void handleUpgradeBenchApply(MessageUpgradeBenchApply message, ServerPlayerEntity player) {
        if (player.field_71070_bA instanceof UpgradeBenchContainer) {
            UpgradeBenchContainer workbench = (UpgradeBenchContainer)player.field_71070_bA;
            UpgradeBenchScreen.RequirementItem req = GunEnchantmentHelper.upgradeableEnchs.get(message.reqKey);
            if (workbench.getPos().equals((Object)message.pos)) {
                ItemStack toUpdate = (ItemStack)workbench.getBench().getInventory().get(0);
                int currLevel = EnchantmentHelper.func_77506_a((Enchantment)req.enchantment, (ItemStack)toUpdate);
                if (toUpdate.func_77978_p() == null) {
                    return;
                }
                int currWeaponLevel = toUpdate.func_77978_p().func_74762_e("level");
                TimelessGunItem gunItem = (TimelessGunItem)toUpdate.func_77973_b();
                if (workbench.getBench().func_70301_a(1).func_190916_E() >= req.getModuleCount()[currLevel] && currWeaponLevel >= req.getLevelReq()[currLevel] && gunItem.getGun().getGeneral().getUpgradeBenchMaxUses() > toUpdate.func_77978_p().func_74762_e("upgradeBenchUses")) {
                    if (currLevel > 0) {
                        Map listNBT = EnchantmentHelper.func_226652_a_((ListNBT)toUpdate.func_77986_q());
                        listNBT.replace(req.enchantment, currLevel + 1);
                        EnchantmentHelper.func_82782_a((Map)listNBT, (ItemStack)toUpdate);
                    } else {
                        toUpdate.func_77966_a(req.enchantment, 1);
                    }
                    workbench.getBench().func_70301_a(1).func_190920_e(workbench.getBench().func_70301_a(1).func_190916_E() - req.getModuleCount()[currLevel]);
                    toUpdate.func_77978_p().func_74768_a("upgradeBenchUses", toUpdate.func_77978_p().func_74762_e("upgradeBenchUses") + 1);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("Cannot apply enchants anymore"), true);
                }
            }
        }
    }
}

