/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.attachments;

import com.tac.guns.common.attachments.CustomModifierData;
import com.tac.guns.common.attachments.perk.BooleanPerk;
import com.tac.guns.common.attachments.perk.DoublePerk;
import com.tac.guns.common.attachments.perk.FloatPerk;
import com.tac.guns.common.attachments.perk.IntPerk;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class PerkTipsBuilder {
    List<ITextComponent> positivePerks = new ArrayList<ITextComponent>();
    List<ITextComponent> negativePerks = new ArrayList<ITextComponent>();
    CustomModifierData data;

    public PerkTipsBuilder(CustomModifierData data) {
        this.data = data;
    }

    public PerkTipsBuilder add(IntPerk perk) {
        int value = (Integer)perk.getValue(this.data);
        if (perk.isHarmful()) {
            if ((float)value < 0.0f) {
                this.positivePerks.add(perk.getPositive(this.data));
            } else if ((float)value > 0.0f) {
                this.negativePerks.add(perk.getNegative(this.data));
            }
        } else if ((float)value > 0.0f) {
            this.positivePerks.add(perk.getPositive(this.data));
        } else if ((float)value < 0.0f) {
            this.negativePerks.add(perk.getNegative(this.data));
        }
        return this;
    }

    public PerkTipsBuilder add(FloatPerk perk) {
        float value = ((Float)perk.getValue(this.data)).floatValue();
        if (perk.isHarmful()) {
            if (value < 0.0f) {
                this.positivePerks.add(perk.getPositive(this.data));
            } else if (value > 0.0f) {
                this.negativePerks.add(perk.getNegative(this.data));
            }
        } else if (value > 0.0f) {
            this.positivePerks.add(perk.getPositive(this.data));
        } else if (value < 0.0f) {
            this.negativePerks.add(perk.getNegative(this.data));
        }
        return this;
    }

    public PerkTipsBuilder add(DoublePerk perk) {
        double value = (Double)perk.getValue(this.data);
        if (perk.isHarmful()) {
            if (value < 0.0) {
                this.positivePerks.add(perk.getPositive(this.data));
            } else if (value > 0.0) {
                this.negativePerks.add(perk.getNegative(this.data));
            }
        } else if (value > 0.0) {
            this.positivePerks.add(perk.getPositive(this.data));
        } else if (value < 0.0) {
            this.negativePerks.add(perk.getNegative(this.data));
        }
        return this;
    }

    public PerkTipsBuilder addPercentage(FloatPerk perk) {
        double value = ((Float)perk.getValue(this.data)).floatValue();
        if (perk.isHarmful()) {
            if (value < 1.0) {
                this.positivePerks.add(perk.getPositive(this.data));
            } else if (value > 1.0) {
                this.negativePerks.add(perk.getNegative(this.data));
            }
        } else if (value > 1.0) {
            this.positivePerks.add(perk.getPositive(this.data));
        } else if (value < 1.0) {
            this.negativePerks.add(perk.getNegative(this.data));
        }
        return this;
    }

    public PerkTipsBuilder addPercentage(DoublePerk perk) {
        double value = (Double)perk.getValue(this.data);
        if (perk.isHarmful()) {
            if (value < 1.0) {
                this.positivePerks.add(perk.getPositive(this.data));
            } else if (value > 1.0) {
                this.negativePerks.add(perk.getNegative(this.data));
            }
        } else if (value > 1.0) {
            this.positivePerks.add(perk.getPositive(this.data));
        } else if (value < 1.0) {
            this.negativePerks.add(perk.getNegative(this.data));
        }
        return this;
    }

    public PerkTipsBuilder add(BooleanPerk perk) {
        if (((Boolean)perk.getValue(this.data)).booleanValue()) {
            this.positivePerks.add(perk.getText());
        }
        return this;
    }

    public List<ITextComponent> build() {
        this.positivePerks.addAll(this.negativePerks);
        return this.positivePerks;
    }
}

