/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.attachments;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tac.guns.GunMod;
import com.tac.guns.annotation.Validator;
import com.tac.guns.common.JsonDeserializers;
import com.tac.guns.common.attachments.CustomModifierData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

@Mod.EventBusSubscriber(modid="tac")
public class NetworkModifierManager
extends ReloadListener<Map<ResourceLocation, CustomModifierData>> {
    private static final Gson GSON_INSTANCE = (Gson)Util.func_199748_a(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        return builder.create();
    });
    private static NetworkModifierManager instance;
    private static Map<ResourceLocation, CustomModifierData> infoMap;
    private static Map<ResourceLocation, CustomModifierData> clientInfoMap;
    public static boolean isTagLoaded;
    public static boolean isModifiers;

    public static NetworkModifierManager getInstance() {
        return instance;
    }

    public static CustomModifierData getCustomModifier(ResourceLocation location) {
        if (infoMap != null && location != null) {
            return infoMap.get(location);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static CustomModifierData getLocalCustomModifier(ResourceLocation location) {
        if (clientInfoMap != null && location != null) {
            return clientInfoMap.get(location);
        }
        return null;
    }

    public static Map<ResourceLocation, CustomModifierData> getCustomModifiers() {
        if (infoMap != null) {
            return infoMap;
        }
        return null;
    }

    protected Map<ResourceLocation, CustomModifierData> prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        infoMap = null;
        isTagLoaded = false;
        clientInfoMap = null;
        isModifiers = false;
        HashMap<ResourceLocation, CustomModifierData> map = new HashMap<ResourceLocation, CustomModifierData>();
        resourceManagerIn.func_199003_a("modifiers/", s -> s.endsWith(".json")).forEach(resourceLocation -> {
            try {
                resourceManagerIn.func_199004_b(resourceLocation).forEach(resource -> {
                    try (InputStream is = resource.func_199027_b();
                         BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                        String path = resourceLocation.func_110623_a();
                        int index = path.lastIndexOf(47);
                        if (index > 0) {
                            CustomModifierData skin;
                            path = path.substring(index).replace("/", "").replace(".json", "");
                            ResourceLocation id = ResourceLocation.func_208304_a((String)(resourceLocation.func_110624_b() + ":" + path));
                            if (id != null && (skin = (CustomModifierData)JSONUtils.func_193839_a((Gson)GSON_INSTANCE, (Reader)reader, CustomModifierData.class)) != null) {
                                skin.setId(id);
                                if (Validator.isValidObject(skin)) {
                                    map.put(id, skin);
                                }
                            }
                        }
                    }
                    catch (InvalidObjectException e) {
                        GunMod.LOGGER.error("Missing required properties for {}", resourceLocation);
                    }
                    catch (IOException e) {
                        GunMod.LOGGER.error("Couldn't parse data file {}", resourceLocation);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                GunMod.LOGGER.error("Couldn't parse data file {}", resourceLocation);
            }
        });
        return map;
    }

    protected void apply(Map<ResourceLocation, CustomModifierData> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        infoMap = objectIn;
    }

    public void writeAttachments(PacketBuffer buffer) {
        buffer.func_150787_b(infoMap.size());
        infoMap.forEach((id, skinInfo) -> {
            buffer.func_192572_a(id);
            buffer.func_150786_a(skinInfo.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, CustomModifierData> readModifiers(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.func_192575_l();
                CustomModifierData info = new CustomModifierData();
                CompoundNBT nbt = buffer.func_150793_b();
                if (nbt == null) continue;
                info.deserializeNBT(nbt);
                builder.put((Object)id, (Object)info);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        instance = new NetworkModifierManager();
        event.addListener((IFutureReloadListener)instance);
    }

    @SubscribeEvent
    public static void onServerStopped(FMLServerStoppedEvent event) {
        infoMap = null;
        isTagLoaded = false;
        clientInfoMap = null;
        isModifiers = false;
        instance = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateCustomAttachments(ICustomModifiersProvider message) {
        clientInfoMap = new HashMap<ResourceLocation, CustomModifierData>();
        clientInfoMap.putAll((Map<ResourceLocation, CustomModifierData>)message.getCustomModifiers());
        if (isTagLoaded && !isModifiers) {
            clientInfoMap.forEach((k, v) -> v.init());
        }
        isModifiers = true;
        return true;
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent.VanillaTagTypes event) {
        isTagLoaded = true;
        if (infoMap != null) {
            infoMap.forEach((k, v) -> v.init());
        }
        if (isModifiers) {
            clientInfoMap.forEach((k, v) -> v.init());
            isModifiers = true;
        }
    }

    static {
        isTagLoaded = false;
        isModifiers = false;
    }

    public static interface ICustomModifiersProvider {
        public ImmutableMap<ResourceLocation, CustomModifierData> getCustomModifiers();
    }
}

