/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.tac.guns.entity.ProjectileEntity;
import com.tac.guns.init.ModEntities;
import com.tac.guns.interfaces.IProjectileFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ProjectileManager {
    private static ProjectileManager instance = null;
    private final IProjectileFactory DEFAULT_FACTORY = (worldIn, entity, weapon, item, modifiedGun, randP, randY) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun, randP, randY);
    private final Map<ResourceLocation, IProjectileFactory> projectileFactoryMap = new HashMap<ResourceLocation, IProjectileFactory>();

    public static ProjectileManager getInstance() {
        if (instance == null) {
            instance = new ProjectileManager();
        }
        return instance;
    }

    public void registerFactory(Item ammo, IProjectileFactory factory) {
        this.projectileFactoryMap.put(ammo.getRegistryName(), factory);
    }

    public IProjectileFactory getFactory(ResourceLocation id) {
        return this.projectileFactoryMap.getOrDefault(id, this.DEFAULT_FACTORY);
    }
}

