/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

@Mod.EventBusSubscriber(modid="tac")
public class DelayedTask {
    public static List<Impl> tasks = new ArrayList<Impl>();

    @SubscribeEvent
    public static void onServerStart(FMLServerStartedEvent event) {
        tasks.clear();
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent event) {
        tasks.clear();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            Iterator<Impl> it = tasks.iterator();
            while (it.hasNext()) {
                Impl impl = it.next();
                if (impl.executionTick > server.func_71259_af()) continue;
                impl.runnable.run();
                it.remove();
            }
        }
    }

    public static void runAfter(int ticks, Runnable run) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (!server.func_213162_bc()) {
            throw new IllegalStateException("Tried to add a delayed task off the main thread");
        }
        tasks.add(new Impl(server.func_71259_af() + ticks, run));
    }

    private static class Impl {
        private int executionTick;
        private Runnable runnable;

        private Impl(int executionTick, Runnable runnable) {
            this.executionTick = executionTick;
            this.runnable = runnable;
        }
    }
}

