/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tac")
public class AimingManager {
    private static AimingManager instance;
    protected final Map<PlayerEntity, AimTracker> aimingMap = new WeakHashMap<PlayerEntity, AimTracker>();
    private static final double MAX_AIM_PROGRESS = 4.0;

    public static AimingManager get() {
        if (instance == null) {
            instance = new AimingManager();
        }
        return instance;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AimTracker tracker;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        if (player.func_175149_v()) {
            return;
        }
        AimingManager manager = AimingManager.get();
        boolean isAiming = (Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.AIMING);
        if (isAiming && !manager.aimingMap.containsKey(player)) {
            manager.aimingMap.put(player, new AimTracker());
        }
        if ((tracker = manager.getAimTracker(player)) != null) {
            tracker.handleAiming(player.func_184614_ca(), isAiming);
            tracker.tickLerpProgress();
            if (!tracker.isAiming()) {
                manager.aimingMap.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        AimingManager.get().aimingMap.remove(event.getPlayer());
    }

    @Nullable
    public AimTracker getAimTracker(PlayerEntity player) {
        return this.aimingMap.get(player);
    }

    public Map<PlayerEntity, AimTracker> getAimingMap() {
        return this.aimingMap;
    }

    public static class AimTracker {
        private double currentAim;
        private double previousAim;
        private double amplifier = 0.8;
        private double lerpProgress;

        public void handleAiming(ItemStack heldItem, boolean isAiming) {
            this.previousAim = this.currentAim;
            double vAmplifier = 0.1;
            if (isAiming) {
                if (this.amplifier < 1.3) {
                    this.amplifier += vAmplifier;
                }
                if (this.currentAim < 4.0) {
                    double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                    speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                    int[] levelSpeed = new int[]{0, 3, 6, 8, 10, 12, 14, 16, 18, 20};
                    if (heldItem.func_77978_p() != null && heldItem.func_77978_p().func_74781_a("level") != null && !heldItem.func_77978_p().func_74767_n("levelLock")) {
                        speed *= (100.0 + (double)levelSpeed[heldItem.func_77978_p().func_74762_e("level") - 1]) / 100.0;
                    }
                    this.currentAim += speed * this.amplifier;
                    if (this.currentAim > 4.0) {
                        this.amplifier = 0.5;
                        this.currentAim = 4.0;
                    }
                }
            } else if (this.currentAim > 0.0) {
                if (this.amplifier < 1.3) {
                    this.amplifier += vAmplifier;
                }
                double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                int[] levelSpeed = new int[]{0, 3, 6, 8, 10, 12, 14, 16, 18, 20};
                if (heldItem.func_77978_p() != null && heldItem.func_77978_p().func_74781_a("level") != null && !heldItem.func_77978_p().func_74767_n("levelLock")) {
                    speed *= (100.0 + (double)levelSpeed[heldItem.func_77978_p().func_74762_e("level") - 1]) / 100.0;
                }
                this.currentAim -= speed * this.amplifier;
                if (this.currentAim < 0.0) {
                    this.amplifier = 0.5;
                    this.currentAim = 0.0;
                }
            } else {
                this.amplifier = 0.8;
            }
        }

        public boolean isAiming() {
            return this.currentAim != 0.0 || this.previousAim != 0.0;
        }

        protected void tickLerpProgress() {
            this.lerpProgress += (this.getNormalProgress(1.0f) - this.lerpProgress) * 0.5;
        }

        public double getLerpProgress() {
            return this.lerpProgress;
        }

        public double getNormalProgress(float partialTicks) {
            return (this.previousAim + (this.currentAim - this.previousAim) * (double)(this.previousAim == 0.0 || this.previousAim == 4.0 ? 0.0f : partialTicks)) / 4.0;
        }
    }
}

