/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tac.guns.client.gunskin.DyeSkin;
import com.tac.guns.client.gunskin.GunSkin;
import com.tac.guns.client.gunskin.SkinManager;
import com.tac.guns.item.transition.TimelessGunItem;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class ModelRenderUtil {
    private static final RenderType SOLID_L = RenderType.func_228633_a_((String)"solid_light", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)131072, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(false)).func_228719_a_(new RenderState.LightmapState(true)).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, false)).func_228713_a_(new RenderState.AlphaState(0.5f)).func_228728_a_(true));

    private static void renderQuads(MatrixStack stack, IVertexBuilder buffer, List<BakedQuad> quads, int light, int overlay, int[] color) {
        MatrixStack.Entry entry = stack.func_227866_c_();
        for (BakedQuad quad : quads) {
            if (quad.func_178212_b()) {
                int i = quad.func_178211_c();
                if (i < 0 || i >= color.length) continue;
                int c = color[i];
                Color c1 = new Color(c);
                buffer.addVertexData(entry, quad, (float)c1.getRed() / 255.0f, (float)c1.getGreen() / 255.0f, (float)c1.getBlue() / 255.0f, 1.0f, light, overlay, false);
                continue;
            }
            buffer.addVertexData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay, false);
        }
    }

    private static void renderQuads(MatrixStack stack, IVertexBuilder buffer, List<BakedQuad> quads, int light, int overlay) {
        MatrixStack.Entry entry = stack.func_227866_c_();
        for (BakedQuad quad : quads) {
            buffer.addVertexData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlay, false);
        }
    }

    public static void renderModel(IBakedModel model, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay, int[] color) {
        stack.func_227860_a_();
        stack.func_227861_a_(-0.5, -0.5, -0.5);
        RenderType renderType = RenderType.func_228644_e_((ResourceLocation)PlayerContainer.field_226615_c_);
        IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)true, (boolean)false);
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, direction, random), light, overlay, color);
        }
        random.setSeed(42L);
        ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, null, random), light, overlay, color);
        stack.func_227865_b_();
    }

    private static void renderModel(IBakedModel model, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay) {
        stack.func_227860_a_();
        stack.func_227861_a_(-0.5, -0.5, -0.5);
        RenderType renderType = RenderType.func_228644_e_((ResourceLocation)PlayerContainer.field_226615_c_);
        IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)true, (boolean)false);
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, direction, random), light, overlay);
        }
        random.setSeed(42L);
        ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, null, random), light, overlay);
        stack.func_227865_b_();
    }

    public static void renderModel(IBakedModel model, @Nonnull ItemStack item, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay) {
        if (item.func_77973_b() instanceof TimelessGunItem) {
            GunSkin skin = SkinManager.getSkin(item);
            if (skin instanceof DyeSkin) {
                int[] colors = ((DyeSkin)skin).getColors();
                ModelRenderUtil.renderModel(model, stack, buffer, light, overlay, colors);
            } else {
                ModelRenderUtil.renderModel(model, stack, buffer, light, overlay);
            }
        }
    }

    public static void renderNegativeModel(IBakedModel model, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay, int[] color) {
        stack.func_227860_a_();
        stack.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)SOLID_L, (boolean)true, (boolean)false);
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, direction, random), light, overlay, color);
        }
        random.setSeed(42L);
        ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, null, random), light, overlay, color);
        stack.func_227865_b_();
    }

    private static void renderNegativeModel(IBakedModel model, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay) {
        stack.func_227860_a_();
        stack.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)buffer, (RenderType)SOLID_L, (boolean)true, (boolean)false);
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, direction, random), light, overlay);
        }
        random.setSeed(42L);
        ModelRenderUtil.renderQuads(stack, builder, model.func_200117_a(null, null, random), light, overlay);
        stack.func_227865_b_();
    }

    public static void renderNegativeModel(IBakedModel model, @Nonnull ItemStack item, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay) {
        if (item.func_77973_b() instanceof TimelessGunItem) {
            GunSkin skin = SkinManager.getSkin(item);
            if (skin instanceof DyeSkin) {
                int[] colors = ((DyeSkin)skin).getColors();
                ModelRenderUtil.renderNegativeModel(model, stack, buffer, light, overlay, colors);
            } else {
                ModelRenderUtil.renderNegativeModel(model, stack, buffer, light, overlay);
            }
        }
    }
}

