/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.crosshair;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.render.crosshair.Crosshair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class TechCrosshair
extends Crosshair {
    private static final ResourceLocation TECH_CROSSHAIR = new ResourceLocation("tac", "textures/crosshair/tech.png");
    private static final ResourceLocation DOT_CROSSHAIR = new ResourceLocation("tac", "textures/crosshair/dot.png");
    private float scale;
    private float prevScale;
    private float rotation;
    private float prevRotation;

    public TechCrosshair() {
        super(new ResourceLocation("tac", "tech"));
    }

    @Override
    public void tick() {
        this.prevRotation = this.rotation;
        this.prevScale = this.scale;
        this.rotation += 4.0f;
        this.scale *= 0.75f;
    }

    @Override
    public void onGunFired() {
        this.scale = 1.5f;
    }

    @Override
    public void render(Minecraft mc, MatrixStack stack, int windowWidth, int windowHeight, float partialTicks) {
        float alpha = 1.0f - (float)AimingHandler.get().getNormalisedAdsProgress();
        float size = 8.0f;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        stack.func_227860_a_();
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        stack.func_227861_a_((double)(((float)windowWidth - size) / 2.0f), (double)(((float)windowHeight - size) / 2.0f), 0.0);
        mc.func_110434_K().func_110577_a(DOT_CROSSHAIR);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, 0.0f, size, 0.0f).func_225583_a_(0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, size, size, 0.0f).func_225583_a_(1.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, size, 0.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
        stack.func_227865_b_();
        stack.func_227860_a_();
        matrix = stack.func_227866_c_().func_227870_a_();
        stack.func_227861_a_((double)((float)windowWidth / 2.0f), (double)((float)windowHeight / 2.0f), 0.0);
        float scale = 1.0f + MathHelper.func_219799_g((float)partialTicks, (float)this.prevScale, (float)this.scale);
        stack.func_227862_a_(scale, scale, scale);
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)this.prevRotation, (float)this.rotation)));
        stack.func_227861_a_((double)(-size / 2.0f), (double)(-size / 2.0f), 0.0);
        mc.func_110434_K().func_110577_a(TECH_CROSSHAIR);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, 0.0f, size, 0.0f).func_225583_a_(0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, size, size, 0.0f).func_225583_a_(1.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, size, 0.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        buffer.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
        stack.func_227865_b_();
        RenderSystem.defaultBlendFunc();
    }
}

