/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.common.Gun;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageAnimationRun;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class GunAnimationController {
    private AnimationMeta previousAnimation;
    private AnimationSoundMeta previousSound;
    private static final Map<ResourceLocation, GunAnimationController> animationControllerMap = new HashMap<ResourceLocation, GunAnimationController>();

    protected void enableStaticState() {
        AnimationMeta staticMeta = this.getAnimationFromLabel(AnimationLabel.STATIC);
        if (staticMeta != null) {
            try {
                for (AnimationLabel label : AnimationLabel.values()) {
                    AnimationMeta meta = this.getAnimationFromLabel(label);
                    if (meta == null) continue;
                    Animations.specifyInitialModel(meta, staticMeta);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void runAnimation(AnimationMeta animationMeta, AnimationSoundMeta soundMeta, Runnable callback) {
        if (animationMeta != null) {
            Animations.runAnimation(animationMeta, callback);
            this.previousAnimation = animationMeta;
        }
        if (animationMeta != null && soundMeta != null) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            if (animationMeta.getResourceLocation() == null || soundMeta.getResourceLocation() == null) {
                return;
            }
            MessageAnimationRun message = new MessageAnimationRun(animationMeta.getResourceLocation(), soundMeta.getResourceLocation(), true, player.func_110124_au());
            PacketHandler.getPlayChannel().sendToServer((Object)message);
            this.previousSound = soundMeta;
        }
    }

    public boolean isAnimationRunning() {
        return Animations.isAnimationRunning(this.previousAnimation);
    }

    public AnimationMeta getPreviousAnimation() {
        return this.previousAnimation;
    }

    public void stopAnimation() {
        if (this.previousAnimation != null) {
            Animations.stopAnimation(this.previousAnimation);
        }
        if (this.previousAnimation != null && this.previousSound != null) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            MessageAnimationRun message = new MessageAnimationRun(this.previousAnimation.getResourceLocation(), this.previousSound.getResourceLocation(), false, player.func_110124_au());
            PacketHandler.getPlayChannel().sendToServer((Object)message);
        }
    }

    public void runAnimation(AnimationLabel label) {
        this.runAnimation(this.getAnimationFromLabel(label), this.getSoundFromLabel(label), null);
    }

    public void runAnimation(AnimationLabel label, Runnable callback) {
        this.runAnimation(this.getAnimationFromLabel(label), this.getSoundFromLabel(label), callback);
    }

    public abstract AnimationMeta getAnimationFromLabel(AnimationLabel var1);

    protected abstract int getAttachmentsNodeIndex();

    protected abstract int getRightHandNodeIndex();

    protected abstract int getLeftHandNodeIndex();

    public AnimationSoundMeta getSoundFromLabel(AnimationLabel label) {
        return null;
    }

    protected AnimationSoundMeta getSoundFromLabel(Item item, AnimationLabel label) {
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun.Sounds sounds = gunItem.getGun().getSounds();
            switch (label) {
                case RELOAD_EMPTY: {
                    return new AnimationSoundMeta(sounds.getReloadEmpty());
                }
                case RELOAD_NORMAL: {
                    return new AnimationSoundMeta(sounds.getReloadNormal());
                }
                case DRAW: {
                    return new AnimationSoundMeta(sounds.getDraw());
                }
                case INSPECT: {
                    return new AnimationSoundMeta(sounds.getInspect());
                }
                case INSPECT_EMPTY: {
                    return new AnimationSoundMeta(sounds.getInspectEmpty());
                }
            }
            return null;
        }
        return null;
    }

    public void applyAttachmentsTransform(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, LivingEntity entity, MatrixStack matrixStack) {
        boolean isFirstPerson = transformType.func_241716_a_();
        if (isFirstPerson) {
            Animations.pushNode(this.previousAnimation, this.getAttachmentsNodeIndex());
        }
        Animations.applyAnimationTransform(itemStack, ItemCameraTransforms.TransformType.NONE, entity, matrixStack);
        if (isFirstPerson) {
            Animations.popNode();
        }
    }

    public void applySpecialModelTransform(IBakedModel model, int index, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack) {
        boolean isFirstPerson = transformType.func_241716_a_();
        if (isFirstPerson) {
            Animations.pushNode(this.previousAnimation, index);
        }
        Animations.applyAnimationTransform(model, ItemCameraTransforms.TransformType.NONE, matrixStack);
        if (isFirstPerson) {
            Animations.popNode();
        }
    }

    public void applyTransform(ItemStack itemStack, int index, ItemCameraTransforms.TransformType transformType, LivingEntity entity, MatrixStack matrixStack) {
        boolean isFirstPerson = transformType.func_241716_a_();
        if (isFirstPerson) {
            Animations.pushNode(this.previousAnimation, index);
        }
        Animations.applyAnimationTransform(itemStack, ItemCameraTransforms.TransformType.NONE, entity, matrixStack);
        if (isFirstPerson) {
            Animations.popNode();
        }
    }

    public Vector3f getYPRAngle(int index) {
        if (this.previousAnimation == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        Animations.pushNode(this.previousAnimation, index);
        Vector3f result = Animations.getAlphaYPRAngle();
        Animations.popNode();
        return result;
    }

    public void applyRightHandTransform(MatrixStack matrixStack) {
        if (this.previousAnimation != null) {
            Animations.pushNode(this.previousAnimation, this.getRightHandNodeIndex());
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            Matrix4f animationTransition = new Matrix4f(Animations.peekNodeModel().computeGlobalTransform(null));
            animationTransition.func_226602_e_();
            matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(animationTransition);
            Animations.popNode();
        }
    }

    public void applyLeftHandTransform(MatrixStack matrixStack) {
        if (this.previousAnimation != null) {
            Animations.pushNode(this.previousAnimation, this.getLeftHandNodeIndex());
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            Matrix4f animationTransition = new Matrix4f(Animations.peekNodeModel().computeGlobalTransform(null));
            animationTransition.func_226602_e_();
            matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(animationTransition);
            Animations.popNode();
        }
    }

    public boolean isAnimationRunning(AnimationLabel label) {
        if (!this.isAnimationRunning()) {
            return false;
        }
        if (this.previousAnimation == null) {
            return false;
        }
        AnimationMeta meta = this.getAnimationFromLabel(label);
        if (meta == null) {
            return false;
        }
        return meta.equals(this.previousAnimation);
    }

    public static void setAnimationControllerMap(ResourceLocation itemRegistryName, GunAnimationController animationController) {
        animationControllerMap.put(itemRegistryName, animationController);
    }

    public static GunAnimationController fromItem(Item item) {
        return animationControllerMap.get(item.getRegistryName());
    }

    public static GunAnimationController fromRegistryName(ResourceLocation registryName) {
        return animationControllerMap.get(registryName);
    }

    public static enum AnimationLabel {
        RELOAD_NORMAL,
        RELOAD_EMPTY,
        RELOAD_INTRO,
        RELOAD_LOOP,
        RELOAD_NORMAL_END,
        RELOAD_EMPTY_END,
        PUMP,
        PULL_BOLT,
        INSPECT,
        INSPECT_EMPTY,
        DRAW,
        STATIC,
        BULLET_CHAIN;

    }
}

