/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import de.javagl.jgltf.model.GltfAnimations;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.animation.Animation;
import de.javagl.jgltf.model.animation.AnimationManager;
import de.javagl.jgltf.model.animation.AnimationRunner;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.GltfAssetReader;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.v2.GltfModelV2;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Animations {
    private static final Stack<NodeModel> nodeModelStack = new Stack();
    private static final Stack<NodeModel> initialModelStack = new Stack();
    private static final MatrixStack extraMatrixStack = new MatrixStack();
    private static NodeModel bind;
    private static NodeModel initial;
    private static final Map<String, GltfModelV2> gltfModelV2Map;
    private static final Map<String, GltfModelV2> initialModelMap;
    private static final Map<String, AnimationRunner> animationRunnerMap;
    private static final Map<String, AnimationManager> animationManagerMap;

    public static GltfModelV2 load(AnimationMeta animationMeta) throws IOException {
        if (animationMeta != null) {
            return Animations.load(animationMeta.getResourceLocation());
        }
        return null;
    }

    public static GltfModelV2 load(ResourceLocation resourceLocation) throws IOException {
        GltfAssetReader reader = new GltfAssetReader();
        IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation);
        InputStream inputStream = resource.func_199027_b();
        GltfAsset asset = reader.readWithoutReferences(inputStream);
        if (asset instanceof GltfAssetV2) {
            GltfModelV2 model = new GltfModelV2((GltfAssetV2)asset);
            gltfModelV2Map.put(resourceLocation.toString(), model);
            List<Animation> animations = GltfAnimations.createModelAnimations(model.getAnimationModels());
            AnimationManager animationManager = new AnimationManager(AnimationManager.AnimationPolicy.TIP_STOP);
            animationManager.addAnimations(animations);
            animationManagerMap.put(resourceLocation.toString(), animationManager);
            Animations.stopAnimation(resourceLocation);
            AnimationRunner newRunner = new AnimationRunner(animationManager);
            animationRunnerMap.put(resourceLocation.toString(), newRunner);
            GltfModelV2 model2 = new GltfModelV2((GltfAssetV2)asset);
            List<Animation> animations2 = GltfAnimations.createModelAnimations(model2.getAnimationModels());
            AnimationManager initialStateManager = new AnimationManager(AnimationManager.AnimationPolicy.TIP_STOP);
            initialStateManager.addAnimations(animations2);
            initialStateManager.reset();
            initialStateManager.performStep(1L);
            initialModelMap.put(resourceLocation.toString(), model2);
            return model;
        }
        inputStream.close();
        return null;
    }

    public static void specifyInitialModel(AnimationMeta animationMeta, AnimationMeta initialMeta) throws IOException {
        IResource initialResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(initialMeta.getResourceLocation());
        InputStream inputStream = initialResource.func_199027_b();
        GltfAssetReader reader = new GltfAssetReader();
        GltfAsset asset = reader.readWithoutReferences(inputStream);
        GltfModelV2 model2 = new GltfModelV2((GltfAssetV2)asset);
        List<Animation> animations2 = GltfAnimations.createModelAnimations(model2.getAnimationModels());
        AnimationManager initialStateManager = new AnimationManager(AnimationManager.AnimationPolicy.TIP_STOP);
        initialStateManager.addAnimations(animations2);
        initialStateManager.reset();
        initialStateManager.performStep(1L);
        initialModelMap.put(animationMeta.getResourceLocation().toString(), model2);
    }

    private static GltfModelV2 getGltfModel(ResourceLocation resourceLocation) {
        return gltfModelV2Map.get(resourceLocation.toString());
    }

    private static GltfModelV2 getInitialModel(ResourceLocation resourceLocation) {
        return initialModelMap.get(resourceLocation.toString());
    }

    public static void pushNode(AnimationMeta animationMeta, int index) {
        if (animationMeta != null) {
            Animations.pushNode(animationMeta.getResourceLocation(), index);
        }
    }

    public static void pushNode(ResourceLocation gltfResource, int index) {
        if (gltfResource == null) {
            return;
        }
        GltfModelV2 gltfModel = Animations.getGltfModel(gltfResource);
        bind = gltfModel == null ? null : gltfModel.getNodeModels().get(index);
        GltfModelV2 initialModel = Animations.getInitialModel(gltfResource);
        initial = initialModel == null ? null : initialModel.getNodeModels().get(index);
        nodeModelStack.push(bind);
        initialModelStack.push(initial);
    }

    public static void popNode() {
        if (!nodeModelStack.empty()) {
            nodeModelStack.pop();
        }
        if (!initialModelStack.empty()) {
            initialModelStack.pop();
        }
        bind = nodeModelStack.empty() ? null : nodeModelStack.peek();
        initial = initialModelStack.empty() ? null : initialModelStack.peek();
    }

    public static NodeModel peekNodeModel() {
        return bind;
    }

    public static NodeModel peekInitialModel() {
        return initial;
    }

    public static AnimationRunner getAnimationRunner(ResourceLocation resourceLocation) {
        return animationRunnerMap.get(resourceLocation.toString());
    }

    public static void runAnimation(AnimationMeta animationMeta) {
        if (animationMeta != null) {
            Animations.runAnimation(animationMeta.getResourceLocation());
        }
    }

    public static void runAnimation(ResourceLocation resourceLocation) {
        Animations.runAnimation(resourceLocation, null);
    }

    public static void runAnimation(AnimationMeta animationMeta, Runnable callback) {
        if (animationMeta != null) {
            Animations.runAnimation(animationMeta.getResourceLocation(), callback);
        }
    }

    public static void runAnimation(ResourceLocation resourceLocation, Runnable callback) {
        AnimationRunner runner = Animations.getAnimationRunner(resourceLocation);
        if (runner != null) {
            if (runner.isRunning()) {
                return;
            }
            runner.start(callback);
        }
    }

    public static void stopAnimation(AnimationMeta animationMeta) {
        if (animationMeta != null) {
            Animations.stopAnimation(animationMeta.getResourceLocation());
        }
    }

    public static void stopAnimation(ResourceLocation resourceLocation) {
        AnimationManager manager;
        AnimationRunner runner = Animations.getAnimationRunner(resourceLocation);
        if (runner != null) {
            runner.stop();
        }
        if ((manager = Animations.getAnimationManager(resourceLocation)) != null) {
            manager.reset();
            manager.performStep(0L);
        }
    }

    public static boolean isAnimationRunning(AnimationMeta animationMeta) {
        if (animationMeta != null) {
            return Animations.isAnimationRunning(animationMeta.getResourceLocation());
        }
        return false;
    }

    public static boolean isAnimationRunning(ResourceLocation resourceLocation) {
        AnimationRunner runner = Animations.getAnimationRunner(resourceLocation);
        if (runner == null) {
            return false;
        }
        return runner.isRunning();
    }

    private static AnimationManager getAnimationManager(ResourceLocation resourceLocation) {
        return animationManagerMap.get(resourceLocation.toString());
    }

    public static MatrixStack getExtraMatrixStack() {
        return extraMatrixStack;
    }

    public static void applyExtraTransform(MatrixStack matrixStack) {
        matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(extraMatrixStack.func_227866_c_().func_227870_a_());
        matrixStack.func_227866_c_().func_227872_b_().func_226118_b_(extraMatrixStack.func_227866_c_().func_227872_b_());
    }

    public static void applyAnimationTransform(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, LivingEntity entity, MatrixStack matrixStack) {
        if (itemStack != null && entity != null) {
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemStack, entity.field_70170_p, entity);
            Animations.applyAnimationTransform(model, transformType, matrixStack);
        }
    }

    public static void applyAnimationTransform(IBakedModel model, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack) {
        if (Animations.peekNodeModel() != null && Animations.peekInitialModel() != null) {
            ItemTransformVec3f modelTransformVec3f;
            ItemTransformVec3f itemTransformVec3f = modelTransformVec3f = model == null ? null : model.func_177552_f().func_181688_b(transformType);
            if (modelTransformVec3f != null) {
                matrixStack.func_227861_a_((double)modelTransformVec3f.field_178365_c.func_195899_a(), (double)modelTransformVec3f.field_178365_c.func_195900_b(), (double)modelTransformVec3f.field_178365_c.func_195902_c());
                matrixStack.func_227862_a_(modelTransformVec3f.field_178363_d.func_195899_a(), modelTransformVec3f.field_178363_d.func_195900_b(), modelTransformVec3f.field_178363_d.func_195902_c());
                matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            Matrix4f animationTransition = new Matrix4f(Animations.peekNodeModel().computeGlobalTransform(null));
            Matrix4f initialTransition = new Matrix4f(Animations.peekInitialModel().computeGlobalTransform(null));
            animationTransition.func_226602_e_();
            initialTransition.func_226602_e_();
            initialTransition.func_226600_c_();
            matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(animationTransition);
            matrixStack.func_227866_c_().func_227870_a_().func_226595_a_(initialTransition);
            if (modelTransformVec3f != null) {
                matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                matrixStack.func_227862_a_(1.0f / modelTransformVec3f.field_178363_d.func_195899_a(), 1.0f / modelTransformVec3f.field_178363_d.func_195900_b(), 1.0f / modelTransformVec3f.field_178363_d.func_195902_c());
                matrixStack.func_227861_a_((double)(-modelTransformVec3f.field_178365_c.func_195899_a()), (double)(-modelTransformVec3f.field_178365_c.func_195900_b()), (double)(-modelTransformVec3f.field_178365_c.func_195902_c()));
            }
        }
        Animations.applyExtraTransform(matrixStack);
    }

    public static Vector3f getAlphaYPRAngle() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_226591_a_();
        Matrix4f animationTransition = new Matrix4f(Animations.peekNodeModel().computeGlobalTransform(null));
        Matrix4f initialTransition = new Matrix4f(Animations.peekInitialModel().computeGlobalTransform(null));
        animationTransition.func_226602_e_();
        initialTransition.func_226602_e_();
        initialTransition.func_226600_c_();
        matrix4f.func_226595_a_(animationTransition);
        matrix4f.func_226595_a_(initialTransition);
        float[][] matrix = new float[3][3];
        int i = 0;
        for (String str : matrix4f.toString().split("\n")) {
            if (str.contains("Matrix4f")) continue;
            if (i >= 3) break;
            int j = 0;
            for (String s : str.split(" ")) {
                if (j >= 3) break;
                matrix[i][j] = Float.parseFloat(s);
                ++j;
            }
            ++i;
        }
        Vector3f vector3f = new Vector3f();
        vector3f.setX((float)Math.atan2(matrix[2][1], matrix[2][2]));
        vector3f.setY((float)Math.atan2(-matrix[2][0], Math.sqrt(matrix[2][1] * matrix[2][1] + matrix[2][2] * matrix[2][2])));
        vector3f.setZ((float)Math.atan2(matrix[1][0], matrix[0][0]));
        return vector3f;
    }

    static {
        gltfModelV2Map = new HashMap<String, GltfModelV2>();
        initialModelMap = new HashMap<String, GltfModelV2>();
        animationRunnerMap = new HashMap<String, AnimationRunner>();
        animationManagerMap = new HashMap<String, AnimationManager>();
    }
}

