/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.obfuscate.client.event.PlayerModelEvent;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.GunRenderType;
import com.tac.guns.client.SpecialModels;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.handler.RecoilHandler;
import com.tac.guns.client.handler.ReloadHandler;
import com.tac.guns.client.handler.ScopeJitterHandler;
import com.tac.guns.client.handler.command.GunEditor;
import com.tac.guns.client.render.IHeldAnimation;
import com.tac.guns.client.render.animation.module.CameraAnimated;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.client.render.animation.module.PistalAnimationController;
import com.tac.guns.client.render.gun.IOverrideModel;
import com.tac.guns.client.render.gun.ModelOverrides;
import com.tac.guns.client.util.RenderUtil;
import com.tac.guns.common.Gun;
import com.tac.guns.common.network.ServerPlayHandler;
import com.tac.guns.common.tooling.CommandsHandler;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GrenadeItem;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.OldScopeItem;
import com.tac.guns.item.PistolScopeItem;
import com.tac.guns.item.ScopeItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.attachment.IBarrel;
import com.tac.guns.item.attachment.impl.Barrel;
import com.tac.guns.item.attachment.impl.Scope;
import com.tac.guns.item.transition.ITimelessAnimated;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessagePlayerShake;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.IDLNBTUtil;
import com.tac.guns.util.OptifineHelper;
import com.tac.guns.util.math.MathUtil;
import com.tac.guns.util.math.OneDimensionalPerlinNoise;
import com.tac.guns.util.math.SecondOrderDynamics;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkDirection;

public class GunRenderingHandler {
    private static GunRenderingHandler instance;
    private final SecondOrderDynamics recoilDynamics = new SecondOrderDynamics(0.5f, 0.6f, 2.65f, 0.0f);
    private final SecondOrderDynamics swayYawDynamics = new SecondOrderDynamics(0.4f, 0.5f, 3.25f, 0.0f);
    private final SecondOrderDynamics swayPitchDynamics = new SecondOrderDynamics(0.3f, 0.4f, 3.5f, 0.0f);
    private final SecondOrderDynamics aimingDynamics = new SecondOrderDynamics(0.45f, 0.92f, 1.1f, 0.0f);
    private final SecondOrderDynamics sprintDynamics = new SecondOrderDynamics(0.22f, 0.7f, 0.6f, 0.0f);
    private final SecondOrderDynamics bobbingDynamics = new SecondOrderDynamics(0.22f, 0.7f, 0.6f, 1.0f);
    private final SecondOrderDynamics speedUpDynamics = new SecondOrderDynamics(0.22f, 0.7f, 0.6f, 0.0f);
    private final SecondOrderDynamics delaySwayDynamics = new SecondOrderDynamics(0.75f, 0.9f, 1.4f, 0.0f);
    private final SecondOrderDynamics sprintDynamicsZ = new SecondOrderDynamics(0.22f, 0.8f, 0.5f, 0.0f);
    private final SecondOrderDynamics jumpingDynamics = new SecondOrderDynamics(0.28f, 1.0f, 0.65f, 0.0f);
    private final SecondOrderDynamics sprintDynamicsHSS = new SecondOrderDynamics(0.3f, 0.6f, 0.6f, 0.0f);
    private final SecondOrderDynamics sprintDynamicsZHSS = new SecondOrderDynamics(0.27f, 0.75f, 0.5f, 0.0f);
    public final SecondOrderDynamics sprintDynamicsHSSLeftHand = new SecondOrderDynamics(0.38f, 1.0f, 0.0f, 0.0f);
    public static final ResourceLocation MUZZLE_FLASH_TEXTURE;
    public static final ResourceLocation MUZZLE_SMOKE_TEXTURE;
    private Random random = new Random();
    private Set<Integer> entityIdForMuzzleFlash = new HashSet<Integer>();
    private Set<Integer> entityIdForDrawnMuzzleFlash = new HashSet<Integer>();
    private Queue<ShellInAir> shells = new ArrayDeque<ShellInAir>();
    private Map<Integer, Float> entityIdToRandomValue = new HashMap<Integer, Float>();
    public int sprintTransition;
    private int prevSprintTransition;
    private int sprintCooldown;
    private int restingTimer;
    private final int restingTimerUpper = 5;
    private float offhandTranslate;
    private float prevOffhandTranslate;
    public float muzzleExtraOnEnch = 0.0f;
    private Field equippedProgressMainHandField;
    private Field prevEquippedProgressMainHandField;
    private float startingDistance = 0.0f;
    private float speedUpDistanceFrom = 0.0f;
    public float speedUpDistance = 0.6f;
    public float speedUpProgress = 0.0f;
    private float additionalSwayProgress = 0.0f;
    private long fireTime = System.currentTimeMillis();
    public float immersiveWeaponRoll;
    public float walkingDistance1;
    public float walkingDistance = 0.0f;
    public float walkingCrouch;
    public float walkingCameraYaw;
    public float zoomProgressInv;
    public double xOffset = 0.0;
    public double yOffset = 0.0;
    public double zOffset = 0.0;
    public double opticMovement;
    public double slideKeep;
    public float translateX = 0.0f;
    public float translateY = 0.0f;
    public float translateZ = 0.0f;
    private double fix = 0.0;
    private static float maxRotationDegree;
    private static float delayedSwayMultiplier;
    private static Vector3f YDIR;
    public float sOT = 0.0f;
    public float wSpeed = 0.0f;
    public float kickReduction = 0.0f;
    public float recoilReduction = 0.0f;
    public double kick = 0.0;
    public float recoilLift = 0.0f;
    public float newSwayYawAmount = 0.0f;
    public float weaponsHorizontalAngle = 0.0f;
    public float newSwayPitch = 0.0f;
    public float newSwayYaw = 0.0f;
    public float newSwayYawPitch = 0.0f;
    public float newSwayYawYaw = 0.0f;
    private int backwardTicker = 0;
    private float velocity = 0.0f;
    private float acceleration = 0.0f;
    private float stepLength = 0.0f;
    private long prevTime = new Date().getTime();
    private final OneDimensionalPerlinNoise noiseX = new OneDimensionalPerlinNoise(-0.003f, 0.003f, 2400L);
    private final OneDimensionalPerlinNoise noiseY = new OneDimensionalPerlinNoise(-0.003f, 0.003f, 2800L);
    private final OneDimensionalPerlinNoise aimed_noiseX;
    private final OneDimensionalPerlinNoise aimed_noiseY;
    private final OneDimensionalPerlinNoise additionNoiseY;
    private final OneDimensionalPerlinNoise noiseRotationY;
    private final OneDimensionalPerlinNoise aimed_noiseRotationY;
    public float aimingHandLayerFov;
    public float originHandLayerFov;
    public float currentHandLayerFov;
    public double displayX;
    public double displayY;
    public double displayZ;
    public double sizeZ;
    public double adjustedTrailZ;

    public static GunRenderingHandler get() {
        if (instance == null) {
            instance = new GunRenderingHandler();
        }
        return instance;
    }

    private GunRenderingHandler() {
        this.noiseY.setReverse(true);
        this.aimed_noiseX = new OneDimensionalPerlinNoise(-7.5E-4f, 7.5E-4f, 1650L);
        this.aimed_noiseY = new OneDimensionalPerlinNoise(-0.00135f, 0.00135f, 1650L);
        this.noiseY.setReverse(true);
        this.additionNoiseY = new OneDimensionalPerlinNoise(-0.002f, 0.002f, 1300L);
        this.noiseRotationY = new OneDimensionalPerlinNoise(-0.8f, 0.8f, 2000L);
        this.aimed_noiseRotationY = new OneDimensionalPerlinNoise(-0.25f, 0.25f, 1600L);
        this.aimingHandLayerFov = 6.41236f;
        this.originHandLayerFov = 70.0f;
        this.currentHandLayerFov = 70.0f;
        this.displayX = 0.0;
        this.displayY = 0.0;
        this.displayZ = 0.0;
        this.sizeZ = 0.0;
        this.adjustedTrailZ = 0.0;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateSprinting();
        this.updateMuzzleFlash();
        this.updateShellCasing();
        this.updateOffhandTranslate();
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71158_b.field_187256_d) {
            if (this.backwardTicker < 8) {
                ++this.backwardTicker;
            }
        } else if (this.backwardTicker > 0) {
            --this.backwardTicker;
        }
        if (CommandsHandler.get().getCatCurrentIndex() == 1 && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash) {
            if (!(Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof TimelessGunItem)) {
                return;
            }
            TimelessGunItem gun = (TimelessGunItem)Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b();
            Gun modifiedGun = gun.getModifiedGun(Minecraft.func_71410_x().field_71439_g.func_184614_ca());
            if (modifiedGun.getDisplay().getFlash() != null || GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash) {
                this.showMuzzleFlashForPlayer(Minecraft.func_71410_x().field_71439_g.func_145782_y());
            }
        }
    }

    @SubscribeEvent
    public void onGunFired(GunFireEvent event) {
        if (event.isClient()) {
            this.fireTime = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        if (!(mc.field_71439_g.func_184614_ca().func_77973_b() instanceof GunItem) || mc.field_71439_g.func_184614_ca().func_77978_p() == null) {
            return;
        }
        if ((((Boolean)Config.SERVER.gameplay.forceCameraShakeOnFire.get()).booleanValue() || ((Boolean)Config.CLIENT.display.cameraShakeOnFire.get()).booleanValue()) && IDLNBTUtil.getInt(mc.field_71439_g.func_184614_ca(), "CurrentFireMode") != 0) {
            float cameraShakeDuration = 0.06f;
            long alphaTime = System.currentTimeMillis() - this.fireTime;
            float progress = (float)alphaTime < cameraShakeDuration * 1000.0f ? 1.0f - (float)alphaTime / (cameraShakeDuration * 1000.0f) : 0.0f;
            float alpha = progress * (float)(Math.random() - 0.5 < 0.0 ? -1 : 1) * 0.9f;
            event.setPitch(event.getPitch() - Math.abs(alpha));
            event.setRoll(event.getRoll() + alpha * 0.5f);
        }
        float multiplier = 20.0f;
        GunAnimationController controller = GunAnimationController.fromItem(mc.field_71439_g.func_184614_ca().func_77973_b());
        if (controller instanceof CameraAnimated) {
            int index = ((CameraAnimated)((Object)controller)).getCameraNodeIndex();
            Vector3f vector3f = controller.getYPRAngle(index);
            event.setYaw(event.getYaw() + vector3f.func_195899_a() * multiplier);
            event.setPitch(event.getPitch() + vector3f.func_195900_b() * multiplier);
            event.setRoll(event.getRoll() + vector3f.func_195902_c() * multiplier);
        }
    }

    @SubscribeEvent
    public void onFovModifying(EntityViewRenderEvent.FOVModifier event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || !mc.field_71439_g.func_70089_S() || mc.field_71439_g.func_175149_v()) {
            return;
        }
        if (!(mc.field_71439_g.func_184614_ca().func_77973_b() instanceof GunItem) || mc.field_71439_g.func_184614_ca().func_77978_p() == null) {
            return;
        }
        if ((((Boolean)Config.SERVER.gameplay.forceCameraShakeOnFire.get()).booleanValue() || ((Boolean)Config.CLIENT.display.cameraShakeOnFire.get()).booleanValue()) && mc.field_71439_g.func_184614_ca().func_77978_p().func_74762_e("CurrentFireMode") != 0) {
            float cameraShakeDuration = 0.06f * (AimingHandler.get().isAiming() ? 1.5f : 1.0f);
            long alphaTime = System.currentTimeMillis() - this.fireTime;
            float progress = (float)alphaTime < cameraShakeDuration * 1000.0f ? 1.0f - (float)alphaTime / (cameraShakeDuration * 1000.0f) : 0.0f;
            event.setFOV(event.getFOV() + (double)(progress * 0.5f));
        }
    }

    private void updateSprinting() {
        this.prevSprintTransition = this.sprintTransition;
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71439_g == null || !mc.field_71439_g.func_70051_ag() || mc.field_71439_g.func_213453_ef() || ((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.SHOOTING)).booleanValue() || ((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.RELOADING)).booleanValue() || AimingHandler.get().isAiming() || this.sprintCooldown != 0)) {
            ItemStack heldItem;
            if (Minecraft.func_71410_x().field_71439_g != null && (heldItem = Minecraft.func_71410_x().field_71439_g.func_184614_ca()).func_77973_b() instanceof GunItem) {
                GunItem modifiedGun = (GunItem)heldItem.func_77973_b();
                GunAnimationController controller = GunAnimationController.fromItem(modifiedGun.getItem());
                if (this.sprintTransition < 5 && (controller == null || modifiedGun.getGun().getGeneral().getGripType().getHeldAnimation().canApplySprintingAnimation() && !controller.isAnimationRunning())) {
                    ++this.sprintTransition;
                }
                if (controller != null && controller.isAnimationRunning() && this.sprintTransition > 0) {
                    --this.sprintTransition;
                }
            }
        } else if (this.sprintTransition > 0) {
            this.sprintTransition = 0;
        }
        if (this.sprintCooldown > 0) {
            --this.sprintCooldown;
        }
        if (this.sprintTransition == 0) {
            if (this.restingTimer < 5) {
                ++this.restingTimer;
            }
        } else {
            this.restingTimer = 0;
        }
    }

    private void updateMuzzleFlash() {
        this.entityIdForMuzzleFlash.removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdToRandomValue.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdForDrawnMuzzleFlash.clear();
        this.entityIdForDrawnMuzzleFlash.addAll(this.entityIdForMuzzleFlash);
    }

    private void updateShellCasing() {
        while (this.shells.peek() != null && this.shells.peek().livingTick <= 0) {
            this.shells.poll();
        }
        for (ShellInAir shell : this.shells) {
            --shell.livingTick;
            shell.velocity.func_229189_a_(new Vector3f(-0.02f * shell.velocity.func_195899_a(), -0.25f, -0.02f * shell.velocity.func_195900_b()));
            shell.preDisplacement.setX(shell.displacement.func_195899_a());
            shell.preDisplacement.setY(shell.displacement.func_195900_b());
            shell.preDisplacement.setZ(shell.displacement.func_195902_c());
            shell.preRotation.setX(shell.rotation.func_195899_a());
            shell.preRotation.setY(shell.rotation.func_195900_b());
            shell.preRotation.setZ(shell.rotation.func_195902_c());
            shell.displacement.func_229189_a_(shell.velocity);
            shell.rotation.func_229189_a_(shell.angularVelocity);
        }
    }

    private void updateOffhandTranslate() {
        this.prevOffhandTranslate = this.offhandTranslate;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        boolean down = false;
        ItemStack heldItem = mc.field_71439_g.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            down = !modifiedGun.getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem();
        }
        float direction = down ? -0.3f : 0.3f;
        this.offhandTranslate = MathHelper.func_76131_a((float)(this.offhandTranslate + direction), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        Gun.ShellCasing shellCasing;
        if (!event.isClient()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        Item item = event.getStack().func_77973_b();
        if (item instanceof ITimelessAnimated) {
            ITimelessAnimated animated = (ITimelessAnimated)item;
            animated.playAnimation("fire", event.getStack(), true);
        }
        this.sprintTransition = 0;
        this.speedUpDistanceFrom = Minecraft.func_71410_x().field_71439_g.field_70140_Q;
        this.sprintCooldown = 8;
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.func_77973_b();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getDisplay().getFlash() != null) {
            this.showMuzzleFlashForPlayer(Minecraft.func_71410_x().field_71439_g.func_145782_y());
        }
        if ((shellCasing = modifiedGun.getDisplay().getShellCasing()) != null) {
            float card = 1.0f - this.random.nextFloat() * 2.0f;
            float vard = 1.2f - this.random.nextFloat() * 0.4f;
            this.shells.add(new ShellInAir(new Vector3f((float)shellCasing.getXOffset(), (float)shellCasing.getYOffset(), (float)shellCasing.getZOffset()), new Vector3f(shellCasing.getVelocityX() + shellCasing.getRVelocityX() * card, shellCasing.getVelocityY() + shellCasing.getRVelocityY() * card, shellCasing.getVelocityZ() + shellCasing.getRVelocityZ() * card), new Vector3f(vard * shellCasing.getAVelocityX(), vard * shellCasing.getAVelocityY(), vard * shellCasing.getAVelocityZ()), modifiedGun.getDisplay().getShellCasing().getTickLife()));
        }
    }

    @SubscribeEvent
    public void onGunFirePre(GunFireEvent.Pre event) {
        if (this.sprintTransition == 0) {
            if (this.restingTimer < 5) {
                event.setCanceled(true);
            }
        } else {
            event.setCanceled(true);
        }
    }

    public void showMuzzleFlashForPlayer(int entityId) {
        this.entityIdForMuzzleFlash.add(entityId);
        this.entityIdToRandomValue.put(entityId, Float.valueOf(this.random.nextFloat()));
    }

    @SubscribeEvent
    public void onAnimatedGunReload(GunReloadEvent.Pre event) {
        Item item = event.getStack().func_77973_b();
        if (item instanceof ITimelessAnimated) {
            ITimelessAnimated animated = (ITimelessAnimated)item;
            animated.playAnimation("reload", event.getStack(), false);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderHandEvent event) {
        GunAnimationController controller = GunAnimationController.fromItem(event.getItemStack().func_77973_b());
        boolean isAnimated = controller != null;
        MatrixStack matrixStack = event.getMatrixStack();
        boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? event.getHand() == Hand.MAIN_HAND : event.getHand() == Hand.OFF_HAND;
        ItemStack heldItem = event.getItemStack();
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return;
        }
        event.setCanceled(true);
        ItemStack overrideModel = ItemStack.field_190927_a;
        if (heldItem.func_77978_p() != null && heldItem.func_77978_p().func_150297_b("Model", 10)) {
            overrideModel = ItemStack.func_199557_a((CompoundNBT)heldItem.func_77978_p().func_74775_l("Model"));
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        GunItem gunItem = (GunItem)heldItem.func_77973_b();
        if (mc.field_71474_y.field_74336_f && mc.func_175606_aa() instanceof PlayerEntity) {
            float crouch;
            PlayerEntity playerentity = (PlayerEntity)mc.func_175606_aa();
            float deltaDistanceWalked = playerentity.field_70140_Q - playerentity.field_70141_P;
            float distanceWalked = -(playerentity.field_70140_Q + deltaDistanceWalked * event.getPartialTicks());
            float cameraYaw = MathHelper.func_219799_g((float)event.getPartialTicks(), (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-(Math.abs(MathHelper.func_76134_b((float)(distanceWalked * (float)Math.PI - 0.2f)) * cameraYaw) * 5.0f)));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-(MathHelper.func_76126_a((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 3.0f)));
            matrixStack.func_227861_a_((double)(-(MathHelper.func_76126_a((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 0.5f)), (double)(-(-Math.abs(MathHelper.func_76134_b((float)(distanceWalked * (float)Math.PI)) * cameraYaw))), 0.0);
            boolean aimed = false;
            if (AimingHandler.get().isAiming()) {
                aimed = true;
            }
            double invertZoomProgress = aimed ? (Gun.getScope(heldItem) != null ? 0.0575 : 0.0725) : 0.468;
            float f = crouch = mc.field_71439_g.func_213453_ef() ? 148.0f : 1.0f;
            if (playerentity.field_70140_Q == playerentity.field_70141_P && !playerentity.func_225608_bj_()) {
                this.startingDistance = playerentity.field_70140_Q;
            }
            if (!mc.field_71439_g.field_71158_b.func_223135_b()) {
                this.speedUpDistanceFrom = playerentity.field_70140_Q;
                this.speedUpProgress -= (float)(new Date().getTime() - this.prevTime) / 150.0f;
                if (this.speedUpProgress < 0.0f) {
                    this.speedUpProgress = 0.0f;
                }
            } else {
                this.speedUpProgress = -distanceWalked - this.speedUpDistanceFrom < this.speedUpDistance ? (-distanceWalked - this.speedUpDistanceFrom) / this.speedUpDistance : 1.0f;
            }
            this.walkingDistance1 = distanceWalked += this.startingDistance;
            this.walkingCrouch = crouch;
            this.walkingCameraYaw = cameraYaw;
            this.zoomProgressInv = (float)invertZoomProgress;
            this.applyBobbingTransforms(matrixStack, false);
            this.applyJumpingTransforms(matrixStack, event.getPartialTicks());
            this.applyNoiseMovementTransform(matrixStack);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(distanceWalked * crouch * (float)Math.PI)) * cameraYaw * 3.0f * (float)invertZoomProgress));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(Math.abs(MathHelper.func_76134_b((float)(distanceWalked * crouch * (float)Math.PI - 0.2f)) * cameraYaw) * 5.0f * (float)invertZoomProgress));
            float rollingForceCrouch = mc.field_71439_g.func_213453_ef() ? 4.0f : 1.0f;
            float rollingForceAim = AimingHandler.get().isAiming() ? 0.425f : 1.0f;
            float targetAngle = heldItem.func_77973_b() instanceof GunItem ? mc.field_71439_g.field_71158_b.field_78902_a * (6.65f * rollingForceCrouch * rollingForceAim) : 0.0f;
            this.immersiveWeaponRoll = MathHelper.func_203300_b((float)this.immersiveWeaponRoll, (float)targetAngle, (float)0.335f);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.immersiveWeaponRoll));
        }
        if (event.getHand() == Hand.OFF_HAND) {
            Gun modifiedGun;
            if (heldItem.func_77973_b() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            float offhand = 1.0f - MathHelper.func_219799_g((float)event.getPartialTicks(), (float)this.prevOffhandTranslate, (float)this.offhandTranslate);
            matrixStack.func_227861_a_(0.0, (double)(offhand * -0.6f), 0.0);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.func_184614_ca().func_77973_b() instanceof GunItem && !(modifiedGun = ((GunItem)player.func_184614_ca().func_77973_b()).getModifiedGun(player.func_184614_ca())).getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem()) {
                return;
            }
            matrixStack.func_227861_a_(0.0, -2.0 * AimingHandler.get().getNormalisedAdsProgress(), 0.0);
        }
        ClientPlayerEntity entity = mc.field_71439_g;
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(overrideModel.func_190926_b() ? heldItem : overrideModel, entity.field_70170_p, (LivingEntity)entity);
        float scaleX = model.func_177552_f().field_188039_n.field_178363_d.func_195899_a();
        float scaleY = model.func_177552_f().field_188039_n.field_178363_d.func_195900_b();
        float scaleZ = model.func_177552_f().field_188039_n.field_178363_d.func_195902_c();
        this.translateX = model.func_177552_f().field_188039_n.field_178365_c.func_195899_a();
        this.translateY = model.func_177552_f().field_188039_n.field_178365_c.func_195900_b();
        this.translateZ = model.func_177552_f().field_188039_n.field_178365_c.func_195902_c();
        matrixStack.func_227860_a_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.canAimDownSight() && event.getHand() == Hand.MAIN_HAND) {
            Gun.ScaledPositioned scaledPos;
            this.xOffset = 0.0;
            this.yOffset = 0.0;
            this.zOffset = 0.0;
            Scope scope = Gun.getScope(heldItem);
            boolean isScopeOffsetType = (Boolean)Config.CLIENT.display.gameplayEnchancedScopeOffset.get();
            boolean isScopeRenderType = (Boolean)Config.CLIENT.display.scopeDoubleRender.get();
            if (modifiedGun.canAttachType(IAttachment.Type.SCOPE) && scope != null) {
                double viewFinderOffset;
                double d = viewFinderOffset = isScopeOffsetType || OptifineHelper.isShadersEnabled() ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset();
                if (scope.getAdditionalZoom().getZoomMultiple() > 1.0f) {
                    viewFinderOffset = isScopeRenderType ? (isScopeOffsetType || OptifineHelper.isShadersEnabled() ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset()) : (isScopeOffsetType || OptifineHelper.isShadersEnabled() ? scope.getViewFinderOffsetSpecialDR() : scope.getViewFinderOffsetDR());
                }
                try {
                    scaledPos = modifiedGun.getModules().getAttachments().getScope();
                    this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 + -scaledPos.getXOffset() * 0.0625 * (double)scaleX;
                    this.yOffset = (double)(-this.translateY) + (8.0 - scaledPos.getYOffset()) * 0.0625 * (double)scaleY - scope.getCenterOffset() * (double)scaleY * 0.0625 * scaledPos.getScale();
                    this.zOffset = (Boolean)Config.CLIENT.display.sight1xRealisticPosition.get() != false && scope.getAdditionalZoom().getZoomMultiple() == 1.0f ? (double)(-this.translateZ) + modifiedGun.getModules().getZoom().getZOffset() * 0.0625 * (double)scaleZ : (double)(-this.translateZ) - scaledPos.getZOffset() * 0.0625 * (double)scaleZ + 0.72 - viewFinderOffset * (double)scaleZ * scaledPos.getScale();
                }
                catch (NullPointerException e) {
                    GunMod.LOGGER.info("GunRenderingHandler NPE @509");
                }
                this.fix = Objects.equals(scope.getTagName(), "qmk152") ? -0.05 : (Objects.equals(scope.getTagName(), "elcan14x") ? -0.06 : (Objects.equals(scope.getTagName(), "acog4x") ? -0.03 : (Objects.equals(scope.getTagName(), "vlpvo6") ? -0.05 : (Objects.equals(scope.getTagName(), "gener8x") ? -0.06 : (Objects.equals(scope.getTagName(), "aimpoint2") || Objects.equals(scope.getTagName(), "eotechn") || Objects.equals(scope.getTagName(), "vortex1") || Objects.equals(scope.getTagName(), "eotechshort") ? -0.02 : 0.0)))));
            } else if (modifiedGun.canAttachType(IAttachment.Type.OLD_SCOPE) && scope != null) {
                double viewFinderOffset;
                double d = viewFinderOffset = isScopeOffsetType || isScopeRenderType ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset();
                if (OptifineHelper.isShadersEnabled()) {
                    viewFinderOffset *= 0.735;
                }
                scaledPos = modifiedGun.getModules().getAttachments().getOldScope();
                this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 + -scaledPos.getXOffset() * 0.0625 * (double)scaleX;
                this.yOffset = (double)(-this.translateY) + (8.0 - scaledPos.getYOffset()) * 0.0625 * (double)scaleY - scope.getCenterOffset() * (double)scaleY * 0.0625 * scaledPos.getScale();
                this.zOffset = (double)(-this.translateZ) - scaledPos.getZOffset() * 0.0625 * (double)scaleZ + 0.72 - viewFinderOffset * (double)scaleZ * scaledPos.getScale();
                this.fix = -0.05;
            } else if (modifiedGun.canAttachType(IAttachment.Type.PISTOL_SCOPE) && scope != null) {
                double viewFinderOffset;
                double d = viewFinderOffset = isScopeOffsetType || isScopeRenderType ? scope.getViewFinderOffsetSpecial() : scope.getViewFinderOffset();
                if (OptifineHelper.isShadersEnabled()) {
                    viewFinderOffset *= 0.735;
                }
                scaledPos = modifiedGun.getModules().getAttachments().getPistolScope();
                this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 + -scaledPos.getXOffset() * 0.0625 * (double)scaleX;
                this.yOffset = (double)(-this.translateY) + (8.0 - scaledPos.getYOffset()) * 0.0625 * (double)scaleY - scope.getCenterOffset() * (double)scaleY * 0.0625 * scaledPos.getScale();
                this.zOffset = (Boolean)Config.CLIENT.display.sight1xRealisticPosition.get() != false && scope.getAdditionalZoom().getZoomMultiple() == 1.0f ? (double)(-this.translateZ) + modifiedGun.getModules().getZoom().getZOffset() * 0.0625 * (double)scaleZ : (double)(-this.translateZ) - scaledPos.getZOffset() * 0.0625 * (double)scaleZ + 0.72 - viewFinderOffset * (double)scaleZ * scaledPos.getScale();
                this.fix = 0.0;
            } else if (modifiedGun.getModules().getZoom() != null) {
                this.xOffset = (double)(-this.translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 * (double)scaleX;
                this.yOffset = (double)(-this.translateY) + (8.0 - modifiedGun.getModules().getZoom().getYOffset() - 0.2) * 0.0625 * (double)scaleY;
                this.zOffset = (double)(-this.translateZ) + modifiedGun.getModules().getZoom().getZOffset() * 0.0625 * (double)scaleZ;
                this.fix = 0.0;
            }
            float side = right ? 1.0f : -1.0f;
            double transition = (float)AimingHandler.get().getLerpAdsProgress(event.getPartialTicks());
            float function = (float)(3.0 * Math.pow(transition - (double)0.33f, 2.0) - (double)0.33f);
            if (function > 1.0f) {
                function = 1.0f;
            }
            if (transition == 0.0) {
                function = 0.0f;
            }
            float result = this.aimingDynamics.update(0.05f, function);
            float resultFix = Math.min(result, 1.0f);
            float resultZ = this.aimingDynamics.update(0.05f, (float)transition);
            float resultZFix = Math.min(resultZ, 1.0f);
            matrixStack.func_227861_a_(this.xOffset * (double)side * (double)resultZ - 0.56 * (double)side * (double)resultZ, this.yOffset * (double)result + 0.52 * (double)resultFix - 0.07 + Math.abs(0.5 - (double)resultZFix) * 0.14 + this.fix, this.zOffset * (double)result - 0.036 + 0.06 * Math.abs(0.6 - (double)resultZ));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(5.0f * (1.0f - result)));
            matrixStack.func_227861_a_(0.0, (0.013 - this.fix) * (double)resultFix, 0.0);
            if (((Boolean)Config.COMMON.gameplay.realisticAimedBreathing.get()).booleanValue()) {
                double scopeJitterOffset = 0.8;
                scopeJitterOffset = scope == null ? (scopeJitterOffset *= modifiedGun.getModules().getZoom().getStabilityOffset()) : (scopeJitterOffset *= scope.getStabilityOffset());
                if (entity.func_213453_ef()) {
                    scopeJitterOffset *= 0.3;
                }
                if (entity.func_70051_ag() && !entity.func_213453_ef()) {
                    scopeJitterOffset *= 4.0;
                }
                if (entity.func_213322_ci().func_82615_a() != 0.0 || entity.func_213322_ci().func_82617_b() != 0.0 || entity.func_213322_ci().func_82616_c() != 0.0) {
                    scopeJitterOffset *= 6.5;
                }
                double yOffsetRatio = ScopeJitterHandler.getInstance().getYOffsetRatio() * (0.009375000000000001 * scopeJitterOffset);
                double xOffsetRatio = ScopeJitterHandler.getInstance().getXOffsetRatio() * (0.0074375000000000005 * scopeJitterOffset);
                Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_70125_A = (float)((double)Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_70125_A + yOffsetRatio);
                Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_70177_z = (float)((double)Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g).field_70177_z + xOffsetRatio);
            }
        }
        maxRotationDegree = ((Double)Config.CLIENT.display.weaponDelayedSwayMaximum.get()).floatValue();
        delayedSwayMultiplier = ((Double)Config.CLIENT.display.weaponDelayedSwayMultiplier.get()).floatValue();
        YDIR = (Boolean)Config.CLIENT.display.weaponDelayedSwayDirection.get() != false ? Vector3f.field_229180_c_ : Vector3f.field_229181_d_;
        this.applyDelayedSwayTransforms(matrixStack, entity, event.getPartialTicks());
        float equipProgress = this.getEquipProgress(event.getPartialTicks());
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(equipProgress * -50.0f));
        HandSide hand = right ? HandSide.RIGHT : HandSide.LEFT;
        Objects.requireNonNull(entity);
        int blockLight = entity.func_70027_ad() ? 15 : entity.field_70170_p.func_226658_a_(LightType.BLOCK, new BlockPos(entity.func_174824_e(event.getPartialTicks())));
        blockLight += this.entityIdForMuzzleFlash.contains(entity.func_145782_y()) ? 3 : 0;
        blockLight = Math.min(blockLight, 15);
        int packedLight = LightTexture.func_228451_a_((int)blockLight, (int)entity.field_70170_p.func_226658_a_(LightType.SKY, new BlockPos(entity.func_174824_e(event.getPartialTicks()))));
        int offset = right ? 1 : -1;
        matrixStack.func_227861_a_(0.56 * (double)offset, -0.52, -0.72);
        this.applySprintingTransforms(heldItem, hand, matrixStack, event.getPartialTicks());
        this.applyRecoilTransforms(matrixStack, heldItem, modifiedGun);
        if (!isAnimated) {
            this.applyReloadTransforms(matrixStack, hand, event.getPartialTicks(), heldItem);
        }
        matrixStack.func_227860_a_();
        IHeldAnimation pose = modifiedGun.getGeneral().getGripType().getHeldAnimation();
        if (pose != null) {
            if (!isAnimated) {
                matrixStack.func_227861_a_(-0.56, 0.52, 0.72);
            }
            if (!isAnimated) {
                pose.renderFirstPersonArms(Minecraft.func_71410_x().field_71439_g, hand, heldItem, matrixStack, event.getBuffers(), event.getLight(), event.getPartialTicks());
            }
        }
        matrixStack.func_227865_b_();
        ItemCameraTransforms.TransformType transformType = right ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
        this.renderWeapon((LivingEntity)Minecraft.func_71410_x().field_71439_g, heldItem, transformType, event.getMatrixStack(), event.getBuffers(), packedLight, event.getPartialTicks());
        matrixStack.func_227865_b_();
    }

    private void applyDelayedSwayTransforms(MatrixStack stack, ClientPlayerEntity player, float partialTicks) {
        this.applyDelayedSwayTransforms(stack, player, partialTicks, 1.0f);
    }

    private boolean checkIsLongRangeScope(ItemStack itemStack) {
        ItemStack attachmentStack;
        IAttachment.Type type;
        Gun gun = ((GunItem)itemStack.func_77973_b()).getModifiedGun(itemStack);
        if (!gun.canAttachType(type = IAttachment.Type.SCOPE) || !(attachmentStack = Gun.getAttachment(type, itemStack)).func_190926_b()) {
            // empty if block
        }
        return false;
    }

    public void applyDelayedSwayTransforms(MatrixStack stack, ClientPlayerEntity player, float partialTicks, float percentage) {
        if (((Boolean)Config.CLIENT.display.weaponDelayedSway.get()).booleanValue() && player != null) {
            float f4 = MathHelper.func_219799_g((float)partialTicks, (float)player.field_71163_h, (float)player.field_71154_f);
            float degree = this.delaySwayDynamics.update(0.0f, (player.func_195046_g(partialTicks) - f4) * delayedSwayMultiplier);
            if (Math.abs(degree) > maxRotationDegree) {
                degree = degree / Math.abs(degree) * maxRotationDegree;
            }
            degree = (float)((double)degree * (1.0 / Math.pow(MathUtil.fovToMagnification(this.currentHandLayerFov, this.originHandLayerFov), 2.0)));
            degree *= percentage;
            if (((Boolean)Config.CLIENT.display.weaponDelayedSwayYNOptical.get()).booleanValue() && Gun.getScope(player.func_184614_ca()) != null || YDIR.equals((Object)Vector3f.field_229180_c_)) {
                stack.func_227861_a_((double)this.translateX, (double)this.translateY, (double)this.translateZ);
                stack.func_227863_a_(YDIR.func_229187_a_(degree));
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(degree * 1.5f * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
                stack.func_227861_a_((double)(-this.translateX), (double)(-this.translateY), (double)(-this.translateZ));
            } else {
                stack.func_227861_a_((double)(-this.translateX), (double)(-this.translateY), (double)(-this.translateZ));
                stack.func_227863_a_(YDIR.func_229187_a_(degree));
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(degree * 1.5f * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
                stack.func_227861_a_((double)this.translateX, (double)this.translateY, (double)this.translateZ);
            }
        }
    }

    private void applyLightWeightAnimation(MatrixStack matrixStack, float leftHanded, float draw) {
        float result = this.sprintDynamicsHSS.update(0.05f, this.sOT) * draw;
        float result2 = this.sprintDynamicsZHSS.update(0.05f, this.sOT) * draw;
        matrixStack.func_227861_a_(0.215 * (double)leftHanded * (double)result, (double)(0.07f * result), (double)(-30.0f * leftHanded * result / 170.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(60.0f * result2));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-25.0f * result2));
    }

    private void applyDefaultAnimation(MatrixStack matrixStack, float leftHanded, float draw) {
        float result = this.sprintDynamics.update(0.05f, this.sOT) * draw;
        float result2 = this.sprintDynamicsZ.update(0.05f, this.sOT) * draw;
        matrixStack.func_227861_a_(-0.25 * (double)leftHanded * (double)result, -0.1 * (double)result - 0.1 + Math.abs(0.5 - (double)result) * 0.2, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(28.0f * leftHanded * result));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(15.0f * result2));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(20.0f * result2));
    }

    private void applySprintingTransforms(ItemStack gun, HandSide hand, MatrixStack matrixStack, float partialTicks) {
        TimelessGunItem modifiedGun = (TimelessGunItem)gun.func_77973_b();
        GunAnimationController controller = GunAnimationController.fromItem(gun.func_77973_b());
        float draw = controller == null || !controller.isAnimationRunning(GunAnimationController.AnimationLabel.DRAW) ? 1 : 0;
        float leftHanded = hand == HandSide.LEFT ? -1.0f : 1.0f;
        this.sOT = ((float)this.prevSprintTransition + (float)(this.sprintTransition - this.prevSprintTransition) * partialTicks) / 5.0f;
        this.wSpeed = GunRenderingHandler.getGunWeightSpeed(modifiedGun.getGun(), gun);
        if (this.wSpeed > 0.094f) {
            this.applyLightWeightAnimation(matrixStack, leftHanded, draw);
        } else {
            this.applyDefaultAnimation(matrixStack, leftHanded, draw);
        }
    }

    private static float getGunWeightSpeed(Gun gunType, ItemStack gun) {
        return ServerPlayHandler.calceldGunWeightSpeed(gunType, gun);
    }

    private void applyReloadTransforms(MatrixStack matrixStack, HandSide hand, float partialTicks, ItemStack modifiedGun) {
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks, modifiedGun);
        if (reloadProgress > 0.0f) {
            float leftHanded = hand == HandSide.LEFT ? -1.0f : 1.0f;
            matrixStack.func_227861_a_(-0.25 * (double)leftHanded, -0.1, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f * leftHanded));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-25.0f));
        }
    }

    private void applyRecoilTransforms(MatrixStack matrixStack, ItemStack item, Gun gun) {
        Minecraft mc = Minecraft.func_71410_x();
        double kickReduce = 1.0;
        double recoilNormal = RecoilHandler.get().getGunRecoilNormal();
        if (Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.SCOPE) || Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.PISTOL_SCOPE) || Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.OLD_SCOPE)) {
            recoilNormal -= recoilNormal * (0.25 * AimingHandler.get().getNormalisedAdsProgress());
            kickReduce = gun.getModules().getZoom().getFovModifier();
            if (kickReduce > 1.0) {
                kickReduce = 1.0;
            }
            if (kickReduce < 0.0) {
                kickReduce = 0.0;
            }
        }
        this.kickReduction = 1.0f - GunModifierHelper.getKickReduction(item);
        this.recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier(item);
        this.kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * RecoilHandler.get().getAdsRecoilReduction(gun) * kickReduce;
        this.recoilLift = (float)(RecoilHandler.get().getGunRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun);
        this.newSwayYawAmount = (float)(2.0 + 1.0 * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        this.newSwayYawPitch = (float)((double)(RecoilHandler.get().lastRandPitch * this.newSwayYawAmount - this.newSwayYawAmount / 2.0f) * recoilNormal) / 2.0f;
        this.newSwayYawYaw = (float)((double)(RecoilHandler.get().lastRandYaw * this.newSwayYawAmount - this.newSwayYawAmount / 2.0f) * recoilNormal) / 2.0f;
        float kickTiming = 0.11f;
        if (IDLNBTUtil.getInt(item, "CurrentFireMode") == 1) {
            this.newSwayYawAmount = (float)((double)this.newSwayYawAmount * 0.5);
            this.recoilLift = (float)((double)this.recoilLift * 0.925);
            kickTiming += 0.06f;
        }
        if (mc.field_71439_g != null && mc.field_71439_g.func_213453_ef()) {
            this.recoilLift = (float)((double)this.recoilLift * 0.875);
        }
        this.weaponsHorizontalAngle = (float)(RecoilHandler.get().getGunHorizontalRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun);
        float newKick = this.recoilDynamics.update(kickTiming, (float)this.kick * this.kickReduction);
        double magnification = MathUtil.fovToMagnification(this.currentHandLayerFov, this.originHandLayerFov);
        newKick = (float)((double)newKick * (1.0 / Math.pow(magnification, 0.3)));
        matrixStack.func_227861_a_(0.0, 0.0, (double)newKick);
        matrixStack.func_227861_a_(0.0, 0.05 * (double)newKick, 0.35 * (double)newKick);
        this.newSwayYaw = this.swayYawDynamics.update(0.09f, this.newSwayYawYaw * this.recoilReduction * this.weaponsHorizontalAngle);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.newSwayPitch * 0.2875f));
        this.newSwayPitch = this.swayPitchDynamics.update(0.21f, this.newSwayYawPitch * this.recoilReduction * this.recoilLift);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(this.newSwayPitch * 0.215f));
        if (gun.getGeneral().getWeaponRecoilOffset() != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.recoilLift * this.recoilReduction));
        }
        matrixStack.func_227861_a_(0.0, -0.05 * (double)newKick, -0.35 * (double)newKick);
    }

    public void applyBobbingTransforms(MatrixStack matrixStack, boolean convert) {
        matrixStack.func_227861_a_(0.0, 0.0, 0.25);
        float amplifier = this.bobbingDynamics.update(0.05f, (float)((double)((float)this.sprintTransition / 2.0f + 1.0f) * (1.0 - AimingHandler.get().getNormalisedAdsProgress() * 0.75)));
        float speedUp = this.speedUpDynamics.update(0.05f, this.speedUpProgress * (1.0f - this.sOT) * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float delta = -MathHelper.func_76126_a((float)(this.walkingDistance1 * (float)Math.PI)) * this.walkingCameraYaw * 0.5f * (convert ? -0.5f : 1.0f) * amplifier * (float)(8 - this.backwardTicker) / 8.0f;
        float delta2 = -MathHelper.func_76126_a((float)(this.walkingDistance1 * (float)Math.PI * 2.0f)) * this.walkingCameraYaw * 0.5f * (convert ? -0.35f : 1.0f) * amplifier * (float)(12 - this.backwardTicker) / 12.0f;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(35.0f * delta * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-3.0f * speedUp));
        matrixStack.func_227861_a_(0.0, 0.0, -0.25 + 0.07 * (double)speedUp);
        matrixStack.func_227861_a_(0.45 * (double)delta, 0.25 * (double)delta2, 0.0);
        if (this.wSpeed > 0.094f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(delta * 5.0f * (float)this.sprintTransition));
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(delta * 5.0f));
        }
    }

    public void applyBobbingTransforms(MatrixStack matrixStack, boolean convert, float effectMultiplier) {
        if (effectMultiplier == 0.0f) {
            effectMultiplier = 1.0f;
        }
        matrixStack.func_227861_a_(0.0, 0.0, 0.25);
        float amplifier = this.bobbingDynamics.update(0.05f, (float)((double)((float)this.sprintTransition / 2.0f + 1.0f) * (1.0 - AimingHandler.get().getNormalisedAdsProgress() * 0.75) * (double)(RecoilHandler.get().getRecoilProgress() == 0.0 ? 1 : 0)));
        float speedUp = this.speedUpDynamics.update(0.05f, this.speedUpProgress * (1.0f - this.sOT) * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float delta = -MathHelper.func_76126_a((float)(this.walkingDistance1 * (float)Math.PI)) * this.walkingCameraYaw * 0.5f * (convert ? -0.5f : 1.0f) * amplifier * (float)(8 - this.backwardTicker) / 8.0f;
        float delta2 = -MathHelper.func_76126_a((float)(this.walkingDistance1 * (float)Math.PI * 2.0f)) * this.walkingCameraYaw * 0.5f * (convert ? -0.35f : 1.0f) * amplifier * (float)(12 - this.backwardTicker) / 12.0f;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(35.0f * effectMultiplier * delta * (float)(1.0 - AimingHandler.get().getNormalisedAdsProgress())));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-3.0f * effectMultiplier * speedUp));
        matrixStack.func_227861_a_(0.0, 0.0, -0.25 + 0.07 * (double)effectMultiplier * (double)speedUp);
        matrixStack.func_227861_a_(0.45 * (double)effectMultiplier * (double)delta, 0.25 * (double)effectMultiplier * (double)delta2, 0.0);
        if (this.wSpeed > 0.094f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(delta * effectMultiplier * 5.0f * (float)this.sprintTransition));
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(delta * effectMultiplier * 5.0f));
        }
    }

    public void applyJumpingTransforms(MatrixStack matrixStack, float partialTicks) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        double posY = MathHelper.func_219803_d((double)partialTicks, (double)Minecraft.func_71410_x().field_71439_g.field_70137_T, (double)Minecraft.func_71410_x().field_71439_g.func_226278_cu_());
        float newVelocity = (float)(posY - Minecraft.func_71410_x().field_71439_g.field_70137_T) / partialTicks;
        float newAcceleration = newVelocity - this.velocity;
        Date date = new Date();
        if (Math.abs(this.acceleration) < Math.abs(newAcceleration) && (double)Math.abs(newAcceleration) > 0.05) {
            this.acceleration = newAcceleration;
            this.stepLength = this.acceleration / 250.0f;
        }
        long partialTime = date.getTime() - this.prevTime;
        if (this.acceleration > 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration < 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        if (this.acceleration < 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration > 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        float maxMotion = 0.265f;
        float transition = -this.jumpingDynamics.update(0.05f, (Math.abs(this.acceleration) < maxMotion ? this.acceleration / maxMotion * 0.15f : Math.abs(this.acceleration) / this.acceleration * 0.15f) * ((float)this.sprintTransition / 3.0f + 1.0f) * (1.0f - 0.7f * (float)AimingHandler.get().getNormalisedAdsProgress()));
        if (transition > 0.0f) {
            transition *= 0.8f;
        }
        matrixStack.func_227861_a_(0.0, (double)transition, 0.0);
        this.velocity = newVelocity;
        this.prevTime = date.getTime();
    }

    public void applyJumpingTransforms(MatrixStack matrixStack, float partialTicks, float reverser) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        double posY = MathHelper.func_219803_d((double)partialTicks, (double)Minecraft.func_71410_x().field_71439_g.field_70137_T, (double)Minecraft.func_71410_x().field_71439_g.func_226278_cu_());
        float newVelocity = (float)(posY - Minecraft.func_71410_x().field_71439_g.field_70137_T) / partialTicks;
        float newAcceleration = newVelocity - this.velocity;
        Date date = new Date();
        if (Math.abs(this.acceleration) < Math.abs(newAcceleration) && (double)Math.abs(newAcceleration) > 0.05) {
            this.acceleration = newAcceleration;
            this.stepLength = this.acceleration / 250.0f;
        }
        long partialTime = date.getTime() - this.prevTime;
        if (this.acceleration > 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration < 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        if (this.acceleration < 0.0f) {
            this.acceleration -= (float)partialTime * this.stepLength;
            if (this.acceleration > 0.0f) {
                this.acceleration = 0.0f;
            }
        }
        float maxMotion = 0.265f;
        float transition = -this.jumpingDynamics.update(0.05f, (Math.abs(this.acceleration) < maxMotion ? this.acceleration / maxMotion * 0.15f : Math.abs(this.acceleration) / this.acceleration * 0.15f) * ((float)this.sprintTransition / 3.0f + 1.0f) * (1.0f - 0.7f * (float)AimingHandler.get().getNormalisedAdsProgress()));
        if (transition > 0.0f) {
            transition *= 0.8f;
        }
        if (reverser != 0.0f) {
            transition *= reverser;
        }
        matrixStack.func_227861_a_(0.0, (double)transition, 0.0);
        this.velocity = newVelocity;
        this.prevTime = date.getTime();
    }

    public void applyNoiseMovementTransform(MatrixStack matrixStack) {
        if (AimingHandler.get().getNormalisedAdsProgress() == 1.0) {
            matrixStack.func_227861_a_((double)this.aimed_noiseX.getValue(), (double)this.aimed_noiseY.getValue(), 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.aimed_noiseRotationY.getValue()));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)((double)this.aimed_noiseRotationY.getValue() * 0.85)));
        } else {
            matrixStack.func_227861_a_((double)this.noiseX.getValue(), (double)this.noiseY.getValue(), 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.noiseRotationY.getValue()));
        }
    }

    public void applyNoiseMovementTransform(MatrixStack matrixStack, float reverser) {
        if (AimingHandler.get().getNormalisedAdsProgress() == 1.0) {
            matrixStack.func_227861_a_((double)(this.aimed_noiseX.getValue() * (reverser * 2.0f)), (double)(this.aimed_noiseY.getValue() * reverser), 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.aimed_noiseRotationY.getValue() * reverser));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)((double)this.aimed_noiseRotationY.getValue() * 0.85 * (double)reverser)));
        } else {
            matrixStack.func_227861_a_((double)(this.noiseX.getValue() * (reverser * 2.0f)), (double)(this.noiseY.getValue() * reverser), 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.noiseRotationY.getValue() * reverser));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onKnockback(LivingKnockBackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            if (!(player.func_184614_ca().func_77973_b() instanceof GunItem) && !((Boolean)Config.CLIENT.display.cameraShakeOptionGlobal.get()).booleanValue()) {
                return;
            }
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                if (serverPlayer.field_71135_a == null) {
                    return;
                }
                serverPlayer.field_71135_a.func_147298_b();
                PacketHandler.getPlayChannel().sendTo((Object)new MessagePlayerShake((LivingEntity)player), serverPlayer.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_195544_aj()) {
            return;
        }
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (player.func_184587_cr() && player.func_184600_cs() == Hand.MAIN_HAND && heldItem.func_77973_b() instanceof GrenadeItem) {
            float cookTime;
            if (!((GrenadeItem)heldItem.func_77973_b()).canCook()) {
                return;
            }
            int duration = player.func_184612_cw();
            if (duration >= 10 && (cookTime = 1.0f - (float)(duration - 10) / (float)(player.func_184607_cu().func_77988_m() - 10)) > 0.0f) {
                double scale = 3.0;
                MainWindow window = mc.func_228018_at_();
                int i = (int)((double)(window.func_198087_p() / 2 - 7 - 60) / scale);
                int j = (int)Math.ceil(((double)(window.func_198107_o() / 2) - 8.0 * scale) / scale);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                RenderSystem.pushMatrix();
                RenderSystem.scaled((double)scale, (double)scale, (double)scale);
                int progress = (int)Math.ceil(cookTime * 17.0f) - 1;
                MatrixStack matrixStack = new MatrixStack();
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)j, (int)i, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)j, (int)i, (float)52.0f, (float)94.0f, (int)progress, (int)4, (int)256, (int)256);
                RenderSystem.popMatrix();
                RenderSystem.disableBlend();
            }
            return;
        }
    }

    @SubscribeEvent
    public void onRenderHeldItem(RenderItemEvent.Held.Pre event) {
        Hand hand = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? (event.getHandSide() == HandSide.RIGHT ? Hand.MAIN_HAND : Hand.OFF_HAND) : (event.getHandSide() == HandSide.LEFT ? Hand.MAIN_HAND : Hand.OFF_HAND);
        LivingEntity entity = event.getEntity();
        ItemStack heldItem = entity.func_184586_b(hand);
        if (hand == Hand.OFF_HAND) {
            Gun modifiedGun;
            if (heldItem.func_77973_b() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            if (entity.func_184614_ca().func_77973_b() instanceof GunItem && !(modifiedGun = ((GunItem)entity.func_184614_ca().func_77973_b()).getModifiedGun(entity.func_184614_ca())).getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem()) {
                event.setCanceled(true);
                return;
            }
        }
        if (heldItem.func_77973_b() instanceof GunItem) {
            CompoundNBT compound;
            event.setCanceled(true);
            if (heldItem.func_77978_p() != null && (compound = heldItem.func_77978_p()).func_150297_b("Scale", 5)) {
                float scale = compound.func_74760_g("Scale");
                event.getMatrixStack().func_227862_a_(scale, scale, scale);
            }
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            if (entity instanceof PlayerEntity) {
                gun.getGeneral().getGripType().getHeldAnimation().applyHeldItemTransforms((PlayerEntity)entity, hand, AimingHandler.get().getAimProgress((PlayerEntity)entity, event.getPartialTicks()), event.getMatrixStack(), event.getRenderTypeBuffer());
            }
            this.renderWeapon(entity, heldItem, event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onSetupAngles(PlayerModelEvent.SetupAngles.Post event) {
        if (event.getAgeInTicks() == 0.0f) {
            event.getModelPlayer().field_178723_h.field_78795_f = 0.0f;
            event.getModelPlayer().field_178723_h.field_78796_g = 0.0f;
            event.getModelPlayer().field_178723_h.field_78808_h = 0.0f;
            event.getModelPlayer().field_178724_i.field_78795_f = 0.0f;
            event.getModelPlayer().field_178724_i.field_78796_g = 0.0f;
            event.getModelPlayer().field_178724_i.field_78808_h = 0.0f;
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GunItem) {
            PlayerModel model = event.getModelPlayer();
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            gun.getGeneral().getGripType().getHeldAnimation().applyPlayerModelRotation(player, model, Hand.MAIN_HAND, AimingHandler.get().getAimProgress((PlayerEntity)event.getEntity(), event.getPartialTicks()));
            GunRenderingHandler.copyModelAngles(model.field_178723_h, model.field_178732_b);
            GunRenderingHandler.copyModelAngles(model.field_178724_i, model.field_178734_a);
        }
    }

    private static void copyModelAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GunItem) {
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            gun.getGeneral().getGripType().getHeldAnimation().applyPlayerPreRender(player, Hand.MAIN_HAND, AimingHandler.get().getAimProgress((PlayerEntity)event.getEntity(), event.getPartialRenderTick()), event.getMatrixStack(), event.getBuffers());
        }
    }

    @SubscribeEvent
    public void onModelRender(PlayerModelEvent.Render.Pre event) {
        PlayerEntity player = event.getPlayer();
        ItemStack offHandStack = player.func_184592_cb();
        if (offHandStack.func_77973_b() instanceof GunItem) {
            switch (player.func_184591_cq().func_188468_a()) {
                case LEFT: {
                    event.getModelPlayer().field_187075_l = BipedModel.ArmPose.EMPTY;
                    break;
                }
                case RIGHT: {
                    event.getModelPlayer().field_187076_m = BipedModel.ArmPose.EMPTY;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(PlayerModelEvent.Render.Post event) {
        MatrixStack matrixStack = event.getMatrixStack();
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184592_cb();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GunItem) {
            matrixStack.func_227860_a_();
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            if (gun.getGeneral().getGripType().getHeldAnimation().applyOffhandTransforms(player, event.getModelPlayer(), heldItem, matrixStack, event.getPartialTicks())) {
                IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                this.renderWeapon((LivingEntity)player, heldItem, ItemCameraTransforms.TransformType.FIXED, matrixStack, (IRenderTypeBuffer)buffer, event.getLight(), event.getPartialTicks());
            }
            matrixStack.func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Entity.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!event.getTransformType().equals((Object)ItemCameraTransforms.TransformType.GUI)) {
            event.setCanceled(this.renderWeapon((LivingEntity)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks()));
        }
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Gui.Pre event) {
        if (!((Boolean)Config.CLIENT.quality.reducedQualityHotBar.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            event.setCanceled(this.renderWeapon((LivingEntity)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks()));
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemEvent.ItemFrame.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        event.setCanceled(this.renderWeapon((LivingEntity)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks()));
    }

    public boolean renderWeapon(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (stack.func_77973_b() instanceof GunItem) {
            Gun.ScaledPositioned positioned;
            ItemStack attachmentStack;
            Scope scope;
            IAttachment.Type type;
            Gun gun;
            matrixStack.func_227860_a_();
            ItemStack model = ItemStack.field_190927_a;
            if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Model", 10)) {
                model = ItemStack.func_199557_a((CompoundNBT)stack.func_77978_p().func_74775_l("Model"));
            }
            RenderUtil.applyTransformType(model.func_190926_b() ? stack : model, matrixStack, transformType, entity);
            if (ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND.equals((Object)transformType) && (gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack)).canAttachType(type = IAttachment.Type.SCOPE) && (scope = Gun.getScope(stack)) != null && !(attachmentStack = Gun.getAttachment(type, stack)).func_190926_b() && (positioned = gun.getAttachmentPosition(type)) != null) {
                double transition = AimingHandler.get().getLerpAdsProgress(partialTicks);
                double displayX = positioned.getXOffset() * 0.0625;
                double displayY = positioned.getYOffset() * 0.0625;
                double displayZ = positioned.getZOffset() * 0.0625;
                this.currentHandLayerFov = MathHelper.func_219799_g((float)((float)transition), (float)this.originHandLayerFov, (float)(scope.isNeedSqueeze() ? this.aimingHandLayerFov : 55.0f));
                float zScale = (float)Math.tan((double)(this.currentHandLayerFov / 180.0f) * Math.PI / 2.0) / (float)Math.tan((double)(this.originHandLayerFov / 180.0f) * Math.PI / 2.0);
                matrixStack.func_227861_a_(displayX, displayY, displayZ);
                matrixStack.func_227861_a_(0.0, -0.5, 0.0);
                matrixStack.func_227862_a_(1.0f, 1.0f, zScale);
                matrixStack.func_227861_a_(0.0, 0.5, 0.0);
                matrixStack.func_227861_a_(-displayX, -displayY, -displayZ);
                matrixStack.func_227861_a_(0.0, 0.0, (double)((float)transition * scope.getAdditionalZoom().getZoomZTransition()) * 0.0625 / (double)zScale);
            }
            this.renderGun(entity, transformType, model.func_190926_b() ? stack : model, matrixStack, renderTypeBuffer, light, partialTicks);
            this.renderAttachments(entity, transformType, stack, matrixStack, renderTypeBuffer, light, partialTicks);
            this.renderMuzzleFlash(entity, matrixStack, renderTypeBuffer, stack, transformType);
            this.renderShellCasing(entity, matrixStack, renderTypeBuffer, stack, transformType, renderTypeBuffer, light, partialTicks);
            matrixStack.func_227865_b_();
            return true;
        }
        return false;
    }

    public boolean renderScope(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (stack.func_77973_b() instanceof ScopeItem || stack.func_77973_b() instanceof PistolScopeItem || stack.func_77973_b() instanceof OldScopeItem) {
            matrixStack.func_227860_a_();
            ItemStack model = ItemStack.field_190927_a;
            RenderUtil.applyTransformType(model.func_190926_b() ? stack : model, matrixStack, transformType, entity);
            this.renderGun(entity, transformType, model.func_190926_b() ? stack : model, matrixStack, renderTypeBuffer, light, partialTicks);
            matrixStack.func_227865_b_();
            return true;
        }
        return false;
    }

    private void renderGun(LivingEntity entity, ItemCameraTransforms.TransformType transformType, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (stack.func_77973_b() instanceof ITimelessAnimated) {
            RenderUtil.renderModel(stack, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_, entity);
        }
        if (ModelOverrides.hasModel(stack)) {
            IOverrideModel model = ModelOverrides.getModel(stack);
            if (model != null) {
                if (ModelOverrides.hasModel(stack) && transformType.equals((Object)ItemCameraTransforms.TransformType.GUI) && !((Boolean)Config.CLIENT.quality.reducedQualityHotBar.get()).booleanValue()) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(25.0f));
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-145.0f));
                    matrixStack.func_227862_a_(0.55f, 0.55f, 0.55f);
                }
                model.render(partialTicks, transformType, stack, ItemStack.field_190927_a, entity, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_);
            }
        } else {
            RenderUtil.renderModel(stack, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_, entity);
        }
        if (ModelOverrides.hasModel(stack) && transformType.equals((Object)ItemCameraTransforms.TransformType.GUI) && !((Boolean)Config.CLIENT.quality.reducedQualityHotBar.get()).booleanValue()) {
            matrixStack.func_227865_b_();
        }
    }

    private void renderAttachments(LivingEntity entity, ItemCameraTransforms.TransformType transformType, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (stack.func_77973_b() instanceof GunItem) {
            Gun gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
            CompoundNBT gunTag = stack.func_196082_o();
            CompoundNBT attachments = gunTag.func_74775_l("Attachments");
            for (String tagKey : attachments.func_150296_c()) {
                Gun.ScaledPositioned positioned;
                ItemStack attachmentStack;
                IAttachment.Type type = IAttachment.Type.byTagKey(tagKey);
                if (!gun.canAttachType(type) || (attachmentStack = Gun.getAttachment(type, stack)).func_190926_b() || (positioned = gun.getAttachmentPosition(type)) == null) continue;
                double displayX = positioned.getXOffset() * 0.0625;
                double displayY = positioned.getYOffset() * 0.0625;
                double displayZ = positioned.getZOffset() * 0.0625;
                matrixStack.func_227860_a_();
                GunAnimationController controller = GunAnimationController.fromItem(stack.func_77973_b());
                if (controller != null) {
                    if (type != null) {
                        if (controller instanceof PistalAnimationController && gun.getModules().getAttachments().getPistolScope() != null && gun.getModules().getAttachments().getPistolScope().getDoOnSlideMovement()) {
                            PistalAnimationController pcontroller = (PistalAnimationController)controller;
                            controller.applyTransform(stack, pcontroller.getSlideNodeIndex(), transformType, entity, matrixStack);
                        } else {
                            controller.applyAttachmentsTransform(stack, transformType, entity, matrixStack);
                        }
                    } else {
                        controller.applyAttachmentsTransform(stack, transformType, entity, matrixStack);
                    }
                }
                matrixStack.func_227861_a_(displayX, displayY, displayZ);
                matrixStack.func_227861_a_(0.0, -0.5, 0.0);
                matrixStack.func_227862_a_((float)positioned.getScale(), (float)positioned.getScale(), (float)positioned.getScale());
                IOverrideModel model = ModelOverrides.getModel(attachmentStack);
                if (model != null) {
                    model.render(partialTicks, transformType, attachmentStack, stack, entity, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_);
                } else {
                    RenderUtil.renderModel(attachmentStack, stack, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_);
                }
                matrixStack.func_227865_b_();
            }
        }
    }

    private void renderMuzzleFlash(LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, ItemStack weapon, ItemCameraTransforms.TransformType transformType) {
        Gun modifiedGun = ((GunItem)weapon.func_77973_b()).getModifiedGun(weapon);
        if (modifiedGun.getDisplay().getFlash() == null) {
            return;
        }
        if ((modifiedGun.canAttachType(IAttachment.Type.BARREL) || modifiedGun.canAttachType(IAttachment.Type.PISTOL_BARREL)) && GunModifierHelper.isSilencedFire(weapon)) {
            return;
        }
        if ((transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) && this.entityIdForMuzzleFlash.contains(entity.func_145782_y())) {
            float randomValue;
            this.drawMuzzleFlash(weapon, modifiedGun, randomValue, (randomValue = this.entityIdToRandomValue.get(entity.func_145782_y()).floatValue()) >= 0.5f, matrixStack, buffer);
        }
    }

    private void renderShellCasing(LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, ItemStack weapon, ItemCameraTransforms.TransformType transformType, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        Gun modifiedGun = ((GunItem)weapon.func_77973_b()).getModifiedGun(weapon);
        if (modifiedGun.getDisplay().getShellCasing() == null) {
            return;
        }
        if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            for (ShellInAir shell : this.shells) {
                matrixStack.func_227860_a_();
                Vector3f pos = shell.origin.func_229195_e_();
                Vector3f dis1 = shell.preDisplacement.func_229195_e_();
                Vector3f dis2 = shell.displacement.func_229195_e_();
                dis1.func_195898_a(1.0f - partialTicks);
                dis2.func_195898_a(partialTicks);
                pos.func_229189_a_(dis1);
                pos.func_229189_a_(dis2);
                Vector3f rot = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f rot1 = shell.preRotation.func_229195_e_();
                Vector3f rot2 = shell.rotation.func_229195_e_();
                rot1.func_195898_a(1.0f - partialTicks);
                rot2.func_195898_a(partialTicks);
                rot.func_229189_a_(rot1);
                rot.func_229189_a_(rot2);
                float displayXv = pos.func_195899_a() * 0.0625f;
                float displayYv = pos.func_195900_b() * 0.0625f;
                float displayZv = pos.func_195902_c() * 0.0625f;
                float scale = (float)modifiedGun.getDisplay().getShellCasing().getScale();
                matrixStack.func_227861_a_((double)displayXv, (double)displayYv, (double)displayZv);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rot.func_195899_a()));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot.func_195900_b()));
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rot.func_195902_c()));
                matrixStack.func_227862_a_(scale, scale, scale);
                IBakedModel caseModel = modifiedGun.getDisplay().getShellCasing().getCasingModel() != null ? Minecraft.func_71410_x().func_209506_al().getModel(modifiedGun.getDisplay().getShellCasing().getCasingModel()) : SpecialModels.BULLET_SHELL.getModel();
                RenderUtil.renderModel(caseModel, weapon, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_);
                matrixStack.func_227865_b_();
            }
        }
    }

    private void drawMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean flip, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        matrixStack.func_227860_a_();
        Gun.Display.Flash muzzleFlash = modifiedGun.getDisplay().getFlash();
        if (muzzleFlash == null) {
            return;
        }
        this.displayX = ((Gun.Positioned)muzzleFlash).getXOffset();
        this.displayY = ((Gun.Positioned)muzzleFlash).getYOffset();
        this.displayZ = ((Gun.Positioned)muzzleFlash).getZOffset() + (double)this.muzzleExtraOnEnch;
        double displayXv = this.displayX * 0.0625;
        double displayYv = this.displayY * 0.0625;
        double displayZv = this.displayZ * 0.0625;
        if (GunRenderingHandler.get().muzzleExtraOnEnch != 0.0f) {
            this.muzzleExtraOnEnch = 0.0f;
        }
        this.displayX *= 0.0625;
        this.displayY *= 0.0625;
        this.displayZ *= 0.0625;
        this.adjustedTrailZ = modifiedGun.getDisplay().getFlash().getTrailAdjust();
        matrixStack.func_227861_a_(displayXv, displayYv, displayZv);
        matrixStack.func_227861_a_(0.0, -0.5, 0.0);
        ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, weapon);
        if (!barrelStack.func_190926_b() && barrelStack.func_77973_b() instanceof IBarrel) {
            Barrel barrel = (Barrel)((IBarrel)barrelStack.func_77973_b()).getProperties();
            Gun.ScaledPositioned positioned = modifiedGun.getModules().getAttachments().getBarrel();
            if (positioned != null) {
                matrixStack.func_227861_a_(0.0, 0.0, (double)(-barrel.getLength()) * 0.0625 * positioned.getScale());
            }
        }
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.0f);
        double partialSize = modifiedGun.getDisplay().getFlash().getSize() / 5.0;
        float size = (float)(modifiedGun.getDisplay().getFlash().getSize() - partialSize + partialSize * (double)random);
        size = (float)GunModifierHelper.getMuzzleFlashSize(weapon, size);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(360.0f * random));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(flip ? 180.0f : 0.0f));
        matrixStack.func_227861_a_((double)(-size / 2.0f), (double)(-size / 2.0f), 0.0);
        float sizeForTrail = (float)(1.0 - partialSize + partialSize);
        this.sizeZ = -sizeForTrail;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(GunRenderType.getMuzzleFlash());
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(matrix, size, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(matrix, size, size, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, size, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
        matrixStack.func_227865_b_();
    }

    private float getEquipProgress(float partialTicks) {
        if (this.equippedProgressMainHandField == null) {
            this.equippedProgressMainHandField = ObfuscationReflectionHelper.findField(FirstPersonRenderer.class, (String)"field_187469_f");
            this.equippedProgressMainHandField.setAccessible(true);
        }
        if (this.prevEquippedProgressMainHandField == null) {
            this.prevEquippedProgressMainHandField = ObfuscationReflectionHelper.findField(FirstPersonRenderer.class, (String)"field_187470_g");
            this.prevEquippedProgressMainHandField.setAccessible(true);
        }
        FirstPersonRenderer firstPersonRenderer = Minecraft.func_71410_x().func_175597_ag();
        try {
            float equippedProgressMainHand = ((Float)this.equippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            float prevEquippedProgressMainHand = ((Float)this.prevEquippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            return 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)prevEquippedProgressMainHand, (float)equippedProgressMainHand);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    static {
        MUZZLE_FLASH_TEXTURE = new ResourceLocation("tac", "textures/effect/muzzle_flash.png");
        MUZZLE_SMOKE_TEXTURE = new ResourceLocation("tac", "textures/effect/muzzle_smoke.png");
    }

    public static class ShellInAir {
        public int livingTick;
        public Vector3f preDisplacement = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f displacement = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f preRotation = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        public Vector3f origin;
        public Vector3f velocity;
        public Vector3f angularVelocity;

        public ShellInAir(@Nonnull Vector3f origin, @Nonnull Vector3f velocity, @Nonnull Vector3f angularVelocity, int life) {
            this.origin = origin.func_229195_e_();
            this.velocity = velocity.func_229195_e_();
            this.angularVelocity = angularVelocity.func_229195_e_();
            this.livingTick = life;
        }
    }
}

