/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tac.guns.Config;
import com.tac.guns.client.BulletTrail;
import com.tac.guns.client.GunRenderType;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.handler.GunRenderingHandler;
import com.tac.guns.client.handler.ShootingHandler;
import com.tac.guns.client.util.RenderUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BulletTrailRenderingHandler {
    private static BulletTrailRenderingHandler instance;
    private Map<Integer, BulletTrail> bullets = new HashMap<Integer, BulletTrail>();

    public static BulletTrailRenderingHandler get() {
        if (instance == null) {
            instance = new BulletTrailRenderingHandler();
        }
        return instance;
    }

    private BulletTrailRenderingHandler() {
    }

    public void add(BulletTrail trail) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            this.bullets.put(trail.getEntityId(), trail);
        }
    }

    public void remove(int entityId) {
        this.bullets.remove(entityId);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            if (event.phase == TickEvent.Phase.END) {
                this.bullets.values().forEach(BulletTrail::tick);
                this.bullets.values().removeIf(BulletTrail::isDead);
            }
        } else if (!this.bullets.isEmpty()) {
            this.bullets.clear();
        }
    }

    public void render(MatrixStack stack, float partialSticks) {
        for (BulletTrail bulletTrail : this.bullets.values()) {
            this.renderBulletTrail(bulletTrail, stack, partialSticks);
        }
    }

    @SubscribeEvent
    public void onRespawn(ClientPlayerNetworkEvent.RespawnEvent event) {
        this.bullets.clear();
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.bullets.clear();
    }

    private void renderBulletTrail(BulletTrail bulletTrail, MatrixStack matrixStack, float partialTicks) {
        IVertexBuilder builder;
        RenderType bulletType;
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity == null || bulletTrail.isDead() || !((Boolean)Config.CLIENT.display.showBulletTrails.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)Config.CLIENT.display.showFirstPersonBulletTrails.get()).booleanValue() && Minecraft.func_71410_x().field_71439_g.func_70028_i(entity)) {
            return;
        }
        matrixStack.func_227860_a_();
        Vector3d view = mc.field_71460_t.func_215316_n().func_216785_c();
        Vector3d position = bulletTrail.getPosition();
        Vector3d motion = bulletTrail.getMotion();
        double bulletX = position.field_72450_a + motion.field_72450_a * (double)partialTicks;
        double bulletY = position.field_72448_b + motion.field_72448_b * (double)partialTicks;
        double bulletZ = position.field_72449_c + motion.field_72449_c * (double)partialTicks;
        Vector3d motionVec = new Vector3d(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        float length = (float)motionVec.func_72433_c();
        if (Minecraft.func_71410_x().field_71439_g.func_70028_i(entity)) {
            if (mc.field_71439_g.func_70040_Z().field_72448_b > 0.945) {
                length = (float)((double)length * 0.25);
            } else if (mc.field_71439_g.func_70040_Z().field_72448_b > 0.385) {
                matrixStack.func_227861_a_(0.0, (double)-0.115f * mc.field_71439_g.func_70040_Z().field_72448_b, 0.0);
            }
        }
        if (ShootingHandler.get().isShooting() && Minecraft.func_71410_x().field_71439_g.func_70028_i(entity) && bulletTrail.getAge() < 1) {
            matrixStack.func_227861_a_(bulletX - view.func_82615_a(), bulletY - view.func_82617_b() - (double)0.145f, bulletZ - view.func_82616_c());
            if (AimingHandler.get().isAiming()) {
                matrixStack.func_227861_a_(0.0, (double)-0.685f, 0.0);
            }
        } else {
            matrixStack.func_227861_a_(bulletX - view.func_82615_a(), bulletY - view.func_82617_b() - 0.125, bulletZ - view.func_82616_c());
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bulletTrail.getYaw()));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-bulletTrail.getPitch() + 90.105f));
        float trailLength = (float)((double)(length / 3.0f) * bulletTrail.getTrailLengthMultiplier());
        float red = (float)(bulletTrail.getTrailColor() >> 16 & 0xFF) / 255.0f;
        float green = (float)(bulletTrail.getTrailColor() >> 8 & 0xFF) / 255.0f;
        float blue = (float)(bulletTrail.getTrailColor() & 0xFF) / 255.0f;
        float alpha = ((Double)Config.CLIENT.display.bulletTrailOpacity.get()).floatValue();
        Entity shooter = bulletTrail.getShooter();
        if (shooter != null && Minecraft.func_71410_x().field_71439_g.func_70028_i(shooter)) {
            trailLength = AimingHandler.get().getNormalisedAdsProgress() > 0.4 ? (float)Math.min((double)(trailLength + 0.6f), shooter.func_174824_e(partialTicks).func_72438_d(new Vector3d(bulletX, bulletY, bulletZ)) / (double)1.175f) : (float)Math.min((double)(trailLength + 0.6f), shooter.func_174824_e(partialTicks).func_72438_d(new Vector3d(bulletX, bulletY, bulletZ)) / (double)1.0975f);
        }
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = mc.func_228019_au_().func_228487_b_();
        if (bulletTrail.getAge() < 1 && Minecraft.func_71410_x().field_71439_g.func_70028_i(entity) && !AimingHandler.get().isAiming()) {
            bulletType = GunRenderType.getBulletTrail();
            builder = renderTypeBuffer.getBuffer(bulletType);
            float posSize = 0.1f;
            builder.func_227888_a_(matrix4f, 0.0f, trailLength / 1.325f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, -(posSize *= bulletTrail.getSize() * 10.0f)).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            matrixStack.func_227862_a_(1.5f, 1.5f, 1.825f);
            matrixStack.func_227861_a_(GunRenderingHandler.get().sizeZ / 17.25, -GunRenderingHandler.get().sizeZ / 2.0, 0.0);
            matrixStack.func_227861_a_(GunRenderingHandler.get().displayX, GunRenderingHandler.get().displayY, GunRenderingHandler.get().displayZ);
            matrixStack.func_227861_a_(0.0, 0.0, GunRenderingHandler.get().adjustedTrailZ - 0.02);
            builder.func_227888_a_(matrix4f, 0.0f, -trailLength / 1.325f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, posSize).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(bulletType);
        } else {
            bulletType = GunRenderType.getBulletTrail();
            builder = renderTypeBuffer.getBuffer(bulletType);
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.225f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, -0.225f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, trailLength * 1.15f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, -trailLength * 1.15f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, -0.225f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.225f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, -0.225f, 0.0f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.225f, 0.0f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, trailLength * 1.15f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, -trailLength * 1.15f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(bulletType);
        }
        if (!bulletTrail.getItem().func_190926_b() && !bulletTrail.isTrailVisible()) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)bulletTrail.getAge() + partialTicks) * 50.0f));
            matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
            int combinedLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)entity.field_70170_p, (BlockPos)new BlockPos(entity.func_213303_ch()));
            ItemStack stack = bulletTrail.getItem();
            RenderUtil.renderModel(stack, ItemCameraTransforms.TransformType.NONE, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, combinedLight, OverlayTexture.field_229196_a_, null, null);
        }
        matrixStack.func_227865_b_();
    }
}

