/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.gunskin;

import com.tac.guns.client.SpecialModel;
import com.tac.guns.client.gunskin.DefaultSkin;
import com.tac.guns.client.gunskin.IModelComponent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public class GunSkin {
    protected final Map<IModelComponent, SpecialModel> models = new HashMap<IModelComponent, SpecialModel>();
    protected Map<IModelComponent, Vector3d> extraOffset;
    public final ResourceLocation registerName;
    public final ResourceLocation gun;
    protected ResourceLocation icon;
    protected ResourceLocation miniIcon;
    private DefaultSkin defaultSkin;

    public GunSkin(String skinName, String gun, DefaultSkin skin) {
        this.registerName = ResourceLocation.func_208304_a((String)("tac:" + skinName));
        this.gun = ResourceLocation.func_208304_a((String)("tac:" + gun));
        this.defaultSkin = skin;
    }

    public GunSkin(ResourceLocation registerName, String gun, DefaultSkin skin) {
        this.gun = ResourceLocation.func_208304_a((String)("tac:" + gun));
        this.registerName = registerName;
        this.defaultSkin = skin;
    }

    public GunSkin(ResourceLocation skinName, ResourceLocation gun, DefaultSkin skin) {
        this.registerName = skinName;
        this.gun = gun;
        this.defaultSkin = skin;
    }

    protected GunSkin(ResourceLocation registerName, ResourceLocation gun) {
        this.gun = gun;
        this.registerName = registerName;
    }

    public void setDefaultSkin(DefaultSkin defaultSkin) {
        this.defaultSkin = defaultSkin;
    }

    @Nullable
    public SpecialModel getModel(IModelComponent component) {
        return this.models.getOrDefault(component, this.defaultSkin.getModel(component));
    }

    protected void addComponent(IModelComponent component, SpecialModel model) {
        this.models.put(component, model);
    }

    public Map<IModelComponent, SpecialModel> getModels() {
        return this.models;
    }

    @Nullable
    public ResourceLocation getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return this.defaultSkin.getIcon();
    }

    public void setIcon(ResourceLocation icon) {
        this.icon = icon;
    }

    @Nullable
    public ResourceLocation getMiniIcon() {
        if (this.miniIcon != null) {
            return this.miniIcon;
        }
        return this.defaultSkin.getMiniIcon();
    }

    public void setMiniIcon(ResourceLocation miniIcon) {
        this.miniIcon = miniIcon;
    }

    public void cleanCache() {
        for (SpecialModel model : this.models.values()) {
            model.cleanCache();
        }
    }
}

