/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.entity.ai.GoToEntityPositionGoal;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import net.smileycorp.hordes.common.infection.network.CureEntityMessage;
import net.smileycorp.hordes.common.infection.network.InfectionPacketHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEntity.class})
public abstract class MixinMobEntity
extends LivingEntity {
    public MixinMobEntity(World world) {
        super(null, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"checkAndHandleImportantInteractions(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResultType;"}, cancellable=true)
    public void checkAndHandleImportantInteractions(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> callback) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70644_a((Effect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            this.func_195063_d((Effect)HordesInfection.INFECTED.get());
            if (!player.field_70170_p.field_72995_K) {
                InfectionPacketHandler.NETWORK_INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> player.field_70170_p.func_175726_f(this.func_226268_ag_())), (Object)new CureEntityMessage((Entity)this));
            }
            if (!player.func_184812_l_()) {
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                if (stack.func_77984_f() && player instanceof ServerPlayerEntity) {
                    stack.func_96631_a(1, player.field_70170_p.field_73012_v, (ServerPlayerEntity)player);
                } else {
                    stack.func_190918_g(1);
                }
                if (stack.func_190926_b() && !container.func_190926_b()) {
                    player.func_184611_a(hand, container);
                }
            }
            callback.setReturnValue((Object)ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K));
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSunBurnTick()Z"}, cancellable=true)
    public void isSunBurnTick(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof AbstractSkeletonEntity & (Boolean)CommonConfigHandler.skeletonsBurn.get() == false) {
            callback.setReturnValue((Object)false);
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldDespawnInPeaceful()Z"}, cancellable=true)
    public void shouldDespawnInPeaceful(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof ZombieHorseEntity && ((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
            callback.setReturnValue((Object)true);
            callback.cancel();
        }
    }

    @ModifyVariable(method={"convertTo"}, at=@At(value="STORE", ordinal=0))
    private MobEntity convertTo(MobEntity converted) {
        String uuid;
        LazyOptional beforeOptional = this.getCapability(Hordes.HORDESPAWN);
        LazyOptional afterOptional = converted.getCapability(Hordes.HORDESPAWN);
        if (beforeOptional.isPresent() && afterOptional.isPresent() && ((IHordeSpawn)beforeOptional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = ((IHordeSpawn)beforeOptional.resolve().get()).getPlayerUUID()))) {
            LazyOptional optionalp;
            ((IHordeSpawn)afterOptional.resolve().get()).setPlayerUUID(uuid);
            ((IHordeSpawn)beforeOptional.resolve().get()).setPlayerUUID("");
            ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(UUID.fromString(uuid));
            if (player != null && (optionalp = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent()) {
                ((IHordeEvent)optionalp.resolve().get()).registerEntity(converted);
                ((IHordeEvent)optionalp.resolve().get()).removeEntity((MobEntity)this);
            }
        }
        return converted;
    }

    @Inject(at={@At(value="TAIL")}, method={"convertTo(Lnet/minecraft/entity/EntityType;Z)Lnet/minecraft/entity/MobEntity;"}, cancellable=true)
    public void convertTo(EntityType<?> type, boolean keepEquipment, CallbackInfoReturnable<MobEntity> callback) {
        ServerPlayerEntity player;
        String uuid;
        MobEntity converted = (MobEntity)callback.getReturnValue();
        LazyOptional optional = converted.getCapability(Hordes.HORDESPAWN);
        if (optional.isPresent() && ((IHordeSpawn)optional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = ((IHordeSpawn)optional.resolve().get()).getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(UUID.fromString(uuid))) != null) {
            converted.field_70714_bg.func_75776_a(6, (Goal)new GoToEntityPositionGoal(converted, (Entity)player));
        }
    }
}

